/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.IProgressConstants;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.HttpConnectionInputStream;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.StreamGobbler;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.LoginDialog;
import org.rssowl.ui.internal.services.Messages;
import org.rssowl.ui.internal.util.DownloadJobQueue;
import org.rssowl.ui.internal.util.JobRunner;

public class DownloadService {
    private static final int MAX_CONCURRENT_DOWNLOAD_JOBS = 3;
    private static final int DEFAULT_CON_TIMEOUT = 30000;
    private static final int DEFAULT_TASK_LENGTH = 1000000;
    private static final int DEFAULT_WORKED = 200;
    private static final List<Character> INVALID_FILENAME_CHAR = Arrays.asList(Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('?'), Character.valueOf('|'), Character.valueOf('*'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'));
    private static final SimpleDateFormat DOWNLOAD_FILE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm", Locale.US);
    private static final String DOWNLOAD_PART_SUFFIX = ".part";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename=";
    private static final List<String> HTML_CONTENT_TYPES = Arrays.asList("text/html", "application/xhtml+xml");
    private DownloadJobQueue fDownloadQueue;
    private Map<OutputStream, OutputStream> fOutputStreamMap = new ConcurrentHashMap<OutputStream, OutputStream>();
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();

    public DownloadService() {
        this.fDownloadQueue = new DownloadJobQueue(Messages.DownloadService_DOWNLOADING_TITLE, 3, Integer.MAX_VALUE);
    }

    public void download(DownloadRequest download) {
        AttachmentDownloadTask task = new AttachmentDownloadTask(download);
        if (InternalOwl.TESTING) {
            this.internalDownload(download, (Job)new StreamGobbler(null), (IProgressMonitor)new NullProgressMonitor());
        } else if (!this.fDownloadQueue.isQueued(task)) {
            this.fDownloadQueue.schedule(task);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus internalDownload(final DownloadRequest request, Job job, final IProgressMonitor monitor) {
        int bytesConsumed;
        String downloadFileName;
        block80: {
            if (Controller.getDefault().isOffline()) {
                return Status.OK_STATUS;
            }
            downloadFileName = StringUtils.isSet((String)request.getUserChosenFilename()) ? request.getUserChosenFilename() : URIUtils.getFile((URI)request.fLink, (String)OwlUI.getExtensionForMime(request.getType()));
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)OwlUI.getAttachmentImage(downloadFileName, request.getType()));
            bytesConsumed = 0;
            try {
                IProtocolHandler handler = Owl.getConnectionService().getHandler(request.getLink());
                if (handler == null) break block80;
                HashMap<String, Integer> properties = new HashMap<String, Integer>();
                properties.put("CON_TIMEOUT", 30000);
                if (monitor.isCanceled()) return Status.CANCEL_STATUS;
                if (Controller.getDefault().isShuttingDown()) {
                    return Status.CANCEL_STATUS;
                }
                long bytesPerSecond = 0L;
                long lastTaskNameUpdate = 0L;
                long lastBytesCheck = 0L;
                int length = request.getLength();
                byte[] buffer = new byte[8192];
                int contentLength = length;
                InputStream in = null;
                FileOutputStream out = null;
                File partFile = null;
                boolean canceled = false;
                Throwable error = null;
                try {
                    String contentType;
                    int len;
                    in = handler.openStream(request.getLink(), monitor, properties);
                    if (in instanceof HttpConnectionInputStream && (len = ((HttpConnectionInputStream)in).getContentLength()) > 0) {
                        contentLength = len;
                    }
                    if (request.isNewsDownloadRequest() && in instanceof HttpConnectionInputStream && this.isTextualContent(contentType = ((HttpConnectionInputStream)in).getContentType())) {
                        canceled = true;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    job.setName(NLS.bind((String)Messages.DownloadService_DOWNLOADING, (Object)downloadFileName));
                    monitor.beginTask(this.formatTask(bytesConsumed, contentLength, -1), contentLength > 0 ? contentLength : 1000000);
                    partFile = this.getPartFile(request.getTargetFolder(), downloadFileName);
                    if (partFile == null) {
                        canceled = true;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    out = new FileOutputStream(partFile);
                    this.fOutputStreamMap.put(out, out);
                    while (true) {
                        if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                            canceled = true;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        int read = in.read(buffer);
                        bytesConsumed += read;
                        if (read != -1) {
                            out.write(buffer, 0, read);
                            long now = System.currentTimeMillis();
                            long timeDiff = now - lastTaskNameUpdate;
                            if (timeDiff > 1000L) {
                                long bytesDiff = (long)bytesConsumed - lastBytesCheck;
                                bytesPerSecond = bytesDiff / (timeDiff / 1000L);
                                monitor.setTaskName(this.formatTask(bytesConsumed, contentLength, (int)bytesPerSecond));
                                lastTaskNameUpdate = now;
                                lastBytesCheck = bytesConsumed;
                            }
                            if (request.getLength() > 0) {
                                monitor.worked(read);
                                continue;
                            }
                            if (contentLength > 0) {
                                float relWorked = (float)read / (float)contentLength;
                                monitor.worked((int)(relWorked * 1000000.0f));
                                continue;
                            }
                            monitor.worked(200);
                            continue;
                        }
                        break;
                    }
                }
                catch (FileNotFoundException e) {
                    error = e;
                    IStatus iStatus = Activator.getDefault().createErrorStatus(e.getMessage(), e);
                    return iStatus;
                }
                catch (IOException e) {
                    error = e;
                    IStatus iStatus = Activator.getDefault().createErrorStatus(e.getMessage(), e);
                    return iStatus;
                }
                catch (ConnectionException e) {
                    Shell shell;
                    final boolean[] showError = new boolean[]{true};
                    if (request.isUserInitiated() && e instanceof AuthenticationRequiredException && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown() && (shell = OwlUI.getActiveShell()) != null && !shell.isDisposed()) {
                        Controller.getDefault().getLoginDialogLock().lock();
                        try {
                            final AuthenticationRequiredException authEx = (AuthenticationRequiredException)e;
                            JobRunner.runSyncedInUIThread((Widget)shell, new Runnable(){

                                public void run() {
                                    if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                                        return;
                                    }
                                    try {
                                        URI normalizedUri = URIUtils.normalizeUri((URI)request.getLink(), (boolean)true);
                                        if (Owl.getConnectionService().getAuthCredentials(normalizedUri, authEx.getRealm()) != null) {
                                            DownloadService.this.fDownloadQueue.schedule(new AttachmentDownloadTask(request));
                                            showError[0] = false;
                                            return;
                                        }
                                    }
                                    catch (CredentialsException exe) {
                                        Activator.getDefault().getLog().log(exe.getStatus());
                                    }
                                    LoginDialog login = new LoginDialog(shell, request.getLink(), authEx.getRealm());
                                    if (login.open() == 0 && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                                        DownloadService.this.fDownloadQueue.schedule(new AttachmentDownloadTask(request));
                                        showError[0] = false;
                                    }
                                }
                            });
                        }
                        finally {
                            Controller.getDefault().getLoginDialogLock().unlock();
                        }
                    }
                    if (showError[0]) {
                        error = e;
                        IStatus iStatus = Activator.getDefault().createErrorStatus(e.getMessage(), e);
                        return iStatus;
                    }
                    monitor.setCanceled(true);
                    canceled = true;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                    if (error != null) {
                        String errorMessage = CoreUtils.toMessage((Throwable)error);
                        if (StringUtils.isSet((String)errorMessage)) {
                            job.setName(NLS.bind((String)Messages.DownloadService_ERROR_DOWNLOADING_N, (Object)downloadFileName, (Object)errorMessage));
                        } else {
                            job.setName(NLS.bind((String)Messages.DownloadService_ERROR_DOWNLOADING, (Object)downloadFileName));
                        }
                        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)OwlUI.ERROR);
                        DownloadRequest redownloadRequest = new DownloadRequest(request.getLink(), request.getTargetFolder(), request.getAttachment(), request.getNews(), true, request.getUserChosenFilename());
                        job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)this.getRedownloadAction(new AttachmentDownloadTask(redownloadRequest)));
                        monitor.setTaskName(Messages.DownloadService_TRY_AGAIN);
                    }
                    if (out != null) {
                        try {
                            out.close();
                            this.fOutputStreamMap.remove(out);
                            if (partFile != null && (canceled || error != null)) {
                                partFile.delete();
                            }
                        }
                        catch (IOException e) {
                            return Activator.getDefault().createErrorStatus(e.getMessage(), e);
                        }
                    }
                    if (in != null) {
                        try {
                            if ((canceled || error != null) && in instanceof IAbortable) {
                                ((IAbortable)in).abort();
                            } else {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            return Activator.getDefault().createErrorStatus(e.getMessage(), e);
                        }
                    }
                }
                if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                    if (partFile == null) return Status.CANCEL_STATUS;
                    partFile.delete();
                    return Status.CANCEL_STATUS;
                }
                if (partFile == null) {
                    return Status.CANCEL_STATUS;
                }
                String finalFileName = StringUtils.isSet((String)request.getUserChosenFilename()) ? request.getUserChosenFilename() : this.getDownloadFileName(request, in);
                File downloadFile = new File(request.getTargetFolder(), finalFileName);
                if (!partFile.renameTo(downloadFile)) {
                    downloadFile.delete();
                    partFile.renameTo(downloadFile);
                }
                if (!this.fPreferences.getBoolean(DefaultPreferences.HIDE_COMPLETED_DOWNLOADS)) {
                    job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
                    job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)this.getOpenAction(downloadFile));
                }
            }
            catch (ConnectionException e) {
                return Activator.getDefault().createErrorStatus(e.getMessage(), e);
            }
        }
        if (bytesConsumed > 0) {
            job.setName(NLS.bind((String)Messages.DownloadService_N_OF_M, (Object)downloadFileName, (Object)OwlUI.getSize(bytesConsumed)));
            return new Status(0, "org.rssowl.ui", Messages.DownloadService_OPEN_FOLDER);
        }
        job.setName(downloadFileName);
        return new Status(0, "org.rssowl.ui", Messages.DownloadService_OPEN_FOLDER);
    }

    private boolean isTextualContent(String contentType) {
        if (StringUtils.isSet((String)contentType)) {
            for (String htmlContentType : HTML_CONTENT_TYPES) {
                if (!contentType.contains(htmlContentType)) continue;
                return true;
            }
        }
        return false;
    }

    private File getPartFile(File targetFolder, String name) throws IOException {
        name = this.toValidFileName(name);
        File partFile = null;
        int i = 0;
        while (i < 10) {
            partFile = i == 0 ? new File(targetFolder, String.valueOf(name) + DOWNLOAD_PART_SUFFIX) : new File(targetFolder, String.valueOf(name) + "_" + i + DOWNLOAD_PART_SUFFIX);
            if (!partFile.exists() && partFile.createNewFile()) break;
            ++i;
        }
        if (partFile != null) {
            partFile.deleteOnExit();
        }
        return partFile;
    }

    private String toValidFileName(String fileName) {
        for (Character invalidChar : INVALID_FILENAME_CHAR) {
            fileName = fileName.replace(invalidChar.charValue(), '_');
        }
        return fileName;
    }

    private String getDownloadFileName(DownloadRequest request, InputStream inS) {
        String contentDisposition;
        int indexOfFileName;
        String downloadFileName = null;
        if (inS instanceof HttpConnectionInputStream && StringUtils.isSet((String)((HttpConnectionInputStream)inS).getContentDisposition()) && (indexOfFileName = (contentDisposition = ((HttpConnectionInputStream)inS).getContentDisposition()).indexOf(CONTENT_DISPOSITION_FILENAME)) != -1) {
            contentDisposition = contentDisposition.substring(indexOfFileName + CONTENT_DISPOSITION_FILENAME.length());
            contentDisposition = StringUtils.replaceAll((String)contentDisposition, (String)"\"", (String)"");
            downloadFileName = contentDisposition.trim();
        }
        if (!StringUtils.isSet(downloadFileName)) {
            downloadFileName = URIUtils.getFile((URI)request.getLink(), (String)OwlUI.getExtensionForMime(request.getType()));
        }
        downloadFileName = this.toValidFileName(downloadFileName);
        File proposedFile = new File(request.getTargetFolder(), downloadFileName);
        if (proposedFile.exists()) {
            Date date;
            INews news = request.getNews();
            if (news == null) {
                news = request.getAttachment().getNews();
            }
            if ((date = DateUtils.getRecentDate((INews)news)) != null) {
                String fileNameSuffix = DOWNLOAD_FILE_DATE_FORMAT.format(date);
                int index = downloadFileName.lastIndexOf(46);
                if (index == -1) {
                    downloadFileName = String.valueOf(downloadFileName) + "_" + fileNameSuffix;
                } else {
                    String pre = downloadFileName.substring(0, index);
                    String post = downloadFileName.substring(index);
                    downloadFileName = String.valueOf(pre) + "_" + fileNameSuffix + post;
                }
            }
        }
        return downloadFileName;
    }

    private String formatTask(int bytesConsumed, int totalBytes, int bytesPerSecond) {
        String total;
        String consumed;
        int secondsRemaining;
        String period;
        StringBuilder str = new StringBuilder();
        int bytesToGo = totalBytes - bytesConsumed;
        if (bytesToGo > 0 && bytesPerSecond > 0 && (period = OwlUI.getPeriod(secondsRemaining = bytesToGo / bytesPerSecond)) != null) {
            str.append(NLS.bind((String)Messages.DownloadService_BYTES_REMAINING, (Object)period)).append(" - ");
        }
        if ((consumed = OwlUI.getSize(bytesConsumed)) == null) {
            consumed = "0";
        }
        if ((total = OwlUI.getSize(totalBytes)) != null) {
            str.append(NLS.bind((String)Messages.DownloadService_BYTES_OF_BYTES, (Object)consumed, (Object)total));
        } else {
            str.append(NLS.bind((String)Messages.DownloadService_BYTES_OF_UNKNOWN, (Object)consumed));
        }
        if (bytesPerSecond > 0) {
            str.append(" ");
            str.append(NLS.bind((String)Messages.DownloadService_BYTES_PER_SECOND, (Object)OwlUI.getSize(bytesPerSecond)));
        }
        return str.toString();
    }

    private IAction getOpenAction(final File downloadFile) {
        return new Action(Messages.DownloadService_OPEN_FOLDER){

            public void run() {
                Program.launch((String)downloadFile.getParent());
            }
        };
    }

    private IAction getRedownloadAction(final AttachmentDownloadTask task) {
        return new Action(Messages.DownloadService_RE_DOWNLOAD){

            public void run() {
                DownloadService.this.fDownloadQueue.schedule(task);
            }
        };
    }

    public void stopService() {
        this.fDownloadQueue.cancel(false);
        Set<OutputStream> openStreams = this.fOutputStreamMap.keySet();
        for (OutputStream out : openStreams) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isActive() {
        return this.fDownloadQueue.isWorking();
    }

    private class AttachmentDownloadTask
    extends DownloadJobQueue.DownloadTask {
        private final DownloadRequest fRequest;

        private AttachmentDownloadTask(DownloadRequest request) {
            this.fRequest = request;
        }

        public IStatus run(Job job, IProgressMonitor monitor) {
            return DownloadService.this.internalDownload(this.fRequest, job, monitor);
        }

        public String getName() {
            return NLS.bind((String)Messages.DownloadService_DOWNLOADING_N, (Object)this.fRequest.getLink().toString());
        }

        public ITask.Priority getPriority() {
            return ITask.Priority.DEFAULT;
        }

        public int hashCode() {
            return this.fRequest.getLink().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttachmentDownloadTask other = (AttachmentDownloadTask)obj;
            return this.fRequest.getLink().equals(other.fRequest.getLink());
        }
    }

    public static class DownloadRequest {
        private final URI fLink;
        private final File fTargetFolder;
        private final IAttachment fAttachment;
        private final INews fNews;
        private final boolean fIsUserInitiated;
        private final String fUserChosenFilename;

        public static DownloadRequest createAttachmentDownloadRequest(IAttachment attachment, URI link, File targetFolder, boolean isUserInitiated, String userChosenFilename) {
            return new DownloadRequest(link, targetFolder, attachment, null, isUserInitiated, userChosenFilename);
        }

        public static DownloadRequest createNewsDownloadRequest(INews news, URI link, File targetFolder) {
            return new DownloadRequest(link, targetFolder, null, news, false, null);
        }

        private DownloadRequest(URI link, File targetFolder, IAttachment attachment, INews news, boolean isUserInitiated, String userChosenFilename) {
            this.fLink = link;
            this.fTargetFolder = targetFolder;
            this.fAttachment = attachment;
            this.fNews = news;
            this.fIsUserInitiated = isUserInitiated;
            this.fUserChosenFilename = userChosenFilename;
        }

        URI getLink() {
            return this.fLink;
        }

        File getTargetFolder() {
            return this.fTargetFolder;
        }

        IAttachment getAttachment() {
            return this.fAttachment;
        }

        INews getNews() {
            return this.fNews;
        }

        String getUserChosenFilename() {
            return this.fUserChosenFilename;
        }

        boolean isUserInitiated() {
            return this.fIsUserInitiated;
        }

        String getType() {
            return this.fAttachment != null ? this.fAttachment.getType() : null;
        }

        int getLength() {
            return this.fAttachment != null ? this.fAttachment.getLength() : 0;
        }

        boolean isAttachmentDownloadRequest() {
            return this.fAttachment != null;
        }

        boolean isNewsDownloadRequest() {
            return this.fNews != null;
        }
    }
}

