/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;
import org.rssowl.core.util.ITask;

public class JobTracker {
    private final int fDelay;
    private final boolean fShowProgress;
    private final boolean fRunInUIThread;
    private Job fJob;
    private ITask fTask;
    private volatile boolean fRunning;

    public JobTracker(int delay, boolean showProgress, ITask.Priority priority) {
        this(delay, showProgress, false, priority);
    }

    public JobTracker(int delay, boolean showProgress, boolean runInUIThread, ITask.Priority priority) {
        this.fDelay = delay;
        this.fShowProgress = showProgress;
        this.fRunInUIThread = runInUIThread;
        this.createJob(priority);
    }

    public int getDelay() {
        return this.fDelay;
    }

    public void run(ITask task) {
        this.cancel();
        this.fTask = task;
        this.fRunning = true;
        this.fJob.schedule((long)this.getDelay());
    }

    private void createJob(ITask.Priority priority) {
        this.fJob = this.fRunInUIThread ? new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!monitor.isCanceled() && JobTracker.this.fTask != null) {
                        IStatus iStatus = JobTracker.this.fTask.run(monitor);
                        return iStatus;
                    }
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    JobTracker.this.fRunning = false;
                }
            }

            public boolean belongsTo(Object family) {
                return family == JobTracker.this;
            }
        } : new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (!monitor.isCanceled() && JobTracker.this.fTask != null) {
                        IStatus iStatus = JobTracker.this.fTask.run(monitor);
                        return iStatus;
                    }
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    JobTracker.this.fRunning = false;
                }
            }

            public boolean belongsTo(Object family) {
                return family == JobTracker.this;
            }
        };
        if (!this.fShowProgress) {
            this.fJob.setSystem(true);
        }
        if (priority == ITask.Priority.INTERACTIVE) {
            this.fJob.setPriority(10);
        } else if (priority == ITask.Priority.SHORT) {
            this.fJob.setPriority(20);
        }
    }

    public void cancel() {
        if (!this.fRunning) {
            return;
        }
        Job.getJobManager().cancel((Object)this);
        this.fRunning = false;
    }

    public boolean isRunning() {
        return this.fRunning;
    }
}

