/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.NewsColumn;
import org.rssowl.ui.internal.editors.feed.NewsColumnViewModel;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.Messages;

public class NewsColumnSelectionControl
extends Composite {
    private ListViewer fNewsColumnViewer;
    private FontMetrics fFontMetrics;
    private NewsColumnViewModel fModel;
    private ComboViewer fSortByViewer;
    private ComboViewer fSortAscendingViewer;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;

    public NewsColumnSelectionControl(Composite parent, int style) {
        super(parent, style);
        this.initMetrics();
        this.initComponents();
    }

    private void initMetrics() {
        GC gc = new GC((Drawable)this);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void initComponents() {
        this.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        this.fNewsColumnViewer = new ListViewer((Composite)this, 2562);
        this.fNewsColumnViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.fNewsColumnViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fNewsColumnViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                NewsColumn column = (NewsColumn)((Object)element);
                return column.getName();
            }
        });
        this.fNewsColumnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewsColumnSelectionControl.this.updateMoveEnablement();
                NewsColumnSelectionControl.this.updateRemoveEnablement();
            }
        });
        Composite buttonContainer = new Composite((Composite)this, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(1, 1, false, false));
        final Menu menu = new Menu((Decorations)this.getShell(), 8);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                NewsColumn[] newsColumns;
                MenuItem[] items;
                MenuItem[] menuItemArray = items = menu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                NewsColumn[] newsColumnArray = newsColumns = NewsColumn.values();
                int n3 = newsColumns.length;
                n = 0;
                while (n < n3) {
                    final NewsColumn column = newsColumnArray[n];
                    if (column.isSelectable() && !NewsColumnSelectionControl.this.fModel.contains(column)) {
                        MenuItem item = new MenuItem(menu, 8);
                        item.setText(column.getName());
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                NewsColumnSelectionControl.this.fModel.addColumn(column);
                                NewsColumnSelectionControl.this.fNewsColumnViewer.add((Object)column);
                                NewsColumnSelectionControl.this.updateRemoveEnablement();
                                NewsColumnSelectionControl.this.fNewsColumnViewer.setSelection((ISelection)new StructuredSelection((Object)column));
                            }
                        });
                    }
                    ++n;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        final Button addButton = new Button(buttonContainer, 1024);
        this.setButtonLayoutData(addButton);
        addButton.setText(Messages.NewsColumnSelectionControl_ADD);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = addButton.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = addButton.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OwlUI.safeDispose(menu);
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.setButtonLayoutData(this.fRemoveButton);
        this.fRemoveButton.setText(Messages.NewsColumnSelectionControl_REMOVE);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsColumnSelectionControl.this.onDelete();
            }
        });
        this.fMoveUpButton = new Button(buttonContainer, 8);
        this.setButtonLayoutData(this.fMoveUpButton);
        this.fMoveUpButton.setText(Messages.NewsColumnSelectionControl_MOVE_UP);
        this.fMoveUpButton.setEnabled(false);
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsColumnSelectionControl.this.onMove(true);
            }
        });
        this.fMoveDownButton = new Button(buttonContainer, 8);
        this.setButtonLayoutData(this.fMoveDownButton);
        this.fMoveDownButton.setText(Messages.NewsColumnSelectionControl_MOVE_DOWN);
        this.fMoveDownButton.setEnabled(false);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsColumnSelectionControl.this.onMove(false);
            }
        });
        Composite sortByContainer = new Composite((Composite)this, 0);
        sortByContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        sortByContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Label sortByLabel = new Label(sortByContainer, 0);
        sortByLabel.setText(Messages.NewsColumnSelectionControl_SORT_BY);
        this.fSortByViewer = new ComboViewer(sortByContainer, 2056);
        this.fSortByViewer.getCombo().setVisibleItemCount(20);
        this.fSortByViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fSortByViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                NewsColumn column = (NewsColumn)((Object)element);
                return column.getName();
            }
        });
        this.fSortByViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element != NewsColumn.RELEVANCE;
            }
        });
        this.fSortByViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                NewsColumn column = (NewsColumn)((Object)selection.getFirstElement());
                NewsColumnSelectionControl.this.fModel.setSortColumn(column);
            }
        });
        this.fSortAscendingViewer = new ComboViewer(sortByContainer, 2056);
        this.fSortAscendingViewer.getCombo().setVisibleItemCount(2);
        this.fSortAscendingViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fSortAscendingViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Order)((Object)element)).getName();
            }
        });
        this.fSortAscendingViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Order order = (Order)((Object)selection.getFirstElement());
                NewsColumnSelectionControl.this.fModel.setAscending(order == Order.ASCENDING);
            }
        });
    }

    private void onMove(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.fNewsColumnViewer.getSelection();
        Object element = selection.getFirstElement();
        List<NewsColumn> columns = this.fModel.getColumns();
        int index = columns.indexOf(element);
        if (up && index > 0) {
            columns.remove(element);
            columns.add(index - 1, (NewsColumn)((Object)element));
        } else if (index < columns.size() - 1) {
            columns.remove(element);
            columns.add(index + 1, (NewsColumn)((Object)element));
        }
        this.fNewsColumnViewer.refresh();
        this.fNewsColumnViewer.getList().showSelection();
        this.updateMoveEnablement();
    }

    private void updateMoveEnablement() {
        boolean enableMoveUp = true;
        boolean enableMoveDown = true;
        int[] selectionIndices = this.fNewsColumnViewer.getList().getSelectionIndices();
        if (selectionIndices.length == 1) {
            enableMoveUp = selectionIndices[0] != 0;
            enableMoveDown = selectionIndices[0] != this.fNewsColumnViewer.getList().getItemCount() - 1;
        } else {
            enableMoveUp = false;
            enableMoveDown = false;
        }
        this.fMoveUpButton.setEnabled(enableMoveUp);
        this.fMoveDownButton.setEnabled(enableMoveDown);
    }

    private void updateRemoveEnablement() {
        this.fRemoveButton.setEnabled(this.fNewsColumnViewer.getList().getItemCount() > 1 && !this.fNewsColumnViewer.getSelection().isEmpty());
    }

    public void setInput(NewsColumnViewModel model) {
        this.fModel = model;
        this.fNewsColumnViewer.setInput(model.getColumns());
        this.fSortByViewer.setInput((Object)NewsColumn.values());
        this.fSortByViewer.setSelection((ISelection)new StructuredSelection((Object)model.getSortColumn()));
        this.fSortAscendingViewer.setInput((Object)Order.values());
        this.fSortAscendingViewer.setSelection((ISelection)new StructuredSelection((Object)(model.isAscending() ? Order.ASCENDING : Order.DESCENDING)));
    }

    public NewsColumnViewModel getModel() {
        return this.fModel;
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fFontMetrics, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void onDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.fNewsColumnViewer.getSelection();
        List elements = selection.toList();
        for (Object element : elements) {
            this.fModel.removeColumn((NewsColumn)((Object)element));
            this.fNewsColumnViewer.remove(element);
        }
        if (this.fModel.getColumns().isEmpty()) {
            this.fModel.addColumn(NewsColumn.TITLE);
            this.fNewsColumnViewer.add((Object)NewsColumn.TITLE);
        }
        this.updateRemoveEnablement();
        this.updateMoveEnablement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Order {
        ASCENDING(Messages.NewsColumnSelectionControl_ASCENDING),
        DESCENDING(Messages.NewsColumnSelectionControl_DESCENDING);

        private String fName;

        private Order(String name) {
            this.fName = name;
        }

        String getName() {
            return this.fName;
        }
    }
}

