/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.event.ModelEvent;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookMarkFilter
extends ViewerFilter {
    private StringMatcher fMatcher;
    private Type fType = Type.SHOW_ALL;
    private SearchTarget fSearchTarget = SearchTarget.NAME;

    public final boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fMatcher == null && this.fType == Type.SHOW_ALL) {
            return true;
        }
        return this.isElementVisible(viewer, element);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.fMatcher == null && this.fType == Type.SHOW_ALL) {
            return elements;
        }
        return super.filter(viewer, parent, elements);
    }

    public boolean isFilterProperty(Object element, String property) {
        return false;
    }

    SearchTarget getSearchTarget() {
        return this.fSearchTarget;
    }

    public void setSearchTarget(SearchTarget searchTarget) {
        this.fSearchTarget = searchTarget;
    }

    public void setType(Type type) {
        if (this.fType != type) {
            this.fType = type;
        }
    }

    Type getType() {
        return this.fType;
    }

    public void setPattern(String patternString) {
        this.fMatcher = patternString == null || patternString.equals("") ? null : new StringMatcher(String.valueOf(patternString) + "*", true, false);
    }

    private boolean match(String string) {
        if (this.fMatcher == null) {
            return true;
        }
        return this.fMatcher.match(string);
    }

    boolean needsRefresh(Class<? extends IEntity> entityClass, Set<? extends ModelEvent> events) {
        return this.needsRefresh(entityClass, events, false);
    }

    boolean needsRefresh(Class<? extends IEntity> entityClass, Set<? extends ModelEvent> events, boolean searchResultsChanged) {
        if (this.fMatcher == null && this.fType == Type.SHOW_ALL) {
            return false;
        }
        if (entityClass.equals(INews.class)) {
            if (this.fType == Type.SHOW_NEW) {
                return CoreUtils.isNewStateChange(events);
            }
            if (this.fType == Type.SHOW_UNREAD) {
                return CoreUtils.isReadStateChange(events);
            }
            if (this.fType == Type.SHOW_STICKY) {
                return CoreUtils.isStickyStateChange(events);
            }
        } else if (IBookMark.class.isAssignableFrom(entityClass)) {
            if (this.fMatcher != null) {
                return true;
            }
            if (this.fType == Type.SHOW_NEVER_VISITED || this.fType == Type.SHOW_ERRONEOUS) {
                return true;
            }
        } else if (ISearchMark.class.isAssignableFrom(entityClass) || INewsBin.class.isAssignableFrom(entityClass)) {
            if (this.fMatcher != null && !searchResultsChanged) {
                return true;
            }
            if (this.fType == Type.SHOW_NEW || this.fType == Type.SHOW_UNREAD) {
                return true;
            }
        }
        return false;
    }

    boolean isElementVisible(Viewer viewer, Object element) {
        return this.isParentMatch(viewer, element) || this.isLeafMatch(viewer, element);
    }

    boolean isElementSelectable(Object element) {
        return element != null;
    }

    private boolean isParentMatch(Viewer viewer, Object element) {
        if (!(viewer instanceof AbstractTreeViewer)) {
            return false;
        }
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children != null && children.length > 0) {
            return this.filter(viewer, element, children).length > 0;
        }
        return false;
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof INewsMark) {
            INewsMark newsmark = (INewsMark)element;
            boolean isMatch = false;
            switch (this.fType) {
                case SHOW_ALL: {
                    isMatch = true;
                    break;
                }
                case SHOW_NEW: {
                    isMatch = newsmark.getNewsCount(EnumSet.of(INews.State.NEW)) > 0;
                    break;
                }
                case SHOW_UNREAD: {
                    isMatch = newsmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED)) > 0;
                    break;
                }
                case SHOW_STICKY: {
                    if (!(newsmark instanceof IBookMark)) break;
                    IBookMark bookmark = (IBookMark)newsmark;
                    isMatch = bookmark.getStickyNewsCount() > 0;
                    break;
                }
                case SHOW_ERRONEOUS: {
                    if (!(newsmark instanceof IBookMark)) break;
                    isMatch = ((IBookMark)newsmark).isErrorLoading();
                    break;
                }
                case SHOW_NEVER_VISITED: {
                    boolean bl = isMatch = newsmark.getPopularity() <= 0;
                }
            }
            if (isMatch && this.fMatcher != null && !this.wordMatches((IFolderChild)newsmark) && !this.wordMatches((IFolderChild)newsmark.getParent())) {
                return false;
            }
            return isMatch;
        }
        return false;
    }

    private String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    private boolean wordMatches(IFolderChild node) {
        if (node.getParent() == null) {
            return false;
        }
        if (this.fSearchTarget == SearchTarget.NAME) {
            return this.wordMatches(node.getName());
        }
        if (this.fSearchTarget == SearchTarget.LINK && node instanceof IBookMark) {
            return this.wordMatches(((IBookMark)node).getFeedLinkReference().getLinkAsText());
        }
        return false;
    }

    protected boolean wordMatches(String text) {
        String[] words;
        if (text == null) {
            return false;
        }
        if (this.match(text)) {
            return true;
        }
        String[] stringArray = words = this.getWords(text);
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (this.match(word)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchTarget {
        NAME,
        LINK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SHOW_ALL,
        SHOW_NEW,
        SHOW_UNREAD,
        SHOW_ERRONEOUS,
        SHOW_NEVER_VISITED,
        SHOW_STICKY;

    }
}

