/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.Attachment;
import org.rssowl.core.internal.persist.BookMark;
import org.rssowl.core.internal.persist.Category;
import org.rssowl.core.internal.persist.CloudAdapter;
import org.rssowl.core.internal.persist.ConditionalGet;
import org.rssowl.core.internal.persist.Feed;
import org.rssowl.core.internal.persist.FilterAction;
import org.rssowl.core.internal.persist.Folder;
import org.rssowl.core.internal.persist.Guid;
import org.rssowl.core.internal.persist.Image;
import org.rssowl.core.internal.persist.Label;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.NewsBin;
import org.rssowl.core.internal.persist.Person;
import org.rssowl.core.internal.persist.Preference;
import org.rssowl.core.internal.persist.Search;
import org.rssowl.core.internal.persist.SearchCondition;
import org.rssowl.core.internal.persist.SearchField;
import org.rssowl.core.internal.persist.SearchFilter;
import org.rssowl.core.internal.persist.SearchMark;
import org.rssowl.core.internal.persist.Source;
import org.rssowl.core.internal.persist.TextInputAdapter;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.ICloud;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.ITextInput;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.reference.FeedLinkReference;

public class DefaultModelFactory
implements IModelFactory {
    public INews createNews(Long id, IFeed feed, Date receiveDate) {
        News news = new News(id, feed, receiveDate);
        feed.addNews(news);
        return news;
    }

    public INews createNews(INews news, INewsBin newsBin) {
        Assert.isNotNull((Object)newsBin.getId(), (String)"ID of the Bin must not be null!");
        News copy = new News((News)news, newsBin.getId());
        copy.setId(Owl.getPersistenceService().getIDGenerator().getNext());
        newsBin.addNews(copy);
        return copy;
    }

    public IPerson createPerson(Long id, IPersistable parentRef) {
        Person person = new Person(id);
        if (parentRef instanceof IFeed) {
            ((IFeed)parentRef).setAuthor(person);
        } else if (parentRef instanceof INews) {
            ((INews)parentRef).setAuthor(person);
        }
        return person;
    }

    public IImage createImage(IFeed feed) {
        Image image = new Image();
        feed.setImage(image);
        return image;
    }

    public IAttachment createAttachment(Long id, INews news) {
        Attachment attachment = new Attachment(id, news);
        news.addAttachment(attachment);
        return attachment;
    }

    public ICategory createCategory(Long id, IEntity parent) {
        Category category = new Category(id);
        if (parent instanceof IFeed) {
            ((IFeed)parent).addCategory(category);
        } else if (parent instanceof INews) {
            ((INews)parent).addCategory(category);
        }
        return category;
    }

    public ISource createSource(INews news) {
        Source source = new Source();
        news.setSource(source);
        return source;
    }

    public IGuid createGuid(INews news, String value, Boolean permaLink) {
        Guid guid = new Guid(value, permaLink);
        news.setGuid(guid);
        return guid;
    }

    public ICloud createCloud(IFeed feed) {
        CloudAdapter cloud = new CloudAdapter();
        feed.setCloud(cloud);
        return cloud;
    }

    public ITextInput createTextInput(IFeed feed) {
        TextInputAdapter textInput = new TextInputAdapter();
        feed.setTextInput(textInput);
        return textInput;
    }

    public IFeed createFeed(Long id, URI link) {
        return new Feed(id, link);
    }

    public IFolder createFolder(Long id, IFolder parent, String name) {
        return this.createFolder(id, parent, name, null, null);
    }

    public IFolder createFolder(Long id, IFolder parent, String name, IFolderChild position, Boolean after) {
        Folder folder = new Folder(id, parent, name);
        if (parent != null) {
            parent.addFolder(folder, position, after);
        }
        return folder;
    }

    public ILabel createLabel(Long id, String name) {
        return new Label(id, name);
    }

    public ISearchMark createSearchMark(Long id, IFolder folder, String name) {
        return this.createSearchMark(id, folder, name, null, null);
    }

    public ISearchMark createSearchMark(Long id, IFolder folder, String name, IFolderChild position, Boolean after) {
        SearchMark searchMark = new SearchMark(id, folder, name);
        folder.addMark(searchMark, position, after);
        return searchMark;
    }

    public INewsBin createNewsBin(Long id, IFolder folder, String name) {
        return this.createNewsBin(id, folder, name, null, null);
    }

    public INewsBin createNewsBin(Long id, IFolder folder, String name, IFolderChild position, Boolean after) {
        NewsBin newsBin = new NewsBin(id, folder, name);
        folder.addMark(newsBin, position, after);
        return newsBin;
    }

    public IBookMark createBookMark(Long id, IFolder folder, FeedLinkReference feedRef, String name) {
        return this.createBookMark(id, folder, feedRef, name, null, null);
    }

    public IBookMark createBookMark(Long id, IFolder folder, FeedLinkReference feedRef, String name, IFolderChild position, Boolean after) {
        BookMark bookMark = new BookMark(id, folder, feedRef, name);
        folder.addMark(bookMark, position, after);
        return bookMark;
    }

    public ISearchCondition createSearchCondition(Long id, ISearchMark searchMark, ISearchField field, SearchSpecifier specifier, Object value) {
        SearchCondition condition = new SearchCondition(id, field, specifier, value);
        searchMark.addSearchCondition(condition);
        return condition;
    }

    public ISearchCondition createSearchCondition(ISearchField field, SearchSpecifier specifier, Object value) {
        return new SearchCondition(field, specifier, value);
    }

    public ISearchField createSearchField(int id, String entityName) {
        return new SearchField(id, entityName);
    }

    public IConditionalGet createConditionalGet(String ifModifiedSince, URI link, String ifNoneMatch) {
        return new ConditionalGet(ifModifiedSince, link, ifNoneMatch);
    }

    public IPreference createPreference(String key) {
        return new Preference(key);
    }

    public ISearch createSearch(Long id) {
        return new Search(id);
    }

    public IFilterAction createFilterAction(String actionId) {
        return new FilterAction(actionId);
    }

    public ISearchFilter createSearchFilter(Long id, ISearch search, String name) {
        return new SearchFilter(id, search, name);
    }
}

