/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.reference.FolderReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
extends AbstractEntity
implements IFolder {
    private String fName;
    private String fBlogrollLink;
    private IFolder fParent;
    private List<IFolderChild> fChildren;

    public Folder(Long id, IFolder parent, String name) {
        super(id);
        Assert.isNotNull((Object)name, (String)"The type Folder requires a Name that is not NULL");
        this.fParent = parent;
        this.fName = name;
        this.fChildren = new ArrayList<IFolderChild>(5);
    }

    protected Folder() {
    }

    @Override
    public void sort() {
        Collections.sort(this.fChildren, new Comparator<IFolderChild>(){

            @Override
            public int compare(IFolderChild child1, IFolderChild child2) {
                if (child1.getClass().equals(child2.getClass())) {
                    return child1.getName().toLowerCase().compareTo(child2.getName().toLowerCase());
                }
                if (child1 instanceof IMark) {
                    return 1;
                }
                return -1;
            }
        });
    }

    @Override
    public synchronized void addMark(IMark mark, IFolderChild position, Boolean after) {
        Assert.isNotNull((Object)mark, (String)"Exception adding NULL as Mark into Folder");
        Assert.isTrue((boolean)this.equals(mark.getParent()), (String)"The Mark has a different Folder set!");
        this.addChild(mark, position, after);
    }

    @Override
    public synchronized List<IMark> getMarks() {
        return this.extractTypes(IMark.class, this.fChildren);
    }

    @Override
    public synchronized void addFolder(IFolder folder, IFolderChild position, Boolean after) {
        Assert.isNotNull((Object)folder, (String)"Exception adding NULL as Child Folder into Parent Folder");
        Assert.isTrue((boolean)this.equals(folder.getParent()), (String)"The Folder has a different Parent Folder set!");
        this.addChild(folder, position, after);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.fChildren.isEmpty();
    }

    @Override
    public synchronized boolean containsChild(IFolderChild child) {
        return this.fChildren.contains(child);
    }

    @Override
    public synchronized List<IFolderChild> getChildren() {
        return new ArrayList<IFolderChild>(this.fChildren);
    }

    @Override
    public synchronized boolean removeChild(IFolderChild child) {
        return this.fChildren.remove(child);
    }

    private void addChild(IFolderChild child, IFolderChild position, Boolean after) {
        Boolean bl = after = after == null ? Boolean.FALSE : after;
        if (position == null) {
            this.fChildren.add(child);
        } else {
            int index = this.fChildren.indexOf(position);
            if (index < 0 || index == this.fChildren.size() && after.booleanValue()) {
                this.fChildren.add(child);
            } else if (after.booleanValue()) {
                this.fChildren.add(index + 1, child);
            } else {
                this.fChildren.add(index, child);
            }
        }
    }

    @Override
    public synchronized List<IFolder> getFolders() {
        return this.extractTypes(IFolder.class, this.fChildren);
    }

    private <T> List<T> extractTypes(Class<T> type, List<? super T> list) {
        ArrayList<T> types = new ArrayList<T>(list.size());
        for (T object : list) {
            if (!type.isInstance(object)) continue;
            types.add(type.cast(object));
        }
        return types;
    }

    @Override
    public synchronized void setBlogrollLink(URI blogrollLink) {
        this.fBlogrollLink = this.getURIText(blogrollLink);
    }

    @Override
    public synchronized String getName() {
        return this.fName;
    }

    @Override
    public synchronized void setName(String name) {
        Assert.isNotNull((Object)name, (String)"The type Folder requires a Name that is not NULL");
        this.fName = name;
    }

    @Override
    public synchronized IFolder getParent() {
        return this.fParent;
    }

    @Override
    public synchronized void setParent(IFolder newParent) {
        this.fParent = newParent;
    }

    @Override
    public synchronized URI getBlogrollLink() {
        return this.createURI(this.fBlogrollLink);
    }

    @Override
    public synchronized void reorderChildren(List<? extends IFolderChild> children, IFolderChild position, Boolean after) {
        Assert.isTrue((boolean)this.fChildren.contains(position));
        Assert.isTrue((boolean)this.fChildren.containsAll(children));
        after = after == null ? Boolean.FALSE : after;
        this.fChildren.removeAll(children);
        int index = this.fChildren.indexOf(position);
        if (index == this.fChildren.size() && after.booleanValue()) {
            this.fChildren.addAll(children);
        } else if (after.booleanValue()) {
            this.fChildren.addAll(index + 1, children);
        } else {
            this.fChildren.addAll(index, children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(IFolder folder) {
        if (this == folder) {
            return true;
        }
        if (!(folder instanceof Folder)) {
            return false;
        }
        IFolder iFolder = folder;
        synchronized (iFolder) {
            Folder f = (Folder)folder;
            return (this.getId() == null ? f.getId() == null : this.getId().equals(f.getId())) && (this.fParent == null ? f.fParent == null : this.fParent.equals(f.fParent)) && (this.fName == null ? f.fName == null : this.fName.equals(f.fName)) && (this.getBlogrollLink() == null ? f.getBlogrollLink() == null : this.getBlogrollLink().equals(f.getBlogrollLink())) && (this.fChildren == null ? f.fChildren == null : this.fChildren.equals(f.fChildren)) && (this.getProperties() == null ? f.getProperties() == null : this.getProperties().equals(f.getProperties()));
        }
    }

    @Override
    public FolderReference toReference() {
        return new FolderReference(this.getIdAsPrimitive());
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ")";
    }

    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", Blogroll Link = " + this.fBlogrollLink + ", Children = " + this.fChildren.toString() + ", Parent Folder = " + (this.fParent != null ? this.fParent.getId() : "none") + ")";
    }
}

