/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.ext.Db4oException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.rssowl.core.internal.persist.BookMark;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.BookMarkListener;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.service.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BookMarkDAOImpl
extends AbstractEntityDAO<IBookMark, BookMarkListener, BookMarkEvent>
implements IBookMarkDAO {
    public BookMarkDAOImpl() {
        super(BookMark.class, false);
    }

    @Override
    protected final BookMarkEvent createDeleteEventTemplate(IBookMark entity) {
        return this.createSaveEventTemplate(entity);
    }

    @Override
    protected final BookMarkEvent createSaveEventTemplate(IBookMark entity) {
        return new BookMarkEvent(entity, null, true);
    }

    @Override
    public final Collection<IBookMark> loadAll(FeedLinkReference feedRef) {
        try {
            Collection<IBookMark> marks = DBHelper.loadAllBookMarks(this.fDb, feedRef);
            this.activateAll(marks);
            return new ArrayList<IBookMark>(marks);
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public boolean exists(FeedLinkReference feedRef) {
        try {
            Collection<IBookMark> marks = DBHelper.loadAllBookMarks(this.fDb, feedRef);
            return !marks.isEmpty();
        }
        catch (Db4oException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void visited(IBookMark mark) {
        mark.setPopularity(mark.getPopularity() + 1);
        mark.setLastVisitDate(new Date());
        this.save(mark);
    }
}

