/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.util.ITreeNode;

public class ModelTreeNode
implements ITreeNode {
    private IFolder fFolder;
    private IMark fMark;

    public ModelTreeNode(IFolder startFolder) {
        Assert.isNotNull((Object)startFolder);
        this.fFolder = startFolder;
    }

    public ModelTreeNode(IMark startMark) {
        Assert.isNotNull((Object)startMark);
        this.fMark = startMark;
    }

    public ITreeNode getFirstChild() {
        if (this.fFolder != null) {
            List<IFolder> folders = this.fFolder.getFolders();
            if (folders.size() > 0) {
                return new ModelTreeNode(folders.get(0));
            }
            List<IMark> marks = this.fFolder.getMarks();
            if (marks.size() > 0) {
                return new ModelTreeNode(marks.get(0));
            }
        }
        return null;
    }

    public ITreeNode getLastChild() {
        if (this.fFolder != null) {
            List<IFolder> folders = this.fFolder.getFolders();
            if (folders.size() > 0) {
                return new ModelTreeNode(folders.get(folders.size() - 1));
            }
            List<IMark> marks = this.fFolder.getMarks();
            if (marks.size() > 0) {
                return new ModelTreeNode(marks.get(marks.size() - 1));
            }
        }
        return null;
    }

    public ITreeNode getNextSibling() {
        IFolder parent;
        IFolder iFolder = parent = this.fFolder != null ? this.fFolder.getParent() : this.fMark.getParent();
        if (parent != null) {
            if (this.fFolder != null) {
                List<IFolder> folders = parent.getFolders();
                int index = folders.indexOf(this.fFolder);
                if (folders.size() > index + 1) {
                    return new ModelTreeNode(folders.get(index + 1));
                }
                List<IMark> marks = parent.getMarks();
                if (!marks.isEmpty()) {
                    return new ModelTreeNode(marks.get(0));
                }
            } else if (this.fMark != null) {
                List<IMark> marks = parent.getMarks();
                int index = marks.indexOf(this.fMark);
                if (marks.size() > index + 1) {
                    return new ModelTreeNode(marks.get(index + 1));
                }
            }
        }
        return null;
    }

    public ITreeNode getParent() {
        if (this.fFolder != null && this.fFolder.getParent() != null) {
            return new ModelTreeNode(this.fFolder.getParent());
        }
        if (this.fMark != null) {
            return new ModelTreeNode(this.fMark.getParent());
        }
        return null;
    }

    public ITreeNode getPreviousSibling() {
        IFolder parent;
        IFolder iFolder = parent = this.fFolder != null ? this.fFolder.getParent() : this.fMark.getParent();
        if (parent != null) {
            if (this.fFolder != null) {
                List<IFolder> folders = parent.getFolders();
                int index = folders.indexOf(this.fFolder);
                if (index > 0) {
                    return new ModelTreeNode(folders.get(index - 1));
                }
            } else if (this.fMark != null) {
                List<IMark> marks = parent.getMarks();
                int index = marks.indexOf(this.fMark);
                if (index > 0) {
                    return new ModelTreeNode(marks.get(index - 1));
                }
                List<IFolder> folders = parent.getFolders();
                if (!folders.isEmpty()) {
                    return new ModelTreeNode(folders.get(folders.size() - 1));
                }
            }
        }
        return null;
    }

    public boolean hasChildren() {
        if (this.fFolder != null) {
            return !this.fFolder.isEmpty();
        }
        return false;
    }

    public Object getData() {
        return this.fFolder != null ? this.fFolder : this.fMark;
    }
}

