/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation.network;

import com.db4o.foundation.Closure4;
import com.db4o.foundation.Lock4;
import com.db4o.internal.Messages;
import java.io.IOException;

class ByteBuffer4 {
    private static final int DISCARD_BUFFER_SIZE = 500;
    private byte[] i_cache;
    private boolean i_closed = false;
    private int i_readOffset;
    private int i_timeout;
    private int i_writeOffset;
    private final Lock4 i_lock = new Lock4();

    public ByteBuffer4(int n) {
        this.i_timeout = n;
    }

    protected int available() {
        return this.i_writeOffset - this.i_readOffset;
    }

    private void checkDiscardCache() {
        if (this.i_readOffset == this.i_writeOffset && this.i_cache.length > 500) {
            this.i_cache = null;
            this.i_readOffset = 0;
            this.i_writeOffset = 0;
        }
    }

    void close() {
        this.i_closed = true;
    }

    protected void makefit(int n) {
        if (this.i_cache == null) {
            this.i_cache = new byte[n];
        } else if (this.i_writeOffset + n > this.i_cache.length) {
            if (this.i_writeOffset + n - this.i_readOffset <= this.i_cache.length) {
                byte[] byArray = new byte[this.i_cache.length];
                System.arraycopy(this.i_cache, this.i_readOffset, byArray, 0, this.i_cache.length - this.i_readOffset);
                this.i_cache = byArray;
                this.i_writeOffset -= this.i_readOffset;
                this.i_readOffset = 0;
            } else {
                byte[] byArray = new byte[this.i_writeOffset + n];
                System.arraycopy(this.i_cache, 0, byArray, 0, this.i_cache.length);
                this.i_cache = byArray;
            }
        }
    }

    public int read() throws IOException {
        try {
            Integer n = (Integer)this.i_lock.run(new Closure4(){

                public Object run() throws Exception {
                    ByteBuffer4.this.waitForAvailable();
                    byte by = ByteBuffer4.this.i_cache[ByteBuffer4.this.i_readOffset++];
                    ByteBuffer4.this.checkDiscardCache();
                    return new Integer(by);
                }
            });
            return n;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int read(final byte[] byArray, final int n, final int n2) throws IOException {
        try {
            Integer n3 = (Integer)this.i_lock.run(new Closure4(){

                public Object run() throws Exception {
                    ByteBuffer4.this.waitForAvailable();
                    int n3 = ByteBuffer4.this.available();
                    int n22 = n2;
                    if (n3 < n2) {
                        n22 = n3;
                    }
                    System.arraycopy(ByteBuffer4.this.i_cache, ByteBuffer4.this.i_readOffset, byArray, n, n22);
                    ByteBuffer4.this.i_readOffset += n22;
                    ByteBuffer4.this.checkDiscardCache();
                    return new Integer(n3);
                }
            });
            return n3;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void setTimeout(int n) {
        this.i_timeout = n;
    }

    protected void waitForAvailable() throws IOException {
        while (this.available() == 0) {
            if (this.i_closed) {
                throw new IOException(Messages.get(35));
            }
            try {
                this.i_lock.snooze(this.i_timeout);
            }
            catch (Exception exception) {
                throw new IOException(Messages.get(55));
            }
        }
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(final byte[] byArray, final int n, final int n2) {
        try {
            this.i_lock.run(new Closure4(){

                public Object run() throws Exception {
                    ByteBuffer4.this.makefit(n2);
                    System.arraycopy(byArray, n, ByteBuffer4.this.i_cache, ByteBuffer4.this.i_writeOffset, n2);
                    ByteBuffer4.this.i_writeOffset += n2;
                    ByteBuffer4.this.i_lock.awake();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(final int n) {
        try {
            this.i_lock.run(new Closure4(){

                public Object run() throws Exception {
                    ByteBuffer4.this.makefit(1);
                    ((ByteBuffer4)ByteBuffer4.this).i_cache[((ByteBuffer4)ByteBuffer4.this).i_writeOffset++] = (byte)n;
                    ByteBuffer4.this.i_lock.awake();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

