/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.OldFormatException;
import com.db4o.foundation.Cool;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;
import com.db4o.internal.fileheader.TimerFileLock;
import com.db4o.internal.handlers.IntHandler;
import java.io.IOException;

public final class ConfigBlock {
    private final LocalObjectContainer _container;
    private final TimerFileLock _timerFileLock;
    private int _address;
    private Transaction _transactionToCommit;
    public int _bootRecordID;
    private static final int MINIMUM_LENGTH = 21;
    static final int OPEN_TIME_OFFSET = 4;
    public static final int ACCESS_TIME_OFFSET = 12;
    public static final int TRANSACTION_OFFSET = 21;
    private static final int BOOTRECORD_OFFSET = 29;
    private static final int INT_FORMERLY_KNOWN_AS_BLOCK_OFFSET = 33;
    private static final int ENCRYPTION_PASSWORD_LENGTH = 5;
    private static final int PASSWORD_OFFSET = 38;
    private static final int FREESPACE_SYSTEM_OFFSET = 39;
    private static final int FREESPACE_ADDRESS_OFFSET = 43;
    private static final int CONVERTER_VERSION_OFFSET = 47;
    private static final int UUID_INDEX_ID_OFFSET = 51;
    private static final int LENGTH = 55;

    public static ConfigBlock forNewFile(LocalObjectContainer localObjectContainer) throws IOException {
        return new ConfigBlock(localObjectContainer, true, 0);
    }

    public static ConfigBlock forExistingFile(LocalObjectContainer localObjectContainer, int n) throws IOException {
        return new ConfigBlock(localObjectContainer, false, n);
    }

    private ConfigBlock(LocalObjectContainer localObjectContainer, boolean bl, int n) throws IOException {
        this._container = localObjectContainer;
        this._timerFileLock = TimerFileLock.forFile(localObjectContainer);
        this.timerFileLock().writeHeaderLock();
        if (!bl) {
            this.read(n);
        }
        this.timerFileLock().start();
    }

    private TimerFileLock timerFileLock() {
        return this._timerFileLock;
    }

    public long openTime() {
        return this.timerFileLock().openTime();
    }

    public Transaction getTransactionToCommit() {
        return this._transactionToCommit;
    }

    private byte[] passwordToken() {
        byte[] byArray = new byte[5];
        String string = this._container.configImpl().password();
        if (this._container.configImpl().encrypt() && string != null) {
            try {
                byte[] byArray2 = new LatinStringIO().write(string);
                StatefulBuffer statefulBuffer = new StatefulBuffer(this._container.getTransaction(), byArray2.length + 5);
                statefulBuffer.append(byArray2);
                statefulBuffer.append(new byte[5]);
                this._container.i_handlers.decrypt(statefulBuffer);
                System.arraycopy(statefulBuffer._buffer, 0, byArray, 0, 5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    private SystemData systemData() {
        return this._container.systemData();
    }

    private void read(int n) {
        int n2;
        this.addressChanged(n);
        this.timerFileLock().writeOpenTime();
        StatefulBuffer statefulBuffer = this._container.getWriter(this._container.getSystemTransaction(), this._address, 55);
        try {
            this._container.readBytes(statefulBuffer._buffer, this._address, 55);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = statefulBuffer.readInt();
        if (n3 > 55 || n3 < 21) {
            Exceptions4.throwRuntimeException(17);
        }
        if (n3 != 55 && !this._container.configImpl().isReadOnly() && !this._container.configImpl().allowVersionUpdates()) {
            if (this._container.configImpl().automaticShutDown()) {
                Platform4.removeShutDownHook(this._container, this._container.i_lock);
            }
            throw new OldFormatException();
        }
        statefulBuffer.readLong();
        long l = statefulBuffer.readLong();
        this.systemData().stringEncoding(statefulBuffer.readByte());
        if (n3 > 21) {
            this._transactionToCommit = Transaction.readInterruptedTransaction(this._container, statefulBuffer);
        }
        if (n3 > 29) {
            this._bootRecordID = statefulBuffer.readInt();
        }
        if (n3 > 33) {
            statefulBuffer.readInt();
        }
        if (n3 > 38) {
            byte[] byArray = statefulBuffer.readBytes(5);
            boolean bl = false;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this._container.i_handlers.oldEncryptionOff();
            } else {
                byte[] byArray2 = this.passwordToken();
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray2[i] == byArray[i]) continue;
                    this._container.fatalException(54);
                }
            }
        }
        if (n3 > 39) {
            this.systemData().freespaceSystem(statefulBuffer.readByte());
        }
        if (n3 > 43) {
            this.systemData().freespaceAddress(statefulBuffer.readInt());
        }
        if (n3 > 47) {
            this.systemData().converterVersion(statefulBuffer.readInt());
        }
        if (n3 > 51 && 0 != (n2 = statefulBuffer.readInt())) {
            this.systemData().uuidIndexId(n2);
        }
        this._container.ensureFreespaceSlot();
        if (FileHeader.lockedByOtherSession(this._container, l)) {
            this._timerFileLock.checkIfOtherSessionAlive(this._container, this._address, 12, l);
        }
        if (this._container.needsLockFileThread()) {
            Cool.sleepIgnoringInterruption(100L);
            this._container.syncFiles();
            this.timerFileLock().checkOpenTime();
        }
        if (n3 < 55) {
            this.write();
        }
    }

    public void write() {
        this.timerFileLock().checkHeaderLock();
        this.addressChanged(this._container.getSlot(55));
        StatefulBuffer statefulBuffer = this._container.getWriter(this._container.getTransaction(), this._address, 55);
        IntHandler.writeInt(55, statefulBuffer);
        for (int i = 0; i < 2; ++i) {
            statefulBuffer.writeLong(this.timerFileLock().openTime());
        }
        statefulBuffer.append(this.systemData().stringEncoding());
        IntHandler.writeInt(0, statefulBuffer);
        IntHandler.writeInt(0, statefulBuffer);
        IntHandler.writeInt(this._bootRecordID, statefulBuffer);
        IntHandler.writeInt(0, statefulBuffer);
        statefulBuffer.append(this.passwordToken());
        statefulBuffer.append(this.systemData().freespaceSystem());
        this._container.ensureFreespaceSlot();
        IntHandler.writeInt(this.systemData().freespaceAddress(), statefulBuffer);
        IntHandler.writeInt(this.systemData().converterVersion(), statefulBuffer);
        IntHandler.writeInt(this.systemData().uuidIndexId(), statefulBuffer);
        statefulBuffer.write();
        this.writePointer();
        this._container.syncFiles();
    }

    private void addressChanged(int n) {
        this._address = n;
        this.timerFileLock().setAddresses(this._address, 4, 12);
    }

    private void writePointer() {
        this.timerFileLock().checkHeaderLock();
        StatefulBuffer statefulBuffer = this._container.getWriter(this._container.getTransaction(), 0, 4);
        statefulBuffer.moveForward(2);
        IntHandler.writeInt(this._address, statefulBuffer);
        statefulBuffer.noXByteCheck();
        statefulBuffer.write();
        this.timerFileLock().writeHeaderLock();
    }

    public int address() {
        return this._address;
    }

    public void close() throws IOException {
        this.timerFileLock().close();
    }
}

