/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.Buffer;
import com.db4o.internal.UnicodeStringIO;

public class LatinStringIO {
    protected char[] chars = new char[0];

    public int bytesPerChar() {
        return 1;
    }

    public byte encodingByte() {
        return 1;
    }

    static LatinStringIO forEncoding(byte by) {
        switch (by) {
            case 1: {
                return new LatinStringIO();
            }
        }
        return new UnicodeStringIO();
    }

    public int length(String string) {
        return string.length() + 0 + 4;
    }

    protected void checkBufferLength(int n) {
        if (n > this.chars.length) {
            this.chars = new char[n];
        }
    }

    public String read(Buffer buffer, int n) {
        this.checkBufferLength(n);
        for (int i = 0; i < n; ++i) {
            this.chars[i] = (char)(buffer._buffer[buffer._offset++] & 0xFF);
        }
        return new String(this.chars, 0, n);
    }

    public String read(byte[] byArray) {
        this.checkBufferLength(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            this.chars[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(this.chars, 0, byArray.length);
    }

    public int shortLength(String string) {
        return string.length() + 4;
    }

    protected int writetoBuffer(String string) {
        int n = string.length();
        this.checkBufferLength(n);
        string.getChars(0, n, this.chars, 0);
        return n;
    }

    public void write(Buffer buffer, String string) {
        int n = this.writetoBuffer(string);
        for (int i = 0; i < n; ++i) {
            buffer._buffer[buffer._offset++] = (byte)(this.chars[i] & 0xFF);
        }
    }

    byte[] write(String string) {
        int n = this.writetoBuffer(string);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(this.chars[i] & 0xFF);
        }
        return byArray;
    }
}

