/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PrimitiveCodec;
import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.reflect.ReflectClass;

public class LongHandler
extends PrimitiveHandler {
    private static final Long i_primitive = new Long(0L);
    private long i_compareTo;

    public LongHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toLong(object);
    }

    public Object defaultValue() {
        return i_primitive;
    }

    public int getID() {
        return 2;
    }

    protected Class primitiveJavaClass() {
        return Long.TYPE;
    }

    public int linkLength() {
        return 8;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    public Object read(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) throws CorruptionException {
        return marshallerFamily._primitive.readLong(statefulBuffer);
    }

    Object read1(Buffer buffer) {
        return new Long(buffer.readLong());
    }

    public void write(Object object, Buffer buffer) {
        LongHandler.writeLong((Long)object, buffer);
    }

    public static final void writeLong(long l, Buffer buffer) {
        PrimitiveCodec.writeLong(buffer._buffer, buffer._offset, l);
        LongHandler.incrementOffset(buffer);
    }

    private static final void incrementOffset(Buffer buffer) {
        buffer.incrementOffset(8);
    }

    protected final long currentLong() {
        return this.i_compareTo;
    }

    long val(Object object) {
        return (Long)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    public Object current1() {
        return new Long(this.i_compareTo);
    }

    boolean isEqual1(Object object) {
        return object instanceof Long && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        return object instanceof Long && this.val(object) > this.i_compareTo;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Long && this.val(object) < this.i_compareTo;
    }
}

