/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.LocalStringManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.ParamDefaultCalculator;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;

public class GenericCommandModel
extends CommandModel {
    final HashMap<String, CommandModel.ParamModel> params = new HashMap();
    final String commandName;
    final Class<?> commandClass;
    final ExecuteOn cluster;
    final I18n i18n;
    final LocalStringManager localStrings;
    final boolean managedJob;

    public GenericCommandModel(Class<?> targetType, boolean useAnnotations, ExecuteOn cluster, I18n i18n, LocalStringManager localStrings, DomDocument document, String commandName, boolean managedJob, Class<?> ... extraTypes) {
        this.commandName = commandName;
        this.commandClass = targetType;
        this.cluster = cluster;
        this.i18n = i18n;
        this.localStrings = localStrings;
        this.managedJob = managedJob;
        if (useAnnotations && targetType != null && ConfigBeanProxy.class.isAssignableFrom(targetType)) {
            ConfigModel cm = document.buildModel(targetType);
            for (Method m : targetType.getMethods()) {
                String name;
                ConfigModel.Property prop = cm.toProperty(m);
                if (prop == null) continue;
                String attributeName = prop.xmlName;
                I18n paramI18n = m.getAnnotation(I18n.class);
                if (!m.isAnnotationPresent(Param.class)) continue;
                Param p = m.getAnnotation(Param.class);
                if (p.name() != null && !p.name().isEmpty()) {
                    name = CommandModel.getParamName((Param)p, (AnnotatedElement)m);
                    this.params.put(name, new ParamBasedModel(name, p, paramI18n));
                    continue;
                }
                if (m.isAnnotationPresent(Attribute.class)) {
                    Attribute attr = m.getAnnotation(Attribute.class);
                    if (attr.value() != null && !attr.value().isEmpty()) {
                        this.params.put(attr.value(), new AttributeBasedModel(attr.value(), attr, paramI18n));
                        continue;
                    }
                    this.params.put(attributeName, new AttributeBasedModel(attributeName, attr, paramI18n));
                    continue;
                }
                name = CommandModel.getParamName((Param)p, (AnnotatedElement)m);
                this.params.put(name, new ParamBasedModel(name, p, paramI18n));
            }
        }
        if (extraTypes != null) {
            for (Class<?> extraType : extraTypes) {
                for (Map.Entry<String, CommandModel.ParamModel> e : CommandModelImpl.init(extraType, i18n, localStrings).entrySet()) {
                    if (this.params.containsKey(e.getKey())) continue;
                    this.params.put(e.getKey(), e.getValue());
                }
            }
        }
    }

    public String getLocalizedDescription() {
        return this.localStrings.getLocalString(this.i18n.value(), "");
    }

    public String getUsageText() {
        return this.localStrings.getLocalString(this.i18n.value() + ".usagetext", null);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandModel.ParamModel getModelFor(String paramName) {
        return this.params.get(paramName);
    }

    public Collection<String> getParametersNames() {
        return this.params.keySet();
    }

    public Class<?> getCommandClass() {
        return this.commandClass;
    }

    public ExecuteOn getClusteringAttributes() {
        return this.cluster;
    }

    public void add(CommandModel.ParamModel model) {
        if (!this.params.containsKey(model.getName())) {
            this.params.put(model.getName(), model);
        }
    }

    public boolean isManagedJob() {
        return this.managedJob;
    }

    private final class AttributeBasedModel
    extends CommandModel.ParamModel {
        final String name;
        final Attribute attr;
        final I18n i18n;

        private AttributeBasedModel(String name, Attribute attr, I18n i18n) {
            this.name = name;
            this.attr = attr;
            this.i18n = i18n;
        }

        public String getName() {
            return this.name;
        }

        private String getLocalizedString(String type) {
            if (this.i18n != null) {
                return GenericCommandModel.this.localStrings.getLocalString(this.i18n.value() + type, "");
            }
            return GenericCommandModel.this.localStrings.getLocalString(GenericCommandModel.this.i18n.value() + "." + this.name + type, "");
        }

        public String getLocalizedDescription() {
            return this.getLocalizedString("");
        }

        public String getLocalizedPrompt() {
            return this.getLocalizedString(".prompt");
        }

        public String getLocalizedPromptAgain() {
            return this.getLocalizedString(".promptAgain");
        }

        public Class getType() {
            return String.class;
        }

        public Param getParam() {
            return new Param(){

                public Class<? extends Annotation> annotationType() {
                    return Param.class;
                }

                public String name() {
                    return AttributeBasedModel.this.name;
                }

                public String acceptableValues() {
                    return null;
                }

                public boolean optional() {
                    return !AttributeBasedModel.this.attr.key();
                }

                public String shortName() {
                    return null;
                }

                public boolean primary() {
                    return AttributeBasedModel.this.attr.key();
                }

                public String defaultValue() {
                    return AttributeBasedModel.this.attr.defaultValue();
                }

                public Class<ParamDefaultCalculator> defaultCalculator() {
                    return ParamDefaultCalculator.class;
                }

                public boolean password() {
                    return false;
                }

                public char separator() {
                    return ',';
                }

                public boolean multiple() {
                    return false;
                }

                public boolean obsolete() {
                    return false;
                }

                public String alias() {
                    return "";
                }
            };
        }
    }

    private final class ParamBasedModel
    extends CommandModel.ParamModel {
        final String name;
        final Param param;
        final I18n i18n;

        private ParamBasedModel(String name, Param param, I18n i18n) {
            this.name = name;
            this.param = param;
            this.i18n = i18n;
        }

        private String getLocalizedString(String type) {
            if (this.i18n != null) {
                return GenericCommandModel.this.localStrings.getLocalString(this.i18n.value() + type, "");
            }
            return GenericCommandModel.this.localStrings.getLocalString(GenericCommandModel.this.i18n.value() + "." + this.name + type, "");
        }

        public String getLocalizedDescription() {
            return this.getLocalizedString("");
        }

        public String getLocalizedPrompt() {
            return this.getLocalizedString(".prompt");
        }

        public String getLocalizedPromptAgain() {
            return this.getLocalizedString(".promptAgain");
        }

        public String getName() {
            return this.name;
        }

        public Param getParam() {
            return this.param;
        }

        public I18n getI18n() {
            return this.i18n;
        }

        public Class getType() {
            return String.class;
        }
    }
}

