/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.URLClassPath;

public class ClassLoaderUtil {
    private static boolean isInitialized = false;
    private static final String URLCLASSLOADER_UCP_FIELD_NAME = "ucp";
    private static final String URLCLASSPATH_LOADERS_FIELD_NAME = "loaders";
    private static final String URLCLASSPATH_URLS_FIELD_NAME = "urls";
    private static final String URLCLASSPATH_LMAP_FIELD_NAME = "lmap";
    private static final String URLCLASSPATH_JARLOADER_INNER_CLASS_NAME = "sun.misc.URLClassPath$JarLoader";
    private static final String URLCLASSPATH_JARLOADER_JARFILE_FIELD_NAME = "jar";
    private static Field jcpField;
    private static Field loadersField;
    private static Field urlsField;
    private static Field lmapField;
    private static Class jarLoaderInnerClass;
    private static Field jarFileField;
    private static boolean initDone;

    private static void init() throws Throwable {
        if (!initDone) {
            ClassLoaderUtil.initForClosingJars();
            initDone = true;
        }
    }

    private static void initForClosingJars() throws NoSuchFieldException {
        jcpField = ClassLoaderUtil.getField(URLClassLoader.class, URLCLASSLOADER_UCP_FIELD_NAME);
        loadersField = ClassLoaderUtil.getField(URLClassPath.class, URLCLASSPATH_LOADERS_FIELD_NAME);
        urlsField = ClassLoaderUtil.getField(URLClassPath.class, URLCLASSPATH_URLS_FIELD_NAME);
        lmapField = ClassLoaderUtil.getField(URLClassPath.class, URLCLASSPATH_LMAP_FIELD_NAME);
        jarLoaderInnerClass = ClassLoaderUtil.getInnerClass(URLClassPath.class, URLCLASSPATH_JARLOADER_INNER_CLASS_NAME);
        jarFileField = ClassLoaderUtil.getField(jarLoaderInnerClass, URLCLASSPATH_JARLOADER_JARFILE_FIELD_NAME);
    }

    private static Field getField(Class cls, String fieldName) throws NoSuchFieldException {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException nsfe) {
            NoSuchFieldException e = new NoSuchFieldException(ClassLoaderUtil.getMessage("classloaderutil.errorGettingField", fieldName));
            e.initCause(nsfe);
            throw e;
        }
    }

    private static Class getInnerClass(Class cls, String innerClassName) {
        Class<?>[] innerClasses;
        Class<?> result = null;
        for (Class<?> c : innerClasses = cls.getDeclaredClasses()) {
            if (!c.getName().equals(innerClassName)) continue;
            result = c;
            break;
        }
        return result;
    }

    public static void releaseLoader(URLClassLoader classLoader) {
        ClassLoaderUtil.releaseLoader(classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOException[] releaseLoader(URLClassLoader classLoader, Vector<String> jarsClosed) {
        IOException[] result = null;
        try {
            ClassLoaderUtil.init();
            Vector<IOException> ioExceptions = new Vector<IOException>();
            if (jarsClosed != null) {
                jarsClosed.clear();
            }
            URLClassPath ucp = (URLClassPath)jcpField.get(classLoader);
            ArrayList loaders = (ArrayList)loadersField.get(ucp);
            Stack urls = (Stack)urlsField.get(ucp);
            HashMap lmap = (HashMap)lmapField.get(ucp);
            Cloneable cloneable = urls;
            synchronized (cloneable) {
                urls.clear();
            }
            cloneable = lmap;
            synchronized (cloneable) {
                lmap.clear();
            }
            cloneable = ucp;
            synchronized (cloneable) {
                for (Object o : loaders) {
                    if (o == null || !jarLoaderInnerClass.isInstance(o)) continue;
                    try {
                        JarFile jarFile = (JarFile)jarFileField.get(o);
                        try {
                            if (jarFile == null) continue;
                            jarFile.close();
                            if (jarsClosed == null) continue;
                            jarsClosed.add(jarFile.getName());
                        }
                        catch (IOException ioe) {
                            String msg = ClassLoaderUtil.getMessage("classloaderutil.errorClosingJar", jarFile.getName());
                            IOException newIOE = new IOException(msg);
                            newIOE.initCause(ioe);
                            ioExceptions.add(newIOE);
                            ClassLoaderUtil.getLogger().log(Level.WARNING, msg, ioe);
                        }
                    }
                    catch (Throwable thr) {
                        ClassLoaderUtil.getLogger().log(Level.WARNING, "classloaderutil.errorReleasingJarNoName", thr);
                    }
                }
                loaders.clear();
            }
            result = ioExceptions.toArray(new IOException[ioExceptions.size()]);
        }
        catch (Throwable thr) {
            ClassLoaderUtil.getLogger().log(Level.WARNING, "classloaderutil.errorReleasingLoader", thr);
            result = null;
        }
        return result;
    }

    private static Logger getLogger() {
        return LogDomains.getLogger(ClassLoaderUtil.class, (String)"javax.enterprise.system.util");
    }

    private static String getMessage(String key, Object ... o) {
        String msg = ClassLoaderUtil.getLogger().getResourceBundle().getString(key);
        return MessageFormat.format(msg, o);
    }

    static {
        initDone = false;
    }
}

