/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.HttpRedirect;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-redirect")
@PerLookup
@I18n(value="create.http.redirect")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="create-http-redirect", description="create-http-redirect"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="create-http-redirect", description="create-http-redirect")})
public class CreateHttpRedirect
implements AdminCommand {
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="redirect-port", optional=true)
    String port;
    @Param(name="secure-redirect", optional=true)
    String secure;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="An http-redirect element for {0} already exists. Cannot add duplicate http-redirect.", level="INFO")
    private static final String CREATE_HTTP_REDIRECT_FAIL_DUPLICATE = "AS-WEB-ADMIN-00016";

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (!this.protocolName.equals(p.getName())) continue;
            protocol = p;
        }
        if (protocol == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00013"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (protocol.getHttpRedirect() != null) {
            report.setMessage(MessageFormat.format(rb.getString(CREATE_HTTP_REDIRECT_FAIL_DUPLICATE), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    HttpRedirect httpRedirect = (HttpRedirect)param.createChild(HttpRedirect.class);
                    httpRedirect.setPort(CreateHttpRedirect.this.port);
                    httpRedirect.setSecure(CreateHttpRedirect.this.secure);
                    param.setHttpRedirect(httpRedirect);
                    return httpRedirect;
                }
            }, (ConfigBeanProxy)protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00014"), this.protocolName) + (e.getMessage() == null ? "No reason given." : e.getMessage()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

