/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-network-listener")
@PerLookup
@I18n(value="delete.network.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteNetworkListener
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="{0} Network Listener doesn't exist.", level="INFO")
    protected static final String DELETE_NETWORK_LISTENER_NOT_EXISTS = "AS-WEB-ADMIN-00030";
    @LogMessageInfo(message="Deletion of NetworkListener {0} failed.", level="INFO")
    protected static final String DELETE_NETWORK_LISTENER_FAIL = "AS-WEB-ADMIN-00031";
    @Param(name="networkListenerName", primary=true)
    String networkListenerName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    NetworkListener listenerToBeRemoved = null;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkListeners networkListeners = this.config.getNetworkConfig().getNetworkListeners();
        try {
            if (this.findListener(networkListeners, report)) {
                Protocol httpProtocol = this.listenerToBeRemoved.findHttpProtocol();
                VirtualServer virtualServer = this.config.getHttpService().getVirtualServerByName(httpProtocol.getHttp().getDefaultVirtualServer());
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... params) throws PropertyVetoException {
                        NetworkListeners listeners = (NetworkListeners)params[0];
                        VirtualServer server = (VirtualServer)params[1];
                        listeners.getNetworkListener().remove(DeleteNetworkListener.this.listenerToBeRemoved);
                        server.removeNetworkListener(DeleteNetworkListener.this.listenerToBeRemoved.getName());
                        return DeleteNetworkListener.this.listenerToBeRemoved;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{networkListeners, virtualServer});
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_NETWORK_LISTENER_FAIL), this.networkListenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean findListener(NetworkListeners networkListeners, ActionReport report) {
        for (NetworkListener listener : networkListeners.getNetworkListener()) {
            if (!listener.getName().equals(this.networkListenerName)) continue;
            this.listenerToBeRemoved = listener;
        }
        if (this.listenerToBeRemoved == null) {
            report.setMessage(MessageFormat.format(rb.getString(DELETE_NETWORK_LISTENER_NOT_EXISTS), this.networkListenerName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

