/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.test;

import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class TokenReplacementTester {
    private final LineTokenReplacer replacer;

    public TokenReplacementTester(String tokensFileName, String fromFile, String toFile) {
        TokenValueSet tokens = this.getTokensFromFile(tokensFileName);
        this.replacer = new LineTokenReplacer(tokens);
        this.replacer.replace(fromFile, toFile);
    }

    private TokenValueSet getTokensFromFile(String fileName) {
        TokenValueSet tokens;
        block5: {
            tokens = new TokenValueSet();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(fileName));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    TokenValue tv = this.getTokenValue(line);
                    tokens.add(tv);
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (reader == null) break block5;
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return tokens;
    }

    private TokenValue getTokenValue(String line) {
        String delim = "=";
        StringTokenizer parser = new StringTokenizer(line, "=");
        String[] output = new String[2];
        int i = 0;
        while (parser.hasMoreTokens()) {
            output[i++] = parser.nextToken();
        }
        String DELIM = "%%%";
        TokenValue tv = new TokenValue(output[0], output[1], "%%%");
        return tv;
    }

    public static void main(String[] args) {
        int length = args.length;
        if (length < 2) {
            TokenReplacementTester.usage();
            System.exit(1);
        }
        String tokensFile = args[0];
        String fromFile = args[1];
        String toFile = fromFile + ".out";
        new TokenReplacementTester(tokensFile, fromFile, toFile);
    }

    private static void usage() {
        System.out.println("java TokenReplacementTester <tokens-file> <template-file>");
    }
}

