/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.adapter.LocatorBridge;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ProxyImpl;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;

@Path(value="/")
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class MonitoringResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected LocatorBridge habitat;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="domain{path:.*}")
    @Produces(value={"application/json", "application/xml", "text/html;qs=2"})
    public Response getChildNodes(@PathParam(value="path") List<PathSegment> pathSegments) {
        PathSegment lastSegment;
        Response.ResponseBuilder responseBuilder = Response.status(Response.Status.OK);
        RestActionReporter ar = new RestActionReporter();
        ar.setActionDescription("Monitoring Data");
        ar.setMessage("");
        ar.setSuccess();
        String currentInstanceName = System.getProperty("com.sun.aas.instanceName");
        boolean isRunningOnDAS = "server".equals(currentInstanceName);
        MonitoringRuntimeDataRegistry monitoringRegistry = (MonitoringRuntimeDataRegistry)this.habitat.getRemoteLocator().getService(MonitoringRuntimeDataRegistry.class, new Annotation[0]);
        TreeNode rootNode = monitoringRegistry.get(currentInstanceName);
        pathSegments = pathSegments.subList(1, pathSegments.size());
        if (!pathSegments.isEmpty() && (lastSegment = pathSegments.get(pathSegments.size() - 1)).getPath().isEmpty()) {
            pathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        }
        if (!pathSegments.isEmpty()) {
            String firstPathElement = pathSegments.get(0).getPath();
            if (firstPathElement.equals(currentInstanceName)) {
                TreeNode resultNode;
                StringBuilder pathInMonitoringRegistry = new StringBuilder();
                for (PathSegment pathSegment : pathSegments.subList(1, pathSegments.size())) {
                    if (pathInMonitoringRegistry.length() > 0) {
                        pathInMonitoringRegistry.append('.');
                    }
                    pathInMonitoringRegistry.append(pathSegment.getPath().replaceAll("\\.", "\\\\."));
                }
                TreeNode treeNode = resultNode = pathInMonitoringRegistry.length() > 0 && rootNode != null ? rootNode.getNode(pathInMonitoringRegistry.toString()) : rootNode;
                if (resultNode != null) {
                    ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                    if (resultNode.hasChildNodes()) {
                        list.addAll(resultNode.getEnabledChildNodes());
                    } else {
                        list.add(resultNode);
                    }
                    this.constructEntity(list, ar);
                    responseBuilder.entity(new ActionReportResult(ar));
                    return responseBuilder.build();
                } else {
                    responseBuilder.status(Response.Status.NOT_FOUND);
                    ar.setFailure();
                    responseBuilder.entity(new ActionReportResult(ar));
                }
                return responseBuilder.build();
            } else {
                if (!isRunningOnDAS) return Response.status(Response.Status.FORBIDDEN).build();
                Properties proxiedResponse = new MonitoringProxyImpl().proxyRequest(this.uriInfo, Util.getJerseyClient(), this.habitat.getRemoteLocator());
                ar.setExtraProperties(proxiedResponse);
                responseBuilder.entity(new ActionReportResult(ar));
            }
            return responseBuilder.build();
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            if (rootNode != null) {
                list.add(rootNode);
            }
            this.constructEntity(list, ar);
            if (isRunningOnDAS) {
                Domain domain = (Domain)this.habitat.getRemoteLocator().getService(Domain.class, new Annotation[0]);
                Map links = (Map)ar.getExtraProperties().get("childResources");
                for (Server s : domain.getServers().getServer()) {
                    if (s.getName().equals("server")) continue;
                    links.put(s.getName(), ProviderUtil.getElementLink(this.uriInfo, s.getName()));
                }
            }
            responseBuilder.entity(new ActionReportResult(ar));
        }
        return responseBuilder.build();
    }

    private void constructEntity(List<TreeNode> nodeList, RestActionReporter ar) {
        TreeMap<String, Object> entity = new TreeMap<String, Object>();
        TreeMap<String, String> links = new TreeMap<String, String>();
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) {
                Object value = node.getValue();
                if (value == null) continue;
                try {
                    if (value instanceof Statistic) {
                        Statistic statisticObject = (Statistic)value;
                        entity.put(node.getName(), ProviderUtil.getStatistic(statisticObject));
                        continue;
                    }
                    if (value instanceof Stats) {
                        TreeMap<String, Map<String, Object>> subMap = new TreeMap<String, Map<String, Object>>();
                        for (Statistic statistic : ((Stats)value).getStatistics()) {
                            subMap.put(statistic.getName(), ProviderUtil.getStatistic(statistic));
                        }
                        entity.put(node.getName(), subMap);
                        continue;
                    }
                    entity.put(node.getName(), ProviderUtil.jsonValue(value));
                }
                catch (Exception exception) {}
                continue;
            }
            String name = node.getName();
            name = name.replace("\\.", ".");
            links.put(name, ProviderUtil.getElementLink(this.uriInfo, name));
        }
        ar.getExtraProperties().put("entity", entity);
        ar.getExtraProperties().put("childResources", links);
    }

    private static class MonitoringProxyImpl
    extends ProxyImpl {
        private MonitoringProxyImpl() {
        }

        @Override
        public UriBuilder constructTargetURLPath(UriInfo sourceUriInfo, URL responseURLReceivedFromTarget) {
            return sourceUriInfo.getBaseUriBuilder().replacePath(responseURLReceivedFromTarget.getFile());
        }

        @Override
        public UriBuilder constructForwardURLPath(UriInfo sourceUriInfo) {
            return sourceUriInfo.getAbsolutePathBuilder();
        }

        @Override
        public String extractTargetInstanceName(UriInfo uriInfo) {
            return uriInfo.getPathSegments().get(1).getPath();
        }
    }
}

