/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSConfigurationException;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;

public class PersistenceFactoryBase
implements PersistenceContextFactory {
    protected Map<String, PersistenceContext> dynamicPersistenceContexts = new HashMap<String, PersistenceContext>();

    public PersistenceContext bootstrapPersistenceContext(String name, EntityManagerFactory emf, URI baseURI, String version, boolean replace) {
        PersistenceContext persistenceContext = new PersistenceContext(name, (EntityManagerFactoryImpl)emf, baseURI);
        persistenceContext.setBaseURI(baseURI);
        persistenceContext.setVersion(version);
        return persistenceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (String key : this.dynamicPersistenceContexts.keySet()) {
            this.dynamicPersistenceContexts.get(key).stop();
        }
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            this.dynamicPersistenceContexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePersistenceContext(String name) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            PersistenceContext context = this.dynamicPersistenceContexts.get(name);
            if (context != null) {
                context.stop();
                this.dynamicPersistenceContexts.remove(name);
            }
        }
    }

    protected static Map<String, Object> createProperties(DynamicClassLoader dcl, Map<String, ?> originalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", dcl);
        properties.put("eclipselink.weaving", "static");
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            if (!entry.getKey().startsWith("javax") && !entry.getKey().startsWith("eclipselink.log") && !entry.getKey().startsWith("eclipselink.target-server")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceContext get(String persistenceUnit, URI defaultURI, String version, Map<String, Object> initializationProperties) {
        PersistenceContext app;
        block10: {
            app = this.getDynamicPersistenceContext(persistenceUnit);
            if (app == null) {
                try {
                    EntityManagerFactoryImpl factory;
                    ClassLoader sessionLoader;
                    DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("eclipselink.classloader", dcl);
                    if (initializationProperties != null) {
                        properties.putAll(initializationProperties);
                    }
                    if (!DynamicClassLoader.class.isAssignableFrom((sessionLoader = (factory = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)persistenceUnit, properties)).getServerSession().getLoader()).getClass())) {
                        properties = new HashMap();
                        dcl = new DynamicClassLoader(sessionLoader);
                        properties.put("eclipselink.classloader", dcl);
                        if (initializationProperties != null) {
                            properties.putAll(initializationProperties);
                        }
                        factory.refreshMetadata(properties);
                    }
                    if (factory == null || (app = this.bootstrapPersistenceContext(persistenceUnit, (EntityManagerFactory)factory, defaultURI, version, true)) == null) break block10;
                    PersistenceFactoryBase persistenceFactoryBase = this;
                    synchronized (persistenceFactoryBase) {
                        this.dynamicPersistenceContexts.put(persistenceUnit, app);
                    }
                }
                catch (Exception e) {
                    JPARSLogger.exception("exception_creating_persistence_context", new Object[]{persistenceUnit, e.toString()}, e);
                }
            }
        }
        if (app != null && !app.isWeavingEnabled()) {
            throw new JPARSConfigurationException(LoggingLocalization.buildMessage("weaving_required_for_relationships", new Object[]{persistenceUnit}));
        }
        return app;
    }

    @Override
    public Set<String> getPersistenceContextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        try {
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            for (Archive archive : archives) {
                List infos = PersistenceUnitProcessor.processPersistenceArchive((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo info : infos) {
                    if (info.getPersistenceUnitName().equals("jpa-rs") || EntityManagerSetupImpl.mustBeCompositeMember((PersistenceUnitInfo)info)) continue;
                    contextNames.add(info.getPersistenceUnitName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        contextNames.addAll(this.dynamicPersistenceContexts.keySet());
        return contextNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext getDynamicPersistenceContext(String name) {
        PersistenceFactoryBase persistenceFactoryBase = this;
        synchronized (persistenceFactoryBase) {
            return this.dynamicPersistenceContexts.get(name);
        }
    }
}

