/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class CharsetMapper
implements Cloneable {
    public static final String DEFAULT_RESOURCE = "/org/apache/catalina/util/CharsetMapperDefault.properties";
    protected Properties map = new Properties();

    public CharsetMapper() {
        this(DEFAULT_RESOURCE);
    }

    public CharsetMapper(String name) {
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream(name);
            this.map.load(stream);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t.toString());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t2) {}
            }
        }
    }

    public String getCharset(Locale locale) {
        String charset = null;
        charset = this.map.getProperty(locale.toString());
        if (charset != null) {
            return charset;
        }
        charset = this.map.getProperty(locale.getLanguage());
        return charset;
    }

    public void addCharsetMappingFromDeploymentDescriptor(String locale, String charset) {
        this.map.put(locale, charset);
    }

    public final Object clone() {
        try {
            CharsetMapper clone = (CharsetMapper)super.clone();
            clone.map = (Properties)this.map.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }
}

