/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.logex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.pfl.basic.algorithm.AnnotationAnalyzer;
import org.glassfish.pfl.basic.logex.Chain;
import org.glassfish.pfl.basic.logex.ExceptionWrapper;
import org.glassfish.pfl.basic.logex.Log;
import org.glassfish.pfl.basic.logex.LogLevel;
import org.glassfish.pfl.basic.logex.Message;
import org.glassfish.pfl.basic.logex.NoStackTrace;
import org.glassfish.pfl.basic.logex.StackTrace;
import org.glassfish.pfl.basic.proxy.CompositeInvocationHandlerImpl;

public class WrapperGenerator {
    static final Extension stdExtension = new ExtensionBase(){};
    static final AnnotationAnalyzer aa = new AnnotationAnalyzer();
    static final String cihiName = CompositeInvocationHandlerImpl.class.getName();

    public static String getStandardLogId(Method method) {
        Class<?> cls = method.getDeclaringClass();
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        String idPrefix = ew.idPrefix();
        Log log = aa.getAnnotation(method, Log.class);
        if (log == null) {
            return null;
        }
        String result = String.format("%s%05d", idPrefix, log.id());
        return result;
    }

    static Throwable makeStandardException(String msg, Method method) {
        Throwable result;
        Class<?> rtype = method.getReturnType();
        try {
            Constructor<?> cons = rtype.getConstructor(String.class);
            result = (Throwable)cons.newInstance(msg);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    static String getStandardLoggerName(Class<?> cls) {
        ExceptionWrapper ew = aa.getAnnotation(cls, ExceptionWrapper.class);
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        return str;
    }

    private WrapperGenerator() {
    }

    static int findAnnotatedParameter(Annotation[][] pannos, Class<? extends Annotation> cls) {
        for (int ctr1 = 0; ctr1 < pannos.length; ++ctr1) {
            Annotation[] annos = pannos[ctr1];
            for (int ctr2 = 0; ctr2 < annos.length; ++ctr2) {
                Annotation anno = annos[ctr2];
                if (!cls.isInstance(anno)) continue;
                return ctr1;
            }
        }
        return -1;
    }

    static Object[] getWithSkip(Object[] args, int skip) {
        if (skip >= 0) {
            Object[] result = new Object[args.length - 1];
            int rindex = 0;
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr == skip) continue;
                result[rindex++] = args[ctr];
            }
            return result;
        }
        return args;
    }

    static String getMsgKey(String logger, Method method) {
        return logger + "." + method.getName();
    }

    static Map<String, String> getMessageMap(Class<?> cls, Extension extension) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        ExceptionWrapper ew = aa.getAnnotation(cls, ExceptionWrapper.class);
        String loggerName = ew.loggerName();
        String idPrefix = ew.idPrefix();
        for (Method method : cls.getMethods()) {
            String key = WrapperGenerator.getMsgKey(loggerName, method);
            String msg = WrapperGenerator.getMessage(method, idPrefix, extension);
            result.put(key, msg);
        }
        return result;
    }

    static String getMessage(Method method, String prefix, Extension extension) {
        Message message = aa.getAnnotation(method, Message.class);
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(": ");
        }
        if (message == null) {
            sb.append(method.getName());
            sb.append(' ');
            for (int ctr = 0; ctr < method.getParameterTypes().length; ++ctr) {
                if (ctr > 0) {
                    sb.append(", ");
                }
                sb.append("arg");
                sb.append(ctr);
                sb.append("={").append(ctr).append("}");
            }
        } else {
            sb.append(message.value());
        }
        return sb.toString();
    }

    static String getMessageOrKey(Logger logger, Method method, Extension extension) {
        String msgKey;
        String prefix = extension.getLogId(method);
        ResourceBundle catalog = logger.getResourceBundle();
        String transMsg = null;
        if (catalog != null && ((transMsg = catalog.getString(msgKey = WrapperGenerator.getMsgKey(logger.getName(), method))) != null || transMsg.equals(msgKey))) {
            transMsg = null;
        }
        if (transMsg == null) {
            transMsg = WrapperGenerator.getMessage(method, prefix, extension);
        }
        return transMsg;
    }

    static String handleMessageOnly(Method method, Extension extension, Logger logger, Object[] messageParams) {
        String prefix = extension.getLogId(method);
        ResourceBundle catalog = logger.getResourceBundle();
        String transMsg = WrapperGenerator.getMessageOrKey(logger, method, extension);
        String result = transMsg.indexOf("{0") >= 0 ? MessageFormat.format(transMsg, messageParams) : transMsg;
        return result;
    }

    static ReturnType classifyReturnType(Method method) {
        Class<?> rtype = method.getReturnType();
        if (rtype.equals(Void.TYPE)) {
            return ReturnType.NULL;
        }
        if (rtype.equals(String.class)) {
            return ReturnType.STRING;
        }
        if (Throwable.class.isAssignableFrom(rtype)) {
            return ReturnType.EXCEPTION;
        }
        throw new RuntimeException("Method " + method + " has an illegal return type");
    }

    static LogRecord makeLogRecord(Level level, String key, Object[] args, Logger logger) {
        LogRecord result = new LogRecord(level, key);
        if (args != null && args.length > 0) {
            result.setParameters(args);
        }
        result.setLoggerName(logger.getName());
        result.setResourceBundle(logger.getResourceBundle());
        return result;
    }

    static void trimStackTrace(Throwable exc, LogRecord lrec) {
        StackTraceElement[] st = exc.getStackTrace();
        ArrayList<StackTraceElement> filtered = new ArrayList<StackTraceElement>();
        boolean skipping = true;
        for (StackTraceElement ste : st) {
            if (skipping) {
                if (!ste.getClassName().equals(cihiName) || !ste.getMethodName().equals("invoke")) continue;
                skipping = false;
                continue;
            }
            filtered.add(ste);
        }
        exc.setStackTrace(filtered.toArray(new StackTraceElement[filtered.size()]));
        StackTraceElement caller = (StackTraceElement)filtered.get(1);
        lrec.setSourceClassName(caller.getClassName());
        lrec.setSourceMethodName(caller.getMethodName());
    }

    static boolean isMajorLevel(Level level) {
        return level.intValue() > Level.INFO.intValue();
    }

    static boolean needStackTrace(Level level, Method method) {
        Class<?> mcls = method.getDeclaringClass();
        boolean hasClassST = aa.getAnnotation(mcls, StackTrace.class) != null;
        boolean hasClassNST = aa.getAnnotation(mcls, NoStackTrace.class) != null;
        boolean hasMethodST = aa.getAnnotation(method, StackTrace.class) != null;
        boolean hasMethodNST = aa.getAnnotation(method, NoStackTrace.class) != null;
        boolean highLevel = WrapperGenerator.isMajorLevel(level);
        boolean useST = false;
        useST = hasClassST ? !hasMethodNST : (hasClassNST ? hasMethodST : (hasMethodST ? true : (hasMethodNST ? false : highLevel)));
        return useST;
    }

    static Object handleFullLogging(Log log, Method method, ReturnType rtype, Logger logger, String idPrefix, Object[] messageParams, Throwable cause, Extension extension) {
        Level level = log.level().getLevel();
        boolean useST = WrapperGenerator.needStackTrace(level, method);
        String msgKey = WrapperGenerator.getMessageOrKey(logger, method, extension);
        LogRecord lrec = WrapperGenerator.makeLogRecord(level, msgKey, messageParams, logger);
        ShortFormatter formatter = new ShortFormatter();
        String message = formatter.format(lrec);
        Throwable exc = null;
        if (rtype == ReturnType.EXCEPTION) {
            exc = extension.makeException(message, method);
            if (exc != null) {
                WrapperGenerator.trimStackTrace(exc, lrec);
                if (cause != null) {
                    exc.initCause(cause);
                }
            }
        } else {
            WrapperGenerator.trimStackTrace(new Throwable(), lrec);
        }
        if (exc != null && useST) {
            lrec.setThrown(exc);
        }
        switch (rtype) {
            case EXCEPTION: {
                return exc;
            }
            case STRING: {
                return message;
            }
        }
        return null;
    }

    public static <T> T makeWrapper(Class<T> cls) {
        return WrapperGenerator.makeWrapper(cls, stdExtension);
    }

    public static <T> T makeWrapper(final Class<T> cls, final Extension extension) {
        try {
            if (!cls.isInterface()) {
                throw new IllegalArgumentException("Class " + cls + "is not an interface");
            }
            ExceptionWrapper ew = aa.getAnnotation(cls, ExceptionWrapper.class);
            final String idPrefix = ew.idPrefix();
            String name = extension.getLoggerName(cls);
            Logger lg = null;
            try {
                lg = Logger.getLogger(name, name);
            }
            catch (MissingResourceException exc) {
                lg = Logger.getLogger(name);
            }
            final Logger logger = lg;
            InvocationHandler inh = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    ReturnType rtype = WrapperGenerator.classifyReturnType(method);
                    Log log = aa.getAnnotation(method, Log.class);
                    if (rtype == ReturnType.NULL) {
                        if (log == null) {
                            return null;
                        }
                        LogLevel level = log.level();
                        if (!logger.isLoggable(level.getLevel())) {
                            return null;
                        }
                    }
                    Annotation[][] pannos = method.getParameterAnnotations();
                    int chainIndex = WrapperGenerator.findAnnotatedParameter(pannos, Chain.class);
                    Object[] messageParams = WrapperGenerator.getWithSkip(args, chainIndex);
                    if (log == null) {
                        if (rtype != ReturnType.STRING) {
                            throw new IllegalArgumentException("No @Log annotation present on " + cls.getName() + "." + method.getName());
                        }
                        return WrapperGenerator.handleMessageOnly(method, extension, logger, messageParams);
                    }
                    Throwable cause = null;
                    if (chainIndex >= 0) {
                        cause = (Throwable)args[chainIndex];
                    }
                    return WrapperGenerator.handleFullLogging(log, method, rtype, logger, idPrefix, messageParams, cause, extension);
                }
            };
            InvocationHandler inhmi = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getMessageInfo")) {
                        return WrapperGenerator.getMessageMap(cls, extension);
                    }
                    throw new RuntimeException("Unexpected method " + method);
                }
            };
            CompositeInvocationHandlerImpl cih = new CompositeInvocationHandlerImpl(){
                private static final long serialVersionUID = 3086904407674824236L;

                public String toString() {
                    return "ExceptionWrapper[" + cls.getName() + "]";
                }
            };
            cih.addInvocationHandler(cls, inh);
            cih.addInvocationHandler(MessageInfo.class, inhmi);
            ClassLoader loader = cls.getClassLoader();
            Class[] classes = new Class[]{cls, MessageInfo.class};
            return (T)Proxy.newProxyInstance(loader, classes, (InvocationHandler)cih);
        }
        catch (Throwable thr) {
            Logger.getLogger(WrapperGenerator.class.getName()).log(Level.SEVERE, "Error in makeWrapper for " + cls, thr);
            return null;
        }
    }

    public static interface Extension {
        public String getLogId(Method var1);

        public Throwable makeException(String var1, Method var2);

        public String getLoggerName(Class<?> var1);
    }

    public static abstract class ExtensionBase
    implements Extension {
        @Override
        public String getLogId(Method method) {
            return WrapperGenerator.getStandardLogId(method);
        }

        @Override
        public Throwable makeException(String msg, Method method) {
            return WrapperGenerator.makeStandardException(msg, method);
        }

        @Override
        public String getLoggerName(Class<?> cls) {
            return WrapperGenerator.getStandardLoggerName(cls);
        }
    }

    public static interface MessageInfo {
        public Map<String, String> getMessageInfo();
    }

    static enum ReturnType {
        EXCEPTION,
        STRING,
        NULL;

    }

    static class ShortFormatter
    extends Formatter {
        ShortFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            return sb.toString();
        }
    }
}

