/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.theme.JSFThemeContext;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeFactory;
import com.sun.webui.theme.ThemeImage;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;

public class ThemeUtilities {
    private static final String JSFTHEME = "com.sun.webui.jsf.theme.THEME";

    public static Theme getTheme(FacesContext context) {
        Theme theme = (Theme)context.getExternalContext().getRequestMap().get(JSFTHEME);
        if (theme != null) {
            return theme;
        }
        Locale locale = context.getViewRoot().getLocale();
        String themeName = null;
        Map sessionAttributes = context.getExternalContext().getSessionMap();
        Object themeObject = sessionAttributes.get("com.sun.webui.jsf.Theme");
        if (themeObject != null) {
            themeName = themeObject.toString().trim();
        }
        ThemeContext themeContext = JSFThemeContext.getInstance(context);
        ThemeFactory themeFactory = themeContext.getThemeFactory();
        theme = themeFactory.getTheme(themeName, locale, themeContext);
        if (themeName == null && (themeName = themeFactory.getDefaultThemeName(themeContext)) != null) {
            sessionAttributes.put("com.sun.webui.jsf.Theme", themeName);
        }
        context.getExternalContext().getRequestMap().put(JSFTHEME, theme);
        return theme;
    }

    public static Icon getIcon(Theme theme, String iconKey) {
        Icon icon = new Icon();
        icon.setIcon(iconKey);
        if (iconKey == null) {
            return icon;
        }
        ThemeImage themeImage = null;
        themeImage = theme.getImage(iconKey);
        icon.setUrl(themeImage.getPath());
        icon.setAlt(themeImage.getAlt());
        icon.setHeight(themeImage.getHeight());
        icon.setWidth(themeImage.getWidth());
        return icon;
    }
}

