/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Constraint;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.Version;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class DependAction
extends Action {
    static final Map<String, Type> knownTypes = new HashMap<String, Type>();
    private Image img;
    private Type type;
    private String fmriStr;
    private Constraint constraint;

    DependAction(Image image, Fmri srcfmri, String[] tokens) {
        super(1, tokens);
        knownTypes.put("require", Type.REQUIRED);
        knownTypes.put("optional", Type.OPTIONAL);
        knownTypes.put("transfer", Type.TRANSFER);
        knownTypes.put("incorporate", Type.INCORPORATE);
        knownTypes.put("exclude", Type.EXCLUDE);
        this.img = image;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].startsWith("fmri=")) {
                this.fmriStr = tokens[i].substring(5);
                continue;
            }
            if (!tokens[i].startsWith("type=")) continue;
            String typeStr = tokens[i].substring(5);
            if (knownTypes.containsKey(typeStr)) {
                this.type = knownTypes.get(typeStr);
                continue;
            }
            throw new IllegalArgumentException("unknown depend type: " + typeStr);
        }
        Fmri f = new Fmri(this.fmriStr);
        String name = f.getName();
        Version minVer = f.getVersion();
        Version maxVer = null;
        Constraint.Presence presence = null;
        if (this.type == Type.REQUIRED) {
            presence = Constraint.Presence.ALWAYS;
        } else if (this.type == Type.EXCLUDE) {
            presence = Constraint.Presence.NEVER;
        } else if (this.type == Type.INCORPORATE) {
            presence = Constraint.Presence.MAYBE;
            maxVer = minVer;
        } else if (this.type == Type.OPTIONAL) {
            presence = Constraint.Presence.MAYBE;
        } else if (this.type == Type.TRANSFER) {
            presence = Constraint.Presence.MAYBE;
        }
        this.constraint = new Constraint(name, minVer, maxVer, presence, srcfmri.getName());
    }

    void install(Action orig) throws IOException {
    }

    public Type getType() {
        return this.type;
    }

    Fmri getConstrainedFmri() {
        if (this.type != Type.INCORPORATE) {
            return null;
        }
        Fmri f = new Fmri(this.fmriStr);
        this.img.setFmriDefaultAuthority(f);
        return f;
    }

    public Fmri getTargetFmri() {
        return new Fmri(this.fmriStr);
    }

    Constraint getConstraint() {
        return this.constraint;
    }

    String keyValue() {
        return this.fmriStr;
    }

    public String toString() {
        return "depend: fmri=" + this.fmriStr + ", type=" + (Object)((Object)this.type) + ", constraint=" + this.constraint;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof DependAction)) {
            return true;
        }
        DependAction da = (DependAction)a;
        return !this.equals(a) || !this.constraint.equals(da.constraint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        REQUIRED,
        OPTIONAL,
        TRANSFER,
        INCORPORATE,
        EXCLUDE;

    }
}

