/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.util;

import com.sun.pkg.util.Base64;
import com.sun.pkg.util.DerOutputStream;
import com.sun.pkg.util.DerValue;
import com.sun.pkg.util.ObjectIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PEMUtil {
    private static final String RSA_OID = "1.2.840.113549.1.1.1";

    public static SSLSocketFactory getSSLSocketFactory(File certfile, File keyfile) throws IOException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String password = "dummy";
            KeyStore keystore = PEMUtil.getKeyStore(certfile, keyfile, password);
            kmf.init(keystore, password.toCharArray());
            KeyManager[] managers = kmf.getKeyManagers();
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(managers, trustAllCerts, null);
            return sc.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException("invalid certificate/key for SSL connection");
        }
    }

    static KeyStore getKeyStore(File certfile, File keyfile, String password) throws IOException {
        try {
            PrivateKey privKey = PEMUtil.getPrivateKey(keyfile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate[] certchain = new Certificate[]{cf.generateCertificate(new FileInputStream(certfile))};
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(null, null);
            keystore.setKeyEntry("clientcert", privKey, password.toCharArray(), certchain);
            return keystore;
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            IOException ioe = new IOException("invalid certificate or key file");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    static PrivateKey getPrivateKey(File infile) throws IOException {
        try {
            byte[] key = Base64.decode(new FileInputStream(infile));
            DerValue[] outer = new DerValue[3];
            DerOutputStream temp = new DerOutputStream();
            temp.putInteger(BigInteger.ZERO);
            outer[0] = new DerValue(temp.toByteArray());
            DerValue[] innervec = new DerValue[2];
            temp = new DerOutputStream();
            temp.putOID(new ObjectIdentifier(RSA_OID));
            innervec[0] = new DerValue(temp.toByteArray());
            temp = new DerOutputStream();
            temp.putNull();
            innervec[1] = new DerValue(temp.toByteArray());
            DerOutputStream inner = new DerOutputStream();
            inner.putSequence(innervec);
            outer[1] = new DerValue(inner.toByteArray());
            temp = new DerOutputStream();
            temp.putOctetString(key);
            outer[2] = new DerValue(temp.toByteArray());
            DerOutputStream derout = new DerOutputStream();
            derout.putSequence(outer);
            byte[] dkey = derout.toByteArray();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(dkey));
        }
        catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            IOException ioe = new IOException("invalid key file");
            ioe.initCause(ex);
            throw ioe;
        }
    }
}

