package net.azib.ipscan.config;

import dagger.MembersInjector;
import dagger.internal.MembersInjectors;
import dagger.internal.ScopedProvider;
import java.util.List;
import java.util.prefs.Preferences;
import javax.annotation.Generated;
import javax.inject.Provider;
import net.azib.ipscan.core.Plugin;
import net.azib.ipscan.core.PluginLoader;
import net.azib.ipscan.core.PluginLoader_GetClassesFactory;
import net.azib.ipscan.core.Scanner;
import net.azib.ipscan.core.ScannerDispatcherThreadFactory;
import net.azib.ipscan.core.ScannerDispatcherThreadFactory_Factory;
import net.azib.ipscan.core.Scanner_Factory;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.ScanningResultList_Factory;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.core.net.PingerRegistry_Factory;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.exporters.CSVExporter;
import net.azib.ipscan.exporters.CSVExporter_Factory;
import net.azib.ipscan.exporters.Exporter;
import net.azib.ipscan.exporters.ExporterRegistry;
import net.azib.ipscan.exporters.ExporterRegistry_Factory;
import net.azib.ipscan.exporters.IPListExporter;
import net.azib.ipscan.exporters.IPListExporter_Factory;
import net.azib.ipscan.exporters.TXTExporter;
import net.azib.ipscan.exporters.TXTExporter_Factory;
import net.azib.ipscan.exporters.XMLExporter;
import net.azib.ipscan.exporters.XMLExporter_Factory;
import net.azib.ipscan.feeders.FeederCreator;
import net.azib.ipscan.feeders.FeederRegistry;
import net.azib.ipscan.fetchers.CommentFetcher;
import net.azib.ipscan.fetchers.CommentFetcher_Factory;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherRegistry;
import net.azib.ipscan.fetchers.FetcherRegistry_Factory;
import net.azib.ipscan.fetchers.FilteredPortsFetcher;
import net.azib.ipscan.fetchers.FilteredPortsFetcher_Factory;
import net.azib.ipscan.fetchers.HTTPSenderFetcher;
import net.azib.ipscan.fetchers.HTTPSenderFetcher_Factory;
import net.azib.ipscan.fetchers.HostnameFetcher;
import net.azib.ipscan.fetchers.HostnameFetcher_Factory;
import net.azib.ipscan.fetchers.IPFetcher;
import net.azib.ipscan.fetchers.IPFetcher_Factory;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.fetchers.MACVendorFetcher;
import net.azib.ipscan.fetchers.MACVendorFetcher_Factory;
import net.azib.ipscan.fetchers.NetBIOSInfoFetcher;
import net.azib.ipscan.fetchers.NetBIOSInfoFetcher_Factory;
import net.azib.ipscan.fetchers.PingFetcher;
import net.azib.ipscan.fetchers.PingFetcher_Factory;
import net.azib.ipscan.fetchers.PingTTLFetcher;
import net.azib.ipscan.fetchers.PingTTLFetcher_Factory;
import net.azib.ipscan.fetchers.PortsFetcher;
import net.azib.ipscan.fetchers.PortsFetcher_Factory;
import net.azib.ipscan.fetchers.WebDetectFetcher;
import net.azib.ipscan.fetchers.WebDetectFetcher_Factory;
import net.azib.ipscan.gui.AboutDialog;
import net.azib.ipscan.gui.AboutDialog_Factory;
import net.azib.ipscan.gui.DetailsWindow;
import net.azib.ipscan.gui.DetailsWindow_Factory;
import net.azib.ipscan.gui.DetailsWindow_MembersInjector;
import net.azib.ipscan.gui.MacApplicationMenu;
import net.azib.ipscan.gui.MacApplicationMenu_Factory;
import net.azib.ipscan.gui.MacApplicationMenu_MembersInjector;
import net.azib.ipscan.gui.MainMenu;
import net.azib.ipscan.gui.MainMenu_Factory;
import net.azib.ipscan.gui.MainWindow;
import net.azib.ipscan.gui.MainWindow_Factory;
import net.azib.ipscan.gui.PreferencesDialog;
import net.azib.ipscan.gui.PreferencesDialog_Factory;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.ResultTable_Factory;
import net.azib.ipscan.gui.SWTAwareStateMachine;
import net.azib.ipscan.gui.SWTAwareStateMachine_Factory;
import net.azib.ipscan.gui.SelectFetchersDialog;
import net.azib.ipscan.gui.SelectFetchersDialog_Factory;
import net.azib.ipscan.gui.Startup;
import net.azib.ipscan.gui.Startup_Factory;
import net.azib.ipscan.gui.Startup_MembersInjector;
import net.azib.ipscan.gui.StatisticsDialog;
import net.azib.ipscan.gui.StatisticsDialog_Factory;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.StatusBar_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions$AboutFetcher_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions$ColumnClick_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions$ColumnResize_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions$FetcherPreferences_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions$SortBy_Factory;
import net.azib.ipscan.gui.actions.ColumnsActions.ColumnClick;
import net.azib.ipscan.gui.actions.ColumnsActions.ColumnResize;
import net.azib.ipscan.gui.actions.ColumnsActions.FetcherPreferences;
import net.azib.ipscan.gui.actions.ColumnsActions.SortBy;
import net.azib.ipscan.gui.actions.CommandsMenuActions;
import net.azib.ipscan.gui.actions.CommandsMenuActions$CopyIPDetails_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$CopyIP_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$Delete_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$Details_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$EditOpeners_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$Rescan_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$SelectOpener_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions$ShowOpenersMenu_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions.CopyIP;
import net.azib.ipscan.gui.actions.CommandsMenuActions.CopyIPDetails;
import net.azib.ipscan.gui.actions.CommandsMenuActions.Delete;
import net.azib.ipscan.gui.actions.CommandsMenuActions.Details;
import net.azib.ipscan.gui.actions.CommandsMenuActions.EditOpeners;
import net.azib.ipscan.gui.actions.CommandsMenuActions.Rescan;
import net.azib.ipscan.gui.actions.CommandsMenuActions.SelectOpener;
import net.azib.ipscan.gui.actions.CommandsMenuActions.ShowOpenersMenu;
import net.azib.ipscan.gui.actions.CommandsMenuActions_Factory;
import net.azib.ipscan.gui.actions.CommandsMenuActions_MembersInjector;
import net.azib.ipscan.gui.actions.FavoritesMenuActions$Add_Factory;
import net.azib.ipscan.gui.actions.FavoritesMenuActions$Edit_Factory;
import net.azib.ipscan.gui.actions.FavoritesMenuActions$Select_Factory;
import net.azib.ipscan.gui.actions.FavoritesMenuActions$ShowMenu_Factory;
import net.azib.ipscan.gui.actions.FavoritesMenuActions.Add;
import net.azib.ipscan.gui.actions.FavoritesMenuActions.Edit;
import net.azib.ipscan.gui.actions.FavoritesMenuActions.Select;
import net.azib.ipscan.gui.actions.FavoritesMenuActions.ShowMenu;
import net.azib.ipscan.gui.actions.GotoMenuActions$Find_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$NextAliveHost_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$NextDeadHost_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$NextHostWithInfo_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$PrevAliveHost_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$PrevDeadHost_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions$PrevHostWithInfo_Factory;
import net.azib.ipscan.gui.actions.GotoMenuActions.Find;
import net.azib.ipscan.gui.actions.GotoMenuActions.NextAliveHost;
import net.azib.ipscan.gui.actions.GotoMenuActions.NextDeadHost;
import net.azib.ipscan.gui.actions.GotoMenuActions.NextHostWithInfo;
import net.azib.ipscan.gui.actions.GotoMenuActions.PrevAliveHost;
import net.azib.ipscan.gui.actions.GotoMenuActions.PrevDeadHost;
import net.azib.ipscan.gui.actions.GotoMenuActions.PrevHostWithInfo;
import net.azib.ipscan.gui.actions.HelpMenuActions$About_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$CheckVersion_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$CommandLineUsage_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$FAQ_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$GettingStarted_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$Issues_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$Plugins_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions$Website_Factory;
import net.azib.ipscan.gui.actions.HelpMenuActions.About;
import net.azib.ipscan.gui.actions.HelpMenuActions.CheckVersion;
import net.azib.ipscan.gui.actions.HelpMenuActions.CommandLineUsage;
import net.azib.ipscan.gui.actions.OpenerLauncher;
import net.azib.ipscan.gui.actions.OpenerLauncher_Factory;
import net.azib.ipscan.gui.actions.ScanMenuActions$LoadFromFile_Factory;
import net.azib.ipscan.gui.actions.ScanMenuActions$Quit_Factory;
import net.azib.ipscan.gui.actions.ScanMenuActions$SaveAll_Factory;
import net.azib.ipscan.gui.actions.ScanMenuActions$SaveSelection_Factory;
import net.azib.ipscan.gui.actions.ScanMenuActions.LoadFromFile;
import net.azib.ipscan.gui.actions.ScanMenuActions.SaveAll;
import net.azib.ipscan.gui.actions.ScanMenuActions.SaveSelection;
import net.azib.ipscan.gui.actions.StartStopScanningAction;
import net.azib.ipscan.gui.actions.StartStopScanningAction_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$ChooseFetchers_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$Preferences_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$ScanStatistics_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$SelectAlive_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$SelectDead_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$SelectInvert_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$SelectWithPorts_Factory;
import net.azib.ipscan.gui.actions.ToolsActions$SelectWithoutPorts_Factory;
import net.azib.ipscan.gui.actions.ToolsActions.ChooseFetchers;
import net.azib.ipscan.gui.actions.ToolsActions;
import net.azib.ipscan.gui.actions.ToolsActions.ScanStatistics;
import net.azib.ipscan.gui.actions.ToolsActions.SelectAlive;
import net.azib.ipscan.gui.actions.ToolsActions.SelectDead;
import net.azib.ipscan.gui.actions.ToolsActions.SelectInvert;
import net.azib.ipscan.gui.actions.ToolsActions.SelectWithPorts;
import net.azib.ipscan.gui.actions.ToolsActions.SelectWithoutPorts;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry_Factory;
import net.azib.ipscan.gui.feeders.FileFeederGUI;
import net.azib.ipscan.gui.feeders.FileFeederGUI_Factory;
import net.azib.ipscan.gui.feeders.RandomFeederGUI;
import net.azib.ipscan.gui.feeders.RandomFeederGUI_Factory;
import net.azib.ipscan.gui.feeders.RangeFeederGUI;
import net.azib.ipscan.gui.feeders.RangeFeederGUI_Factory;
import net.azib.ipscan.gui.menu.ColumnsMenu;
import net.azib.ipscan.gui.menu.ColumnsMenu_Factory;
import net.azib.ipscan.gui.menu.CommandsMenu;
import net.azib.ipscan.gui.menu.CommandsMenu_Factory;
import net.azib.ipscan.gui.menu.FavoritesMenu;
import net.azib.ipscan.gui.menu.FavoritesMenu_Factory;
import net.azib.ipscan.gui.menu.GotoMenu;
import net.azib.ipscan.gui.menu.GotoMenu_Factory;
import net.azib.ipscan.gui.menu.HelpMenu;
import net.azib.ipscan.gui.menu.HelpMenu_Factory;
import net.azib.ipscan.gui.menu.OpenersMenu;
import net.azib.ipscan.gui.menu.OpenersMenu_Factory;
import net.azib.ipscan.gui.menu.ResultsContextMenu;
import net.azib.ipscan.gui.menu.ResultsContextMenu_Factory;
import net.azib.ipscan.gui.menu.ScanMenu;
import net.azib.ipscan.gui.menu.ScanMenu_Factory;
import net.azib.ipscan.gui.menu.ToolsMenu;
import net.azib.ipscan.gui.menu.ToolsMenu_Factory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

@Generated("dagger.internal.codegen.ComponentProcessor")
public final class DaggerMainComponent implements MainComponent {
  private Provider<Shell> mainShellProvider;
  private Provider<GUIConfig> forGUIProvider;
  private Provider<Composite> feederAreaProvider;
  private Provider<Composite> controlsAreaProvider;
  private Provider<Combo> feederSelectionComboProvider;
  private Provider<Button> startStopButtonProvider;
  private Provider<List<Class<? extends Plugin>>> getClassesProvider;
  private Provider<IPFetcher> iPFetcherProvider;
  private Provider<ScannerConfig> forScannerProvider;
  private Provider<PingerRegistry> pingerRegistryProvider;
  private Provider<PingFetcher> pingFetcherProvider;
  private Provider<PingTTLFetcher> pingTTLFetcherProvider;
  private Provider<HostnameFetcher> hostnameFetcherProvider;
  private Provider<PortsFetcher> portsFetcherProvider;
  private Provider<FilteredPortsFetcher> filteredPortsFetcherProvider;
  private Provider<WebDetectFetcher> webDetectFetcherProvider;
  private Provider<HTTPSenderFetcher> hTTPSenderFetcherProvider;
  private Provider<Preferences> getPreferencesProvider;
  private Provider<CommentsConfig> commentsConfigProvider;
  private Provider<CommentFetcher> commentFetcherProvider;
  private Provider<NetBIOSInfoFetcher> netBIOSInfoFetcherProvider;
  private Provider<MACFetcher> selectMacFetcherProvider;
  private Provider<MACVendorFetcher> mACVendorFetcherProvider;
  private Provider<List<Fetcher>> fetchersProvider;
  private Provider<Config> getConfigProvider;
  private Provider<PreferencesDialog> preferencesDialogProvider;
  private Provider<FetcherRegistry> fetcherRegistryProvider;
  private Provider<Display> getDisplayProvider;
  private Provider<SWTAwareStateMachine> sWTAwareStateMachineProvider;
  private Provider<StateMachine> stateMachineProvider;
  private Provider<ScanningResultList> scanningResultListProvider;
  private Provider<Scanner> scannerProvider;
  private Provider<ScannerDispatcherThreadFactory> scannerDispatcherThreadFactoryProvider;
  private Provider<SortBy> sortByProvider;
  private Provider<FetcherPreferences> fetcherPreferencesProvider;
  private Provider<ColumnsMenu> columnsMenuProvider;
  private Provider<ColumnClick> columnClickProvider;
  private Provider<ColumnResize> columnResizeProvider;
  private Provider<ResultTable> resultTableProvider;
  private Provider<StatusBar> statusBarProvider;
  private Provider<RangeFeederGUI> rangeFeederGUIProvider;
  private Provider<RandomFeederGUI> randomFeederGUIProvider;
  private Provider<FileFeederGUI> fileFeederGUIProvider;
  private Provider<List<AbstractFeederGUI>> feedersProvider;
  private Provider<FeederGUIRegistry> feederGUIRegistryProvider;
  private Provider<StartStopScanningAction> startStopScanningActionProvider;
  private MembersInjector<DetailsWindow> detailsWindowMembersInjector;
  private Provider<DetailsWindow> detailsWindowProvider;
  private Provider<Details> detailsProvider;
  private Provider<Delete> deleteProvider;
  private Provider<Rescan> rescanProvider;
  private Provider<CopyIP> copyIPProvider;
  private Provider<CopyIPDetails> copyIPDetailsProvider;
  private Provider<OpenersConfig> forOpenersProvider;
  private Provider<OpenerLauncher> openerLauncherProvider;
  private Provider<SelectOpener> selectOpenerProvider;
  private Provider<ShowOpenersMenu> showOpenersMenuProvider;
  private Provider<EditOpeners> editOpenersProvider;
  private MembersInjector<CommandsMenuActions> commandsMenuActionsMembersInjector;
  private Provider<CommandsMenuActions> commandsMenuActionsProvider;
  private Provider<OpenersMenu> openersMenuProvider;
  private Provider<ResultsContextMenu> resultsContextMenuProvider;
  private Provider<ToolsActions.Preferences> preferencesProvider;
  private Provider<SelectFetchersDialog> selectFetchersDialogProvider;
  private Provider<ChooseFetchers> chooseFetchersProvider;
  private Provider<Menu> mainMenuProvider;
  private Provider<TXTExporter> tXTExporterProvider;
  private Provider<CSVExporter> cSVExporterProvider;
  private Provider<XMLExporter> xMLExporterProvider;
  private Provider<IPListExporter> iPListExporterProvider;
  private Provider<List<Exporter>> exportersProvider;
  private Provider<ExporterRegistry> exporterRegistryProvider;
  private Provider<LoadFromFile> loadFromFileProvider;
  private Provider<SaveAll> saveAllProvider;
  private Provider<SaveSelection> saveSelectionProvider;
  private Provider<ScanMenu> scanMenuProvider;
  private Provider<NextAliveHost> nextAliveHostProvider;
  private Provider<NextHostWithInfo> nextHostWithInfoProvider;
  private Provider<NextDeadHost> nextDeadHostProvider;
  private Provider<PrevAliveHost> prevAliveHostProvider;
  private Provider<PrevHostWithInfo> prevHostWithInfoProvider;
  private Provider<PrevDeadHost> prevDeadHostProvider;
  private Provider<Find> findProvider;
  private Provider<GotoMenu> gotoMenuProvider;
  private Provider<CommandsMenu> commandsMenuProvider;
  private Provider<FavoritesConfig> favoritesConfigProvider;
  private Provider<Add> addProvider;
  private Provider<Edit> editProvider;
  private Provider<Select> selectProvider;
  private Provider<ShowMenu> showMenuProvider;
  private Provider<FavoritesMenu> favoritesMenuProvider;
  private Provider<StatisticsDialog> statisticsDialogProvider;
  private Provider<FeederRegistry<? extends FeederCreator>> feederRegistryProvider;
  private Provider<CommandLineProcessor> commandLineProcessorProvider;
  private Provider<ScanStatistics> scanStatisticsProvider;
  private Provider<SelectAlive> selectAliveProvider;
  private Provider<SelectDead> selectDeadProvider;
  private Provider<SelectWithPorts> selectWithPortsProvider;
  private Provider<SelectWithoutPorts> selectWithoutPortsProvider;
  private Provider<SelectInvert> selectInvertProvider;
  private Provider<ToolsMenu> toolsMenuProvider;
  private Provider<CommandLineUsage> commandLineUsageProvider;
  private Provider<CheckVersion> checkVersionProvider;
  private Provider<AboutDialog> aboutDialogProvider;
  private Provider<About> aboutProvider;
  private Provider<HelpMenu> helpMenuProvider;
  private Provider<MainMenu> mainMenuProvider1;
  private MembersInjector<Startup> startupMembersInjector;
  private Provider<Startup> startupProvider;
  private Provider<MainWindow> mainWindowProvider;
  private MembersInjector<MacApplicationMenu> macApplicationMenuMembersInjector;
  private Provider<MacApplicationMenu> macApplicationMenuProvider;

  private DaggerMainComponent(Builder builder) {  
    assert builder != null;
    initialize(builder);
    initialize1(builder);
  }

  public static Builder builder() {  
    return new Builder();
  }

  public static MainComponent create() {  
    return builder().build();
  }

  private void initialize(final Builder builder) {  
    this.mainShellProvider = ScopedProvider.create(ComponentRegistry_MainShellFactory.create(builder.componentRegistry));
    this.forGUIProvider = ConfigModule_ForGUIFactory.create(builder.configModule);
    this.feederAreaProvider = ScopedProvider.create(ComponentRegistry_FeederAreaFactory.create(builder.componentRegistry, mainShellProvider));
    this.controlsAreaProvider = ScopedProvider.create(ComponentRegistry_ControlsAreaFactory.create(builder.componentRegistry, mainShellProvider));
    this.feederSelectionComboProvider = ScopedProvider.create(ComponentRegistry_FeederSelectionComboFactory.create(builder.componentRegistry, controlsAreaProvider));
    this.startStopButtonProvider = ScopedProvider.create(ComponentRegistry_StartStopButtonFactory.create(builder.componentRegistry, controlsAreaProvider));
    this.getClassesProvider = ScopedProvider.create(PluginLoader_GetClassesFactory.create(builder.pluginLoader));
    this.iPFetcherProvider = IPFetcher_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.forScannerProvider = ConfigModule_ForScannerFactory.create(builder.configModule);
    this.pingerRegistryProvider = ScopedProvider.create(PingerRegistry_Factory.create(forScannerProvider));
    this.pingFetcherProvider = PingFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), pingerRegistryProvider, forScannerProvider);
    this.pingTTLFetcherProvider = PingTTLFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), pingerRegistryProvider, forScannerProvider);
    this.hostnameFetcherProvider = HostnameFetcher_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.portsFetcherProvider = PortsFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), forScannerProvider);
    this.filteredPortsFetcherProvider = FilteredPortsFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), forScannerProvider);
    this.webDetectFetcherProvider = WebDetectFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), forScannerProvider);
    this.hTTPSenderFetcherProvider = HTTPSenderFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), forScannerProvider);
    this.getPreferencesProvider = ConfigModule_GetPreferencesFactory.create(builder.configModule);
    this.commentsConfigProvider = CommentsConfig_Factory.create(getPreferencesProvider);
    this.commentFetcherProvider = CommentFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), commentsConfigProvider);
    this.netBIOSInfoFetcherProvider = NetBIOSInfoFetcher_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.selectMacFetcherProvider = ScopedProvider.create(ComponentRegistry_SelectMacFetcherFactory.create(builder.componentRegistry));
    this.mACVendorFetcherProvider = MACVendorFetcher_Factory.create((MembersInjector) MembersInjectors.noOp(), selectMacFetcherProvider);
    this.fetchersProvider = ScopedProvider.create(ComponentRegistry_FetchersFactory.create(builder.componentRegistry, getClassesProvider, iPFetcherProvider, pingFetcherProvider, pingTTLFetcherProvider, hostnameFetcherProvider, portsFetcherProvider, filteredPortsFetcherProvider, webDetectFetcherProvider, hTTPSenderFetcherProvider, commentFetcherProvider, netBIOSInfoFetcherProvider, selectMacFetcherProvider, mACVendorFetcherProvider));
    this.getConfigProvider = ConfigModule_GetConfigFactory.create(builder.configModule);
    this.preferencesDialogProvider = ScopedProvider.create(PreferencesDialog_Factory.create((MembersInjector) MembersInjectors.noOp(), pingerRegistryProvider, getConfigProvider, forScannerProvider, forGUIProvider));
    this.fetcherRegistryProvider = ScopedProvider.create(FetcherRegistry_Factory.create(fetchersProvider, getPreferencesProvider, preferencesDialogProvider));
    this.getDisplayProvider = ScopedProvider.create(ComponentRegistry_GetDisplayFactory.create(builder.componentRegistry));
    this.sWTAwareStateMachineProvider = ScopedProvider.create(SWTAwareStateMachine_Factory.create((MembersInjector) MembersInjectors.noOp(), getDisplayProvider));
    this.stateMachineProvider = ScopedProvider.create(ComponentRegistry_StateMachineFactory.create(builder.componentRegistry, sWTAwareStateMachineProvider));
    this.scanningResultListProvider = ScopedProvider.create(ScanningResultList_Factory.create(fetcherRegistryProvider, stateMachineProvider));
    this.scannerProvider = Scanner_Factory.create(fetcherRegistryProvider);
    this.scannerDispatcherThreadFactoryProvider = ScopedProvider.create(ScannerDispatcherThreadFactory_Factory.create(scanningResultListProvider, scannerProvider, stateMachineProvider, forScannerProvider));
    this.sortByProvider = ColumnsActions$SortBy_Factory.create(scanningResultListProvider);
    this.fetcherPreferencesProvider = ColumnsActions$FetcherPreferences_Factory.create(fetcherRegistryProvider);
    this.columnsMenuProvider = ScopedProvider.create(ColumnsMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, sortByProvider, ColumnsActions$AboutFetcher_Factory.create(), fetcherPreferencesProvider));
    this.columnClickProvider = ColumnsActions$ColumnClick_Factory.create(columnsMenuProvider, stateMachineProvider);
    this.columnResizeProvider = ColumnsActions$ColumnResize_Factory.create(forGUIProvider);
    this.resultTableProvider = ScopedProvider.create(ResultTable_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, forGUIProvider, fetcherRegistryProvider, scanningResultListProvider, stateMachineProvider, columnClickProvider, columnResizeProvider));
    this.statusBarProvider = ScopedProvider.create(StatusBar_Factory.create(mainShellProvider, forGUIProvider, forScannerProvider, resultTableProvider, stateMachineProvider));
    this.rangeFeederGUIProvider = ScopedProvider.create(RangeFeederGUI_Factory.create((MembersInjector) MembersInjectors.noOp(), feederAreaProvider));
    this.randomFeederGUIProvider = ScopedProvider.create(RandomFeederGUI_Factory.create((MembersInjector) MembersInjectors.noOp(), feederAreaProvider));
    this.fileFeederGUIProvider = ScopedProvider.create(FileFeederGUI_Factory.create((MembersInjector) MembersInjectors.noOp(), feederAreaProvider));
    this.feedersProvider = ScopedProvider.create(ComponentRegistry_FeedersFactory.create(builder.componentRegistry, rangeFeederGUIProvider, randomFeederGUIProvider, fileFeederGUIProvider));
    this.feederGUIRegistryProvider = ScopedProvider.create(FeederGUIRegistry_Factory.create(feedersProvider, feederSelectionComboProvider, forGUIProvider));
    this.startStopScanningActionProvider = ScopedProvider.create(StartStopScanningAction_Factory.create(scannerDispatcherThreadFactoryProvider, stateMachineProvider, resultTableProvider, statusBarProvider, feederGUIRegistryProvider, pingerRegistryProvider, startStopButtonProvider, forGUIProvider));
    this.detailsWindowMembersInjector = DetailsWindow_MembersInjector.create((MembersInjector) MembersInjectors.noOp(), commentsConfigProvider);
    this.detailsWindowProvider = DetailsWindow_Factory.create(detailsWindowMembersInjector, forGUIProvider, resultTableProvider, scanningResultListProvider);
    this.detailsProvider = CommandsMenuActions$Details_Factory.create(resultTableProvider, detailsWindowProvider);
    this.deleteProvider = CommandsMenuActions$Delete_Factory.create(resultTableProvider, stateMachineProvider);
    this.rescanProvider = CommandsMenuActions$Rescan_Factory.create(resultTableProvider, stateMachineProvider);
    this.copyIPProvider = CommandsMenuActions$CopyIP_Factory.create(resultTableProvider);
    this.copyIPDetailsProvider = CommandsMenuActions$CopyIPDetails_Factory.create(resultTableProvider);
    this.forOpenersProvider = ConfigModule_ForOpenersFactory.create(builder.configModule);
    this.openerLauncherProvider = OpenerLauncher_Factory.create(fetcherRegistryProvider, scanningResultListProvider);
    this.selectOpenerProvider = CommandsMenuActions$SelectOpener_Factory.create(forOpenersProvider, statusBarProvider, resultTableProvider, openerLauncherProvider);
    this.showOpenersMenuProvider = CommandsMenuActions$ShowOpenersMenu_Factory.create(forOpenersProvider, selectOpenerProvider);
    this.editOpenersProvider = CommandsMenuActions$EditOpeners_Factory.create(fetcherRegistryProvider, forOpenersProvider);
    this.commandsMenuActionsMembersInjector = CommandsMenuActions_MembersInjector.create(detailsProvider, deleteProvider, rescanProvider, copyIPProvider, copyIPDetailsProvider, showOpenersMenuProvider, editOpenersProvider, selectOpenerProvider);
    this.commandsMenuActionsProvider = ScopedProvider.create(CommandsMenuActions_Factory.create(commandsMenuActionsMembersInjector));
    this.openersMenuProvider = OpenersMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, editOpenersProvider, showOpenersMenuProvider);
    this.resultsContextMenuProvider = ScopedProvider.create(ResultsContextMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, commandsMenuActionsProvider, openersMenuProvider));
    this.preferencesProvider = ToolsActions$Preferences_Factory.create(preferencesDialogProvider, resultTableProvider, statusBarProvider);
    this.selectFetchersDialogProvider = SelectFetchersDialog_Factory.create((MembersInjector) MembersInjectors.noOp(), fetcherRegistryProvider);
  }

  private void initialize1(final Builder builder) {  
    this.chooseFetchersProvider = ToolsActions$ChooseFetchers_Factory.create(selectFetchersDialogProvider);
    this.mainMenuProvider = ScopedProvider.create(ComponentRegistry_MainMenuFactory.create(builder.componentRegistry, mainShellProvider));
    this.tXTExporterProvider = TXTExporter_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.cSVExporterProvider = CSVExporter_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.xMLExporterProvider = XMLExporter_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.iPListExporterProvider = IPListExporter_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.exportersProvider = ScopedProvider.create(ComponentRegistry_ExportersFactory.create(builder.componentRegistry, getClassesProvider, tXTExporterProvider, cSVExporterProvider, xMLExporterProvider, iPListExporterProvider));
    this.exporterRegistryProvider = ScopedProvider.create(ExporterRegistry_Factory.create(exportersProvider));
    this.loadFromFileProvider = ScanMenuActions$LoadFromFile_Factory.create(tXTExporterProvider, exporterRegistryProvider, feederGUIRegistryProvider, resultTableProvider, stateMachineProvider);
    this.saveAllProvider = ScanMenuActions$SaveAll_Factory.create((MembersInjector) MembersInjectors.noOp(), exporterRegistryProvider, resultTableProvider, statusBarProvider, stateMachineProvider);
    this.saveSelectionProvider = ScanMenuActions$SaveSelection_Factory.create((MembersInjector) MembersInjectors.noOp(), exporterRegistryProvider, resultTableProvider, statusBarProvider, stateMachineProvider);
    this.scanMenuProvider = ScopedProvider.create(ScanMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, loadFromFileProvider, saveAllProvider, saveSelectionProvider, ScanMenuActions$Quit_Factory.create()));
    this.nextAliveHostProvider = GotoMenuActions$NextAliveHost_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.nextHostWithInfoProvider = GotoMenuActions$NextHostWithInfo_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.nextDeadHostProvider = GotoMenuActions$NextDeadHost_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.prevAliveHostProvider = GotoMenuActions$PrevAliveHost_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.prevHostWithInfoProvider = GotoMenuActions$PrevHostWithInfo_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.prevDeadHostProvider = GotoMenuActions$PrevDeadHost_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.findProvider = GotoMenuActions$Find_Factory.create(statusBarProvider, resultTableProvider);
    this.gotoMenuProvider = ScopedProvider.create(GotoMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, nextAliveHostProvider, nextHostWithInfoProvider, nextDeadHostProvider, prevAliveHostProvider, prevHostWithInfoProvider, prevDeadHostProvider, findProvider));
    this.commandsMenuProvider = ScopedProvider.create(CommandsMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, commandsMenuActionsProvider, openersMenuProvider));
    this.favoritesConfigProvider = ScopedProvider.create(FavoritesConfig_Factory.create((MembersInjector) MembersInjectors.noOp(), getPreferencesProvider));
    this.addProvider = FavoritesMenuActions$Add_Factory.create(favoritesConfigProvider, feederGUIRegistryProvider);
    this.editProvider = FavoritesMenuActions$Edit_Factory.create(favoritesConfigProvider);
    this.selectProvider = FavoritesMenuActions$Select_Factory.create(favoritesConfigProvider, feederGUIRegistryProvider, startStopScanningActionProvider);
    this.showMenuProvider = FavoritesMenuActions$ShowMenu_Factory.create(favoritesConfigProvider, selectProvider, stateMachineProvider);
    this.favoritesMenuProvider = ScopedProvider.create(FavoritesMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, addProvider, editProvider, showMenuProvider));
    this.statisticsDialogProvider = StatisticsDialog_Factory.create((MembersInjector) MembersInjectors.noOp(), scanningResultListProvider);
    this.feederRegistryProvider = ScopedProvider.create(ComponentRegistry_FeederRegistryFactory.create(builder.componentRegistry, feederGUIRegistryProvider));
    this.commandLineProcessorProvider = CommandLineProcessor_Factory.create(feederRegistryProvider, exporterRegistryProvider, stateMachineProvider, scanningResultListProvider);
    this.scanStatisticsProvider = ToolsActions$ScanStatistics_Factory.create(forGUIProvider, statisticsDialogProvider, stateMachineProvider, commandLineProcessorProvider);
    this.selectAliveProvider = ToolsActions$SelectAlive_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.selectDeadProvider = ToolsActions$SelectDead_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.selectWithPortsProvider = ToolsActions$SelectWithPorts_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.selectWithoutPortsProvider = ToolsActions$SelectWithoutPorts_Factory.create((MembersInjector) MembersInjectors.noOp(), resultTableProvider);
    this.selectInvertProvider = ToolsActions$SelectInvert_Factory.create(resultTableProvider);
    this.toolsMenuProvider = ScopedProvider.create(ToolsMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, preferencesProvider, chooseFetchersProvider, scanStatisticsProvider, selectAliveProvider, selectDeadProvider, selectWithPortsProvider, selectWithoutPortsProvider, selectInvertProvider));
    this.commandLineUsageProvider = HelpMenuActions$CommandLineUsage_Factory.create(commandLineProcessorProvider);
    this.checkVersionProvider = HelpMenuActions$CheckVersion_Factory.create(statusBarProvider);
    this.aboutDialogProvider = AboutDialog_Factory.create((MembersInjector) MembersInjectors.noOp());
    this.aboutProvider = HelpMenuActions$About_Factory.create(aboutDialogProvider);
    this.helpMenuProvider = ScopedProvider.create(HelpMenu_Factory.create((MembersInjector) MembersInjectors.noOp(), mainShellProvider, HelpMenuActions$GettingStarted_Factory.create(), HelpMenuActions$Website_Factory.create(), HelpMenuActions$FAQ_Factory.create(), HelpMenuActions$Issues_Factory.create(), HelpMenuActions$Plugins_Factory.create(), commandLineUsageProvider, checkVersionProvider, aboutProvider));
    this.mainMenuProvider1 = ScopedProvider.create(MainMenu_Factory.create(mainShellProvider, mainMenuProvider, scanMenuProvider, gotoMenuProvider, commandsMenuProvider, favoritesMenuProvider, toolsMenuProvider, helpMenuProvider, resultsContextMenuProvider, stateMachineProvider));
    this.startupMembersInjector = Startup_MembersInjector.create(mainShellProvider, forGUIProvider, checkVersionProvider);
    this.startupProvider = Startup_Factory.create(startupMembersInjector);
    this.mainWindowProvider = MainWindow_Factory.create(mainShellProvider, forGUIProvider, feederAreaProvider, controlsAreaProvider, feederSelectionComboProvider, startStopButtonProvider, startStopScanningActionProvider, resultTableProvider, statusBarProvider, resultsContextMenuProvider, feederGUIRegistryProvider, stateMachineProvider, preferencesProvider, chooseFetchersProvider, mainMenuProvider1, startupProvider);
    this.macApplicationMenuMembersInjector = MacApplicationMenu_MembersInjector.create(aboutDialogProvider, preferencesDialogProvider, selectFetchersDialogProvider, checkVersionProvider);
    this.macApplicationMenuProvider = MacApplicationMenu_Factory.create(macApplicationMenuMembersInjector, getDisplayProvider);
  }

  @Override
  public MainWindow createMainWindow() {  
    return mainWindowProvider.get();
  }

  @Override
  public MacApplicationMenu createMacApplicationMenu() {  
    return macApplicationMenuProvider.get();
  }

  @Override
  public CommandLineProcessor createCommandLineProcessor() {  
    return commandLineProcessorProvider.get();
  }

  public static final class Builder {
    private ConfigModule configModule;
    private PluginLoader pluginLoader;
    private ComponentRegistry componentRegistry;
  
    private Builder() {  
    }
  
    public MainComponent build() {  
      if (configModule == null) {
        this.configModule = new ConfigModule();
      }
      if (pluginLoader == null) {
        this.pluginLoader = new PluginLoader();
      }
      if (componentRegistry == null) {
        this.componentRegistry = new ComponentRegistry();
      }
      return new DaggerMainComponent(this);
    }
  
    public Builder configModule(ConfigModule configModule) {  
      if (configModule == null) {
        throw new NullPointerException("configModule");
      }
      this.configModule = configModule;
      return this;
    }
  
    public Builder pluginLoader(PluginLoader pluginLoader) {  
      if (pluginLoader == null) {
        throw new NullPointerException("pluginLoader");
      }
      this.pluginLoader = pluginLoader;
      return this;
    }
  
    public Builder componentRegistry(ComponentRegistry componentRegistry) {  
      if (componentRegistry == null) {
        throw new NullPointerException("componentRegistry");
      }
      this.componentRegistry = componentRegistry;
      return this;
    }
  }
}

