/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.search.BasicSearch;
import net.sf.jabref.search.SearchExpression;

public class SearchManagerNoGUI {
    private String searchTerm;
    private BibtexDatabase database;
    private BibtexDatabase base = null;
    Hashtable searchOptions = new Hashtable();

    public SearchManagerNoGUI(String term, BibtexDatabase dataBase) {
        this.searchTerm = term;
        this.database = dataBase;
    }

    public BibtexDatabase getDBfromMatches() {
        int hits = 0;
        System.out.println("search term: " + this.searchTerm);
        if (this.specifiedYears()) {
            this.searchTerm = this.fieldYear();
        }
        this.searchOptions.put("option", this.searchTerm);
        SearchRuleSet searchRules = new SearchRuleSet();
        SearchRule rule1 = new BasicSearch(Globals.prefs.getBoolean("caseSensitiveSearch"), Globals.prefs.getBoolean("regExpSearch"));
        try {
            rule1 = new SearchExpression(Globals.prefs, this.searchOptions);
        }
        catch (Exception e) {
            // empty catch block
        }
        searchRules.addRule(rule1);
        if (!searchRules.validateSearchStrings(this.searchOptions)) {
            System.out.println(Globals.lang("Search failed: illegal search expression"));
            return this.base;
        }
        Collection<BibtexEntry> entries = this.database.getEntries();
        Vector<BibtexEntry> matchEntries = new Vector<BibtexEntry>();
        for (BibtexEntry entry : entries) {
            boolean hit = searchRules.applyRule(this.searchOptions, entry) > 0;
            entry.setSearchHit(hit);
            if (!hit) continue;
            ++hits;
            matchEntries.add(entry);
        }
        if (matchEntries != null) {
            this.base = ImportFormatReader.createDatabase(matchEntries);
        }
        return this.base;
    }

    private boolean specifiedYears() {
        return this.searchTerm.matches("year=[0-9]{4}-[0-9]{4}");
    }

    private String fieldYear() {
        String regPt1 = "";
        String regPt2 = "";
        String completeReg = null;
        boolean reg1Set = false;
        boolean reg2Set = false;
        String[] searchTermsToPr = this.searchTerm.split("=");
        String field = searchTermsToPr[0];
        String[] years = searchTermsToPr[1].split("-");
        int year1 = Integer.parseInt(years[0]);
        int year2 = Integer.parseInt(years[1]);
        if (year1 < 2000 && year2 >= 2000) {
            regPt1 = "199+[" + years[0].substring(3, 4) + "-9]";
            reg1Set = true;
        } else if (year1 < 2000) {
            regPt1 = "199+[" + years[0].substring(3, 4) + "-" + Math.min(Integer.parseInt(years[1].substring(3, 4)), 9) + "]";
            reg1Set = true;
        }
        if (Integer.parseInt(years[1]) >= 2000 && year1 < 2000) {
            regPt2 = "200+[0-" + years[1].substring(3, 4) + "]";
            reg2Set = true;
        } else if (year2 >= 2000) {
            regPt2 = "200+[" + years[0].substring(3, 4) + "-" + Math.min(Integer.parseInt(years[1].substring(3, 4)), 9) + "]";
            reg2Set = true;
        }
        if (reg1Set && reg2Set) {
            completeReg = field + "=" + regPt1 + "|" + regPt2;
        } else {
            if (reg1Set) {
                completeReg = field + "=" + regPt1;
            }
            if (reg2Set) {
                completeReg = field + "=" + regPt2;
            }
        }
        return completeReg;
    }
}

