/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class HTMLChars
implements LayoutFormatter {
    @Override
    public String format(String field) {
        field = field.replaceAll("&|\\\\&", "&amp;").replaceAll("[\\n]{2,}", "<p>").replaceAll("\\n", "<br>");
        StringBuffer sb = new StringBuffer();
        StringBuffer currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String result;
            IntAndString part;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = Globals.HTMLCHARS.get(command);
                    if (result2 != null) {
                        sb.append(result2);
                    } else {
                        sb.append(command);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuffer();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || Globals.SPECIAL_COMMAND_CHARS.indexOf(String.valueOf(c)) >= 0) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && Globals.SPECIAL_COMMAND_CHARS.indexOf(currentCommand.toString()) >= 0) {
                    String combody;
                    if (i >= field.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        part = this.getPart(field, i, false);
                        i += part.i;
                        combody = part.s;
                    } else {
                        combody = field.substring(i, i + 1);
                    }
                    result = Globals.HTMLCHARS.get(command + combody);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = Globals.HTMLCHARS.get(command);
                if (result2 != null) {
                    sb.append(result2);
                    continue;
                }
                sb.append(command);
                continue;
            }
            String argument = null;
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                String command2 = currentCommand.toString();
                if (command2.equals("em") || command2.equals("emph") || command2.equals("textit")) {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    sb.append("<em>").append(part.s).append("</em>");
                } else if (command2.equals("textbf")) {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    sb.append("<b>").append(part.s).append("</b>");
                } else if (c == '{') {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    argument = part.s;
                    if (argument != null) {
                        String result3 = Globals.HTMLCHARS.get(command2 + argument);
                        if (result3 != null) {
                            sb.append(result3);
                        } else {
                            sb.append(argument);
                        }
                    }
                } else if (c == '}') {
                    result = Globals.HTMLCHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                } else {
                    result = Globals.HTMLCHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString();
    }

    private IntAndString getPart(String text, int i, boolean terminateOnEndBraceOnly) {
        int count = 0;
        StringBuffer part = new StringBuffer();
        ++i;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!terminateOnEndBraceOnly && count == 0 && Character.isWhitespace(c)) {
                --i;
                break;
            }
            if (c == '}' && --count < 0) break;
            if (c == '{') {
                ++count;
            }
            part.append(c);
            ++i;
        }
        return new IntAndString(part.length(), this.format(part.toString()));
    }

    private class IntAndString {
        public int i;
        String s;

        public IntAndString(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

