/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.IconSelection;
import net.sf.jabref.gui.FileDialogs;

public class ExternalFileTypeEntryEditor {
    JFrame fParent = null;
    JDialog dParent = null;
    JDialog diag;
    JTextField extension = new JTextField();
    JTextField name = new JTextField();
    JTextField mimeType = new JTextField();
    JTextField application = new JTextField();
    String selectedIcon = null;
    JButton icon = new JButton(GUIGlobals.getImage("picture"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JRadioButton useDefault = new JRadioButton(Globals.lang("Default"));
    JRadioButton other = new JRadioButton("");
    final String emptyMessage = "<" + Globals.lang("Use default viewer") + ">";
    boolean applicationFieldEmpty = false;
    private ExternalFileType entry;
    private boolean okPressed = false;

    public ExternalFileTypeEntryEditor(JFrame parent, ExternalFileType entry) {
        this.fParent = parent;
        this.init(entry);
    }

    public ExternalFileTypeEntryEditor(JDialog parent, ExternalFileType entry) {
        this.dParent = parent;
        this.init(entry);
    }

    private void init(ExternalFileType entry) {
        this.entry = entry;
        this.icon.setText(null);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useDefault);
        bg.add(this.other);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", ""));
        builder.append(Globals.lang("Icon"));
        builder.append(this.icon);
        builder.nextLine();
        builder.append(Globals.lang("Name"));
        builder.append(this.name);
        builder.nextLine();
        builder.append(Globals.lang("Extension"));
        builder.append(this.extension);
        builder.nextLine();
        builder.append(Globals.lang("MIME type"));
        builder.append(this.mimeType);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.nextLine();
        builder.append(Globals.lang("Application"));
        JButton browseBut = new JButton(Globals.lang("Browse"));
        if (Globals.ON_WIN) {
            builder.append(this.useDefault);
            builder.nextLine();
            JPanel p1 = new JPanel();
            builder.append(p1);
            JPanel p2 = new JPanel();
            this.application.setPreferredSize(new Dimension(300, this.application.getPreferredSize().height));
            BorderLayout bl = new BorderLayout();
            bl.setHgap(4);
            p2.setLayout(bl);
            p2.add((Component)this.other, "West");
            p2.add((Component)this.application, "Center");
            builder.append(p2);
            builder.append(browseBut);
        } else {
            builder.append(this.application);
            builder.append(browseBut);
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFileTypeEntryEditor.this.okPressed = true;
                ExternalFileTypeEntryEditor.this.storeSettings(ExternalFileTypeEntryEditor.this.entry);
                ExternalFileTypeEntryEditor.this.diag.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFileTypeEntryEditor.this.diag.dispose();
            }
        });
        this.icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String initSel = ExternalFileTypeEntryEditor.this.entry.getIconName();
                if (ExternalFileTypeEntryEditor.this.selectedIcon != null) {
                    initSel = ExternalFileTypeEntryEditor.this.selectedIcon;
                }
                IconSelection ic = new IconSelection(ExternalFileTypeEntryEditor.this.diag, initSel);
                ic.setVisible(true);
                if (ic.isOkPressed()) {
                    ExternalFileTypeEntryEditor.this.selectedIcon = ic.getSelectedIconKey();
                    ExternalFileTypeEntryEditor.this.icon.setIcon(GUIGlobals.getImage(ExternalFileTypeEntryEditor.this.selectedIcon));
                }
            }
        });
        if (Globals.ON_WIN) {
            this.application.getDocument().addDocumentListener(new DocumentListener(){

                private void handle(DocumentEvent e) {
                    if (ExternalFileTypeEntryEditor.this.application.getText().length() == 0) {
                        ExternalFileTypeEntryEditor.this.useDefault.setSelected(true);
                    } else {
                        ExternalFileTypeEntryEditor.this.other.setSelected(true);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handle(e);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.handle(documentEvent);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.handle(documentEvent);
                }
            });
        }
        this.diag = this.dParent != null ? new JDialog(this.dParent, Globals.lang("Edit file type"), true) : new JDialog(this.fParent, Globals.lang("Edit file type"), true);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        BrowseListener browse = new BrowseListener(this.diag, this.application);
        browseBut.addActionListener(browse);
        if (this.dParent != null) {
            this.diag.setLocationRelativeTo(this.dParent);
        } else {
            this.diag.setLocationRelativeTo(this.fParent);
        }
        this.setValues(entry);
    }

    public void setEntry(ExternalFileType entry) {
        this.entry = entry;
        this.setValues(entry);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.okPressed = false;
        }
        this.diag.setVisible(visible);
    }

    public void setValues(ExternalFileType entry) {
        this.name.setText(entry.getName());
        this.extension.setText(entry.getExtension());
        this.mimeType.setText(entry.getMimeType());
        this.application.setText(entry.getOpenWith());
        this.icon.setIcon(entry.getIcon());
        if (this.application.getText().length() == 0) {
            this.useDefault.setSelected(true);
        } else {
            this.other.setSelected(true);
        }
        this.selectedIcon = null;
    }

    public void storeSettings(ExternalFileType entry) {
        entry.setName(this.name.getText().trim());
        entry.setMimeType(this.mimeType.getText().trim());
        String ext = this.extension.getText().trim();
        if (ext.length() > 0 && ext.charAt(0) == '.') {
            entry.setExtension(ext.substring(1));
        } else {
            entry.setExtension(ext);
        }
        if (this.selectedIcon != null) {
            entry.setIconName(this.selectedIcon);
        }
        if (!Globals.ON_WIN) {
            entry.setOpenWith(this.application.getText().trim());
        } else if (this.useDefault.isSelected() || this.application.getText().trim().length() == 0) {
            entry.setOpenWith("");
        } else {
            entry.setOpenWith(this.application.getText().trim());
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    class BrowseListener
    implements ActionListener {
        private JTextField comp;

        public BrowseListener(JDialog parent, JTextField comp) {
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String chosen;
            File initial = new File(this.comp.getText().trim());
            if (this.comp.getText().trim().length() == 0) {
                initial = new File(Globals.prefs.get("fileWorkingDirectory"));
            }
            if ((chosen = FileDialogs.getNewFile(null, initial, "_non__", 0, false)) != null) {
                File newFile = new File(chosen);
                Globals.prefs.put("fileWorkingDirectory", newFile.getParent());
                this.comp.setText(newFile.getPath());
                this.comp.requestFocus();
            }
        }
    }
}

