/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.IOException;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.external.DownloadExternalFile;
import net.sf.jabref.external.FindFullText;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.UndoableFieldChange;

public class FindFullTextAction
extends AbstractWorker {
    private BasePanel basePanel;
    private BibtexEntry entry = null;
    private FindFullText.FindResult result = null;

    public FindFullTextAction(BasePanel basePanel) {
        this.basePanel = basePanel;
    }

    @Override
    public void init() throws Throwable {
        this.basePanel.output(Globals.lang("Looking for full text document..."));
    }

    @Override
    public void run() {
        this.entry = this.basePanel.getSelectedEntries()[0];
        FindFullText fft = new FindFullText();
        this.result = fft.findFullText(this.entry);
    }

    @Override
    public void update() {
        if (this.result.url != null) {
            String bibtexKey = this.entry.getCiteKey();
            String[] dirs = this.basePanel.metaData().getFileDirectory("file");
            if (dirs.length == 0) {
                return;
            }
            DownloadExternalFile def = new DownloadExternalFile(this.basePanel.frame(), this.basePanel.metaData(), bibtexKey);
            try {
                def.download(this.result.url, new DownloadExternalFile.DownloadCallback(){

                    @Override
                    public void downloadComplete(FileListEntry file) {
                        System.out.println("finished");
                        FileListTableModel tm = new FileListTableModel();
                        String oldValue = FindFullTextAction.this.entry.getField("file");
                        tm.setContent(oldValue);
                        tm.addEntry(tm.getRowCount(), file);
                        String newValue = tm.getStringRepresentation();
                        UndoableFieldChange edit = new UndoableFieldChange(FindFullTextAction.this.entry, "file", oldValue, newValue);
                        FindFullTextAction.this.entry.setField("file", newValue);
                        ((FindFullTextAction)FindFullTextAction.this).basePanel.undoManager.addEdit(edit);
                        FindFullTextAction.this.basePanel.markBaseChanged();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.basePanel.output(Globals.lang("Finished downloading full text document"));
        } else {
            String message = null;
            switch (this.result.status) {
                case 2: {
                    message = Globals.lang("Unable to find full text article. No search algorithm defined for the '%0' web site.", this.result.host);
                    break;
                }
                case 1: {
                    message = Globals.lang("Found pdf link, but received the wrong MIME type. This could indicate that you don't have access to the fulltext article.");
                    break;
                }
                case 3: {
                    message = Globals.lang("Unable to find full text document in the linked web page.");
                    break;
                }
                case 4: {
                    message = Globals.lang("Connection error when trying to find full text document.");
                    break;
                }
                case 5: {
                    message = Globals.lang("This entry provides no URL or DOI links.");
                }
            }
            this.basePanel.output(Globals.lang("Full text article download failed"));
            JOptionPane.showMessageDialog(this.basePanel.frame(), message, Globals.lang("Full text article download failed"), 0);
        }
    }
}

