/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Util;

public class RegExpFileSearch {
    static final String EXT_MARKER = "__EXTENSION__";

    public static void main(String[] args) {
        BibtexEntry entry = new BibtexEntry(Util.createNeutralId());
        entry.setField("bibtexkey", "raffel01");
        entry.setField("year", "2001");
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("pdf");
        extensions.add("ps");
        extensions.add("txt");
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(new File("/home/alver/Desktop/Tromso_2008"));
        System.out.println(RegExpFileSearch.findFiles(entry, extensions, dirs, "**/[bibtexkey].*\\\\.[extension]"));
    }

    public static Map<BibtexEntry, List<File>> findFilesForSet(Collection<BibtexEntry> entries, Collection<String> extensions, List<File> directories, String regExp) {
        HashMap<BibtexEntry, List<File>> res = new HashMap<BibtexEntry, List<File>>();
        for (BibtexEntry entry : entries) {
            res.put(entry, RegExpFileSearch.findFiles(entry, extensions, directories, regExp));
        }
        return res;
    }

    public static List<File> findFiles(BibtexEntry entry, Collection<String> extensions, Collection<File> directories, String regularExpression) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = extensions.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append("|");
        }
        String extensionRegExp = "(" + sb.toString() + ")";
        return RegExpFileSearch.findFile(entry, null, directories, regularExpression, extensionRegExp, true);
    }

    public static List<File> findFile(BibtexEntry entry, BibtexDatabase database, Collection<File> dirs, String file, String extensionRegExp, boolean relative) {
        ArrayList<File> res = new ArrayList<File>();
        for (File directory : dirs) {
            List<File> tmp = RegExpFileSearch.findFile(entry, database, directory.getPath(), file, extensionRegExp, relative);
            if (tmp == null) continue;
            res.addAll(tmp);
        }
        return res;
    }

    public static List<File> findFile(BibtexEntry entry, BibtexDatabase database, String directory, String file, String extensionRegExp, boolean relative) {
        File root = directory == null ? new File(".") : new File(directory);
        if (!root.exists()) {
            return null;
        }
        List<File> res = RegExpFileSearch.findFile(entry, database, root, file, extensionRegExp);
        if (res.size() > 0) {
            for (int i = 0; i < res.size(); ++i) {
                try {
                    String tmp = res.get(i).getCanonicalPath().substring(root.getCanonicalPath().length());
                    if (tmp.length() > 1 && tmp.charAt(0) == File.separatorChar) {
                        tmp = tmp.substring(1);
                    }
                    res.set(i, new File(tmp));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }

    protected static List<File> findFile(BibtexEntry entry, BibtexDatabase database, File directory, String file, String extensionRegExp) {
        ArrayList<File> res = new ArrayList<File>();
        if (file.startsWith("/")) {
            directory = new File(".");
            file = file.substring(1);
        }
        Matcher m = Pattern.compile("([^\\\\])\\\\([^\\\\])").matcher(file);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(s, m.group(1) + "/" + m.group(2));
        }
        m.appendTail(s);
        file = s.toString();
        String[] fileParts = file.split("/");
        if (fileParts.length == 0) {
            return res;
        }
        if (fileParts.length > 1) {
            for (int i = 0; i < fileParts.length - 1; ++i) {
                String restOfFileString;
                File[] subDirs;
                String dirToProcess = fileParts[i];
                if ((dirToProcess = Util.expandBrackets(dirToProcess, entry, database)).matches("^.:$")) {
                    directory = new File(dirToProcess + "/");
                    continue;
                }
                if (dirToProcess.equals(".")) continue;
                if (dirToProcess.equals("..")) {
                    directory = new File(directory.getParent());
                    continue;
                }
                if (dirToProcess.equals("*") && (subDirs = directory.listFiles()) != null) {
                    restOfFileString = Util.join(fileParts, "/", i + 1, fileParts.length);
                    for (int sub = 0; sub < subDirs.length; ++sub) {
                        if (!subDirs[sub].isDirectory()) continue;
                        res.addAll(RegExpFileSearch.findFile(entry, database, subDirs[sub], restOfFileString, extensionRegExp));
                    }
                }
                if (!dirToProcess.equals("**")) continue;
                LinkedList<File> toDo = new LinkedList<File>();
                toDo.add(directory);
                restOfFileString = Util.join(fileParts, "/", i + 1, fileParts.length);
                while (!toDo.isEmpty()) {
                    File[] subDirs2 = ((File)toDo.remove(0)).listFiles();
                    if (subDirs2 == null) continue;
                    toDo.addAll(Arrays.asList(subDirs2));
                    for (int sub = 0; sub < subDirs2.length; ++sub) {
                        if (!subDirs2[sub].isDirectory()) continue;
                        res.addAll(RegExpFileSearch.findFile(entry, database, subDirs2[sub], restOfFileString, extensionRegExp));
                    }
                }
            }
        }
        String filePart = fileParts[fileParts.length - 1].replaceAll("\\[extension\\]", EXT_MARKER);
        String filenameToLookFor = Util.expandBrackets(filePart, entry, database).replaceAll(EXT_MARKER, extensionRegExp);
        final Pattern toMatch = Pattern.compile("^" + filenameToLookFor.replaceAll("\\\\\\\\", "\\\\") + "$", 2);
        File[] matches = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return toMatch.matcher(arg1).matches();
            }
        });
        if (matches != null && matches.length > 0) {
            for (int i = 0; i < matches.length; ++i) {
                File match = matches[i];
                res.add(match);
            }
        }
        return res;
    }
}

