/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import net.sf.jabref.Globals;

public class ColorSetupPanel
extends JPanel {
    private static final int ICON_WIDTH = 30;
    private static final int ICON_HEIGHT = 20;
    private ArrayList<ColorButton> buttons = new ArrayList();

    public ColorSetupPanel() {
        FormLayout layout = new FormLayout("30dlu, 4dlu, fill:pref, 4dlu, fill:pref, 8dlu, 30dlu, 4dlu, fill:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.buttons.add(new ColorButton("tableText", Globals.lang("Table text color")));
        this.buttons.add(new ColorButton("markedEntryBackground0", Globals.lang("Marking color %0", "1")));
        this.buttons.add(new ColorButton("tableBackground", Globals.lang("Table background color")));
        this.buttons.add(new ColorButton("markedEntryBackground1", Globals.lang("Marking color %0", "2")));
        this.buttons.add(new ColorButton("tableReqFieldBackground", Globals.lang("Background color for required fields")));
        this.buttons.add(new ColorButton("markedEntryBackground2", Globals.lang("Marking color %0", "3")));
        this.buttons.add(new ColorButton("tableOptFieldBackground", Globals.lang("Background color for optional fields")));
        this.buttons.add(new ColorButton("markedEntryBackground3", Globals.lang("Marking color %0", "4")));
        this.buttons.add(new ColorButton("incompleteEntryBackground", Globals.lang("Color for marking incomplete entries")));
        this.buttons.add(new ColorButton("markedEntryBackground4", Globals.lang("Marking color %0", "5")));
        this.buttons.add(new ColorButton("gridColor", Globals.lang("Table grid color")));
        this.buttons.add(new ColorButton("markedEntryBackground5", Globals.lang("Import marking color")));
        this.buttons.add(new ColorButton("fieldEditorTextColor", Globals.lang("Entry editor font color")));
        this.buttons.add(new ColorButton("validFieldBackgroundColor", Globals.lang("Entry editor background color")));
        this.buttons.add(new ColorButton("activeFieldEditorBackgroundColor", Globals.lang("Entry editor active background color")));
        this.buttons.add(new ColorButton("invalidFieldBackgroundColor", Globals.lang("Entry editor invalid field color")));
        for (ColorButton but : this.buttons) {
            builder.append(but);
            builder.append(but.getDefaultButton());
            builder.append(but.getName());
            but.addActionListener(new ColorButtonListener(but));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
        this.setValues();
    }

    public void setValues() {
        for (ColorButton but : this.buttons) {
            but.setColor(Globals.prefs.getColor(but.getKey()));
        }
    }

    public void storeSettings() {
        for (ColorButton but : this.buttons) {
            Globals.prefs.putColor(but.getKey(), but.getColor());
        }
    }

    class ColorButton
    extends JButton
    implements Icon {
        private Color color = Color.white;
        private String key;
        private String name;

        public ColorButton(String key, String name) {
            this.setIcon(this);
            this.key = key;
            this.name = name;
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        public JButton getDefaultButton() {
            JButton toDefault = new JButton(Globals.lang("Default"));
            toDefault.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorButton.this.setColor(Globals.prefs.getDefaultColor(ColorButton.this.key));
                    ColorButton.this.repaint();
                }
            });
            return toDefault;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Rectangle r = g.getClipBounds();
            g.setColor(this.color);
            g.fillRect(r.x, r.y, r.width, r.height);
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }

    class ColorButtonListener
    implements ActionListener {
        private ColorButton button;

        public ColorButtonListener(ColorButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color chosen = JColorChooser.showDialog(null, this.button.getName(), this.button.getColor());
            if (chosen != null) {
                this.button.setColor(chosen);
            }
        }
    }
}

