/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;

public class FetcherPreviewDialog
extends JDialog
implements OutputPrinter {
    protected EventList<TableEntry> entries = new BasicEventList<TableEntry>();
    protected JTable glTable;
    protected JButton ok = new JButton(Globals.lang("Ok"));
    protected JButton cancel = new JButton(Globals.lang("Cancel"));
    protected JButton selectAll = new JButton(Globals.lang("Select all"));
    protected JButton deselectAll = new JButton(Globals.lang("Deselect all"));
    protected boolean okPressed = false;
    private JabRefFrame frame;
    private int warningLimit;

    public FetcherPreviewDialog(JabRefFrame frame, int warningLimit, int tableRowHeight) {
        super(frame, Globals.lang("Title"), true);
        this.frame = frame;
        this.warningLimit = warningLimit;
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FetcherPreviewDialog.this.verifySelection()) {
                    FetcherPreviewDialog.this.okPressed = true;
                    FetcherPreviewDialog.this.dispose();
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FetcherPreviewDialog.this.okPressed = false;
                FetcherPreviewDialog.this.dispose();
            }
        });
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FetcherPreviewDialog.this.setSelectionAll(true);
            }
        });
        this.deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FetcherPreviewDialog.this.setSelectionAll(false);
            }
        });
        EventTableModel<TableEntry> tableModelGl = new EventTableModel<TableEntry>(this.entries, new EntryTableFormat());
        this.glTable = new EntryTable(tableModelGl);
        this.glTable.setRowHeight(tableRowHeight);
        this.glTable.getColumnModel().getColumn(0).setMaxWidth(45);
        this.glTable.setPreferredScrollableViewportSize(new Dimension(1100, 600));
        EventSelectionModel<TableEntry> selectionModel = new EventSelectionModel<TableEntry>(this.entries);
        this.glTable.setSelectionModel(selectionModel);
        ButtonStackBuilder builder = new ButtonStackBuilder();
        builder.addButton((JComponent)this.selectAll);
        builder.addButton((JComponent)this.deselectAll);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel centerPan = new JPanel();
        centerPan.setLayout(new BorderLayout());
        centerPan.add((Component)new JScrollPane(this.glTable), "Center");
        centerPan.add((Component)builder.getPanel(), "West");
        this.getContentPane().add((Component)centerPan, "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FetcherPreviewDialog.this.dispose();
            }
        };
        ActionMap am = centerPan.getActionMap();
        InputMap im = centerPan.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
        this.pack();
    }

    public boolean verifySelection() {
        int selected = 0;
        for (TableEntry entry : this.entries) {
            if (!entry.isWanted()) continue;
            ++selected;
        }
        if (selected > this.warningLimit) {
            int result = JOptionPane.showConfirmDialog(this, Globals.lang("You have selected more than %0 entries for download. Some web sites might block you if you make too many rapid downloads. Do you want to continue?", String.valueOf(this.warningLimit)), Globals.lang("Confirm selection"), 0, 2);
            return result == 0;
        }
        return true;
    }

    public Map<String, Boolean> getSelection() {
        LinkedHashMap<String, Boolean> selection = new LinkedHashMap<String, Boolean>();
        for (TableEntry e : this.entries) {
            selection.put(e.id, e.isWanted());
        }
        return selection;
    }

    public void addEntry(String entryId, JLabel preview) {
        TableEntry entry = new TableEntry(entryId, preview);
        this.entries.getReadWriteLock().writeLock().lock();
        this.entries.add(entry);
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.repaint();
    }

    public void setSelectionAll(boolean select) {
        for (int i = 0; i < this.glTable.getRowCount(); ++i) {
            this.glTable.setValueAt(select, i, 0);
        }
        this.glTable.repaint();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void setStatus(String s) {
        this.frame.setStatus(s);
    }

    @Override
    public void showMessage(Object message, String title, int msgType) {
        JOptionPane.showMessageDialog(this, message, title, msgType);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    class EntryTableFormat
    implements TableFormat<TableEntry> {
        EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return Globals.lang("Keep");
            }
            return Globals.lang("Preview");
        }

        @Override
        public Object getColumnValue(TableEntry entry, int i) {
            if (i == 0) {
                return entry.isWanted() ? Boolean.TRUE : Boolean.FALSE;
            }
            return entry.getPreview();
        }
    }

    class EntryTable
    extends JTable {
        PreviewRenderer renderer;

        public EntryTable(TableModel model) {
            super(model);
            this.renderer = new PreviewRenderer();
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return JLabel.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().lock();
            TableEntry entry = (TableEntry)FetcherPreviewDialog.this.entries.get(row);
            entry.setWanted((Boolean)value);
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    class PreviewRenderer
    implements TableCellRenderer {
        JLabel label = new JLabel();

        PreviewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)value;
            this.label.setText(label.getText());
            return this.label;
        }
    }

    class TableEntry {
        private String id;
        private JLabel preview;
        private boolean wanted = false;

        public TableEntry(String id, JLabel preview) {
            this.id = id;
            this.preview = preview;
        }

        public boolean isWanted() {
            return this.wanted;
        }

        public void setWanted(boolean wanted) {
            this.wanted = wanted;
        }

        public JLabel getPreview() {
            return this.preview;
        }
    }
}

