/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ConfirmCloseFileListEntryEditor;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;

public class FileListEntryEditor {
    JDialog diag;
    JTextField link = new JTextField();
    JTextField description = new JTextField();
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton open = new JButton(Globals.lang("Open"));
    JComboBox types;
    JProgressBar prog = new JProgressBar(0);
    JLabel downloadLabel = new JLabel(Globals.lang("Downloading..."));
    ConfirmCloseFileListEntryEditor externalConfirm = null;
    private AbstractAction okAction;
    private FileListEntry entry;
    private MetaData metaData;
    private boolean okPressed = false;
    private boolean okDisabledExternally = false;
    private boolean openBrowseWhenShown = false;
    private boolean dontOpenBrowseUntilDisposed = false;
    public static Pattern remoteLinkPattern = Pattern.compile("[a-z]+://.*");

    public FileListEntryEditor(JabRefFrame frame, FileListEntry entry, boolean showProgressBar, boolean showOpenButton, MetaData metaData) {
        this.entry = entry;
        this.metaData = metaData;
        this.okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FileListEntryEditor.this.ok.isEnabled()) {
                    return;
                }
                if (FileListEntryEditor.this.externalConfirm != null) {
                    FileListEntry testEntry = new FileListEntry("", "", null);
                    FileListEntryEditor.this.storeSettings(testEntry);
                    if (!FileListEntryEditor.this.externalConfirm.confirmClose(testEntry)) {
                        return;
                    }
                }
                FileListEntryEditor.this.diag.dispose();
                FileListEntryEditor.this.storeSettings(FileListEntryEditor.this.entry);
                FileListEntryEditor.this.okPressed = true;
            }
        };
        this.types = new JComboBox();
        this.types.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FileListEntryEditor.this.okDisabledExternally) {
                    FileListEntryEditor.this.ok.setEnabled(FileListEntryEditor.this.types.getSelectedItem() != null);
                }
            }
        });
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        builder.append(Globals.lang("Link"));
        builder.append(this.link);
        final BrowseListener browse = new BrowseListener(frame, this.link);
        final JButton browseBut = new JButton(Globals.lang("Browse"));
        browseBut.addActionListener(browse);
        builder.append(browseBut);
        if (showOpenButton) {
            builder.append(this.open);
        }
        builder.nextLine();
        builder.append(Globals.lang("Description"));
        builder.append((Component)this.description, 3);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.nextLine();
        builder.append(Globals.lang("File type"));
        builder.append((Component)this.types, 3);
        if (showProgressBar) {
            builder.nextLine();
            builder.append(this.downloadLabel);
            builder.append((Component)this.prog, 3);
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addRelatedGap();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        this.ok.addActionListener(this.okAction);
        this.link.addActionListener(this.okAction);
        this.description.addActionListener(this.okAction);
        this.open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileListEntryEditor.this.openFile();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileListEntryEditor.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        this.link.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }
        });
        this.diag = new JDialog(frame, Globals.lang("Edit file link"), true);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        Util.placeDialog(this.diag, frame);
        this.diag.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent event) {
                if (FileListEntryEditor.this.openBrowseWhenShown && !FileListEntryEditor.this.dontOpenBrowseUntilDisposed) {
                    FileListEntryEditor.this.dontOpenBrowseUntilDisposed = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            browse.actionPerformed(new ActionEvent(browseBut, 0, ""));
                        }
                    });
                }
            }

            @Override
            public void windowClosed(WindowEvent event) {
                FileListEntryEditor.this.dontOpenBrowseUntilDisposed = false;
            }
        });
        this.setValues(entry);
    }

    private void checkExtension() {
        if (this.types.getSelectedIndex() == -1 && this.link.getText().trim().length() > 0) {
            ExternalFileType type;
            if (remoteLinkPattern.matcher(this.link.getText()).matches() && (type = Globals.prefs.getExternalFileTypeByExt("html")) != null) {
                this.types.setSelectedItem(type);
                return;
            }
            String theLink = this.link.getText().trim();
            ExternalFileType type2 = Globals.prefs.getExternalFileTypeForName(theLink);
            if (type2 != null) {
                this.types.setSelectedItem(type2);
            }
        }
    }

    public void openFile() {
        ExternalFileType type = (ExternalFileType)this.types.getSelectedItem();
        if (type != null) {
            try {
                Util.openExternalFileAnyFormat(this.metaData, this.link.getText(), type);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setExternalConfirm(ConfirmCloseFileListEntryEditor eC) {
        this.externalConfirm = eC;
    }

    public void setOkEnabled(boolean enabled) {
        this.okDisabledExternally = !enabled;
        this.ok.setEnabled(enabled);
    }

    public JProgressBar getProgressBar() {
        return this.prog;
    }

    public JLabel getProgressBarLabel() {
        return this.downloadLabel;
    }

    public void setEntry(FileListEntry entry) {
        this.entry = entry;
        this.setValues(entry);
    }

    public void setVisible(boolean visible, boolean openBrowse) {
        boolean bl = this.openBrowseWhenShown = openBrowse && Globals.prefs.getBoolean("allowFileAutoOpenBrowse");
        if (visible) {
            this.okPressed = false;
        }
        this.diag.setVisible(visible);
    }

    public boolean isVisible() {
        return this.diag != null && this.diag.isVisible();
    }

    public void setValues(FileListEntry entry) {
        this.description.setText(entry.getDescription());
        this.link.setText(entry.getLink());
        this.types.setModel(new DefaultComboBoxModel<ExternalFileType>(Globals.prefs.getExternalFileTypeSelection()));
        this.types.setSelectedIndex(-1);
        if (entry.getType() != null && !(entry.getType() instanceof UnknownExternalFileType)) {
            this.types.setSelectedItem(entry.getType());
        } else if (entry.getLink() != null && entry.getLink().length() > 0) {
            this.checkExtension();
        }
    }

    public void storeSettings(FileListEntry entry) {
        entry.setDescription(this.description.getText().trim());
        try {
            String[] dirs = this.metaData.getFileDirectory("file");
            if (dirs.length == 0) {
                entry.setLink(this.link.getText().trim());
            } else {
                boolean found = false;
                for (int i = 0; i < dirs.length; ++i) {
                    String flPath;
                    String canPath = new File(dirs[i]).getCanonicalPath();
                    File fl = new File(this.link.getText().trim());
                    if (!fl.isAbsolute() || (flPath = fl.getCanonicalPath()).length() <= canPath.length() || !flPath.startsWith(canPath)) continue;
                    String relFileName = fl.getCanonicalPath().substring(canPath.length() + 1);
                    entry.setLink(relFileName);
                    found = true;
                    break;
                }
                if (!found) {
                    entry.setLink(this.link.getText().trim());
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            entry.setLink(this.link.getText().trim());
        }
        entry.setType((ExternalFileType)this.types.getSelectedItem());
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    class BrowseListener
    implements ActionListener {
        private JFrame parent;
        private JTextField comp;

        public BrowseListener(JFrame parent, JTextField comp) {
            this.parent = parent;
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String chosen;
            File initial = new File(this.comp.getText().trim());
            if (this.comp.getText().trim().length() == 0) {
                initial = new File(Globals.prefs.get("fileWorkingDirectory"));
            }
            if ((chosen = FileDialogs.getNewFile(this.parent, initial, "_non__", 0, false)) != null) {
                File newFile = new File(chosen);
                Globals.prefs.put("fileWorkingDirectory", newFile.getParent());
                ArrayList<File> dirs = new ArrayList<File>();
                String[] dirsS = FileListEntryEditor.this.metaData.getFileDirectory("file");
                for (int i = 0; i < dirsS.length; ++i) {
                    dirs.add(new File(dirsS[i]));
                }
                if (dirs.size() > 0) {
                    newFile = FileListEditor.relativizePath(newFile, dirs);
                }
                this.comp.setText(newFile.getPath());
                this.comp.requestFocus();
            }
        }
    }
}

