/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;

public class SysTray {
    private JabRefFrame frame;
    private TrayIcon icon;
    private PopupMenu popup = new PopupMenu();
    private MenuItem showWindow;
    private SystemTray tray = null;

    public SysTray(JabRefFrame frame) {
        this.frame = frame;
        final ActionListener showJabref = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SysTray.this.frame.showIfMinimizedToSysTray();
                    }
                });
            }
        };
        this.showWindow = new MenuItem(Globals.lang("Show"));
        this.showWindow.addActionListener(showJabref);
        this.popup.add(this.showWindow);
        ImageIcon imic = new ImageIcon(GUIGlobals.class.getResource("/images/JabRef-icon-48.png"));
        this.icon = new TrayIcon(imic.getImage(), "JabRef", this.popup);
        this.icon.setImageAutoSize(true);
        this.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                showJabref.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, ""));
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
            }
        });
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
        }
    }

    public void setTrayIconVisible(boolean visible) {
        if (this.tray == null) {
            return;
        }
        try {
            if (visible) {
                this.tray.add(this.icon);
            } else {
                this.tray.remove(this.icon);
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println(SystemTray.isSupported());
    }
}

