/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.help.HelpDialog;

public class HelpAction
extends MnemonicAwareAction {
    protected HelpDialog diag;
    protected Class resourceOwner = null;
    protected String helpFile;

    public HelpAction(HelpDialog diag, String helpFile) {
        super(GUIGlobals.getImage("help"));
        this.putValue("Name", "Help");
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public HelpAction(HelpDialog diag, String helpFile, String tooltip) {
        super(GUIGlobals.getImage("help"));
        this.putValue("Name", "Help");
        this.putValue("ShortDescription", Globals.lang(tooltip));
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public HelpAction(HelpDialog diag, String helpFile, String tooltip, URL iconFile) {
        super(new ImageIcon(iconFile));
        this.putValue("Name", "Help");
        this.putValue("ShortDescription", Globals.lang(tooltip));
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public HelpAction(String title, HelpDialog diag, String helpFile, String tooltip) {
        super(GUIGlobals.getImage("help"));
        this.putValue("Name", title);
        this.putValue("ShortDescription", Globals.lang(tooltip));
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public HelpAction(String title, HelpDialog diag, String helpFile, String tooltip, KeyStroke key) {
        super(GUIGlobals.getImage("help"));
        this.putValue("Name", title);
        this.putValue("ShortDescription", Globals.lang(tooltip));
        this.putValue("AcceleratorKey", key);
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public HelpAction(String title, HelpDialog diag, String helpFile, String tooltip, URL iconFile) {
        super(new ImageIcon(iconFile));
        this.putValue("Name", title);
        this.putValue("ShortDescription", Globals.lang(tooltip));
        this.diag = diag;
        this.helpFile = helpFile;
    }

    public void setResourceOwner(Class resourceOwner) {
        this.resourceOwner = resourceOwner;
    }

    public JButton getIconButton() {
        JButton hlp = new JButton(this);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        return hlp;
    }

    public void setHelpFile(String helpFile) {
        this.helpFile = helpFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.resourceOwner == null) {
            this.diag.showPage(this.helpFile);
        } else {
            this.diag.showPage(this.helpFile, this.resourceOwner);
        }
    }
}

