/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.net.URLDownload;

public class BibsonomyScraper {
    protected static final String BIBSONOMY_SCRAPER = "http://scraper.bibsonomy.org/service?url=";
    protected static final String BIBSONOMY_SCRAPER_POST = "&format=bibtex";

    public static BibtexEntry getEntry(String entryUrl) {
        try {
            entryUrl = entryUrl.replaceAll("%", "%25").replaceAll(":", "%3A").replaceAll("/", "%2F").replaceAll("\\?", "%3F").replaceAll("&", "%26").replaceAll("=", "%3D");
            URL url = new URL(BIBSONOMY_SCRAPER + entryUrl + BIBSONOMY_SCRAPER_POST);
            URLDownload ud = new URLDownload(url);
            ud.setEncoding("UTF8");
            ud.download();
            String bibtex = ud.getStringContent();
            BibtexParser bp = new BibtexParser(new StringReader(bibtex));
            ParserResult pr = bp.parse();
            if (pr != null && pr.getDatabase().getEntryCount() > 0) {
                return pr.getDatabase().getEntries().iterator().next();
            }
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

