/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.imports.EntryFromExternalFileCreator;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.imports.EntryFromPDFCreator;
import net.sf.jabref.undo.UndoableInsertEntry;

public final class EntryFromFileCreatorManager {
    private List<EntryFromFileCreator> entryCreators = new ArrayList<EntryFromFileCreator>(10);

    public EntryFromFileCreatorManager() {
        ExternalFileType[] fileTypes;
        this.entryCreators.add(new EntryFromPDFCreator());
        for (ExternalFileType exFileType : fileTypes = JabRefPreferences.getInstance().getExternalFileTypeSelection()) {
            if (this.hasSpecialisedCreatorForExternalFileType(exFileType)) continue;
            this.entryCreators.add(new EntryFromExternalFileCreator(exFileType));
        }
    }

    private boolean hasSpecialisedCreatorForExternalFileType(ExternalFileType externalFileType) {
        for (EntryFromFileCreator entryCreator : this.entryCreators) {
            if (entryCreator.getExternalFileType() == null || entryCreator.getExternalFileType().getExtension() == null || !entryCreator.getExternalFileType().getExtension().equals(externalFileType.getExtension())) continue;
            return true;
        }
        return false;
    }

    public EntryFromFileCreator getEntryCreator(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        for (EntryFromFileCreator creator : this.entryCreators) {
            if (!creator.accept(file)) continue;
            return creator;
        }
        return null;
    }

    public List<String> addEntrysFromFiles(List<File> files, BibtexDatabase database, BibtexEntryType entryType, boolean generateKeywordsFromPathToFile) {
        LinkedList<String> importGUIMessages = new LinkedList<String>();
        this.addEntrysFromFiles(files, database, null, entryType, generateKeywordsFromPathToFile, null, importGUIMessages);
        return importGUIMessages;
    }

    public int addEntrysFromFiles(List<File> files, BibtexDatabase database, BasePanel panel, BibtexEntryType entryType, boolean generateKeywordsFromPathToFile, ChangeListener changeListener, List<String> importGUIMessages) {
        int count = 0;
        CompoundEdit ce = new CompoundEdit();
        for (File f : files) {
            EntryFromFileCreator creator = this.getEntryCreator(f);
            if (creator != null) {
                BibtexEntry entry = creator.createEntry(f, generateKeywordsFromPathToFile);
                if (entry == null) {
                    importGUIMessages.add("Problem importing " + f.getPath() + ": Entry could not be created.");
                    continue;
                }
                if (entryType != null) {
                    entry.setType(entryType);
                }
                if (entry.getId() == null) {
                    entry.setId(Util.createNeutralId());
                }
                if (database.insertEntry(entry)) {
                    importGUIMessages.add("Problem importing " + f.getPath() + ": Insert into BibtexDatabase failed.");
                } else {
                    ++count;
                    if (panel != null) {
                        ce.addEdit(new UndoableInsertEntry(database, entry, panel));
                    }
                }
            } else {
                importGUIMessages.add("Problem importing " + f.getPath() + ": Unknown filetype.");
            }
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        System.out.println("count = " + count);
        if (count > 0 && panel != null) {
            System.out.println("adding edit");
            ce.end();
            panel.undoManager.addEdit(ce);
        }
        return count;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (EntryFromFileCreator creator : EntryFromFileCreatorManager.this.entryCreators) {
                    if (!creator.accept(file)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "All external files";
            }
        };
    }

    public List<FileFilter> getFileFilterList() {
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(this.getFileFilter());
        for (FileFilter fileFilter : this.entryCreators) {
            filters.add(fileFilter);
        }
        return filters;
    }
}

