/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.Vector;
import net.sf.jabref.AuthorList;
import net.sf.jabref.export.layout.WSITools;

public class PersonName {
    protected String givenName = null;
    protected String surname = null;
    protected String middleName = null;

    public PersonName() {
    }

    public PersonName(String name) {
        this.parseName(name);
    }

    public PersonName(String firstName, String _middleName, String lastName) {
        this.givenName = firstName;
        this.middleName = _middleName;
        this.surname = lastName;
    }

    protected void parseName(String author) {
        int amountOfNames;
        Vector<String> v = new Vector<String>();
        String authorMod = AuthorList.fixAuthor_lastNameFirst(author, false);
        int endOfLastName = authorMod.indexOf(",");
        WSITools.tokenize(v, authorMod.substring(endOfLastName + 1).trim(), " \n\r");
        if (endOfLastName >= 0) {
            v.add(authorMod.substring(0, endOfLastName));
        }
        if ((amountOfNames = v.size()) == 1) {
            this.surname = v.get(0);
        } else if (amountOfNames == 2) {
            this.givenName = v.get(0);
            this.surname = v.get(1);
        } else {
            this.givenName = v.get(0);
            this.middleName = "";
            for (int i = 1; i < amountOfNames - 1; ++i) {
                this.middleName = this.middleName + " " + v.get(i);
            }
            this.middleName = this.middleName.trim();
            this.surname = v.get(amountOfNames - 1);
        }
    }

    public String getGivenNames() {
        String result = "";
        if (this.givenName != null) {
            result = result + this.givenName;
        }
        if (this.middleName != null) {
            result = result + " " + this.middleName;
        }
        return result;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String lastName) {
        this.surname = lastName;
    }

    public String getFirstname() {
        return this.givenName;
    }

    public void setFirstname(String firstName) {
        this.givenName = firstName;
    }

    public String getMiddlename() {
        return this.middleName;
    }

    public void setMiddlename(String _middleName) {
        this.middleName = _middleName;
    }

    public String getFullname() {
        String fullName = "";
        if (this.givenName != null && this.givenName != "") {
            fullName = fullName + this.givenName + " ";
        }
        if (this.middleName != null && this.middleName != "") {
            fullName = fullName + this.middleName + " ";
        }
        if (this.surname != null && this.surname != "") {
            fullName = fullName + this.surname;
        }
        return fullName.trim();
    }

    public String toString() {
        return this.surname;
    }
}

