/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.util.LinkedList;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.ErrorDialog;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.util.ResourceManager;

public class BootErrorHandlerGui
implements BootErrorHandler {
    public void handleFatalError(String message) {
        ErrorDialog.showError(null, ResourceManager.getMessage("org.java.plugin.boot", "errorDialogueHeaderFatal"), message);
    }

    public void handleFatalError(String message, Throwable t) {
        ErrorDialog.showError(null, ResourceManager.getMessage("org.java.plugin.boot", "errorDialogueHeaderFatal"), message, t);
    }

    public boolean handleError(String message, Exception e) {
        return ErrorDialog.showWarning(null, ResourceManager.getMessage("org.java.plugin.boot", "errorDialogueHeaderNonFatal"), message, e);
    }

    public boolean handleError(String message, IntegrityCheckReport report) {
        LinkedList<String> items = new LinkedList<String>();
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            if (item.getSeverity() != IntegrityCheckReport.Severity.ERROR) continue;
            items.add(item.getMessage());
        }
        return ErrorDialog.showWarning(null, ResourceManager.getMessage("org.java.plugin.boot", "errorDialogueHeaderNonFatal"), message, items);
    }
}

