/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardPluginManager;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardObjectFactory
extends ObjectFactory {
    static final String PACKAGE_NAME = "org.java.plugin.standard";
    protected Log log = LogFactory.getLog(this.getClass());
    protected ExtendedProperties config;

    @Override
    protected void configure(ExtendedProperties configuration) {
        this.config = configuration != null ? configuration : new ExtendedProperties();
    }

    protected String getImplClassName(Class<?> cls) {
        String result = this.config.getProperty(cls.getName(), null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("implementation class for " + cls.getName() + " is " + result);
        }
        return result;
    }

    protected Object createClassInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return cl.loadClass(className).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        if ((cl = this.getClass().getClassLoader()) != null) {
            try {
                return cl.loadClass(className).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(className).newInstance();
    }

    @Override
    public PluginRegistry createRegistry() {
        PluginRegistry result;
        String className = this.getImplClassName(PluginRegistry.class);
        if (className == null) {
            className = "org.java.plugin.registry.xml.PluginRegistryImpl";
        }
        try {
            result = (PluginRegistry)this.createClassInstance(className);
        }
        catch (Exception e) {
            this.log.fatal("failed creating registry instance " + className, e);
            throw new Error("failed creating registry instance " + className, e);
        }
        result.configure(this.config.getSubset(className + "."));
        this.log.debug("registry instance created - " + result);
        return result;
    }

    @Override
    public PathResolver createPathResolver() {
        PathResolver result;
        String className = this.getImplClassName(PathResolver.class);
        if (className == null) {
            className = "org.java.plugin.standard.StandardPathResolver";
        }
        try {
            result = (PathResolver)this.createClassInstance(className);
        }
        catch (Exception e) {
            this.log.fatal("failed creating path resolver instance " + className, e);
            throw new Error("failed creating path resolver instance " + className, e);
        }
        try {
            result.configure(this.config.getSubset(className + "."));
        }
        catch (Exception e) {
            this.log.fatal("failed configuring path resolver instance " + result, e);
            throw new Error("failed configuring path resolver instance " + result, e);
        }
        this.log.debug("path resolver instance created - " + result);
        return result;
    }

    protected PluginLifecycleHandler createLifecycleHandler() {
        PluginLifecycleHandler result;
        String className = this.getImplClassName(PluginLifecycleHandler.class);
        if (className == null) {
            className = "org.java.plugin.standard.StandardPluginLifecycleHandler";
        }
        try {
            result = (PluginLifecycleHandler)this.createClassInstance(className);
        }
        catch (Exception e) {
            this.log.fatal("failed creating plug-in life cycle handler instance " + className, e);
            throw new Error("failed creating plug-in life cycle handler instance " + className, e);
        }
        result.configure(this.config.getSubset(className + "."));
        this.log.debug("life cycle handler instance created - " + result);
        return result;
    }

    @Override
    public PluginManager createManager(PluginRegistry registry, PathResolver pathResolver) {
        return new StandardPluginManager(registry, pathResolver, this.createLifecycleHandler());
    }
}

