/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameSeparator {
    public static String proofString;

    public NameComponents seperateName(String person) {
        NameComponents components = new NameComponents();
        proofString = "";
        String fullName = this.cleanName(person);
        fullName = this.saveLastNamePrefix(fullName, components);
        fullName = this.saveLastNameSuffix(fullName, components);
        this.sortNames(fullName, components);
        System.out.println(proofString);
        return components;
    }

    private void sortNames(String fullName, NameComponents components) {
        try {
            String notLastName = "";
            String lastName = "";
            Matcher matcher = Pattern.compile("(.+), (.+)").matcher(fullName);
            if (matcher.find()) {
                notLastName = matcher.group(2);
                lastName = matcher.group(1);
            } else {
                matcher = Pattern.compile("^(\\S{2,}) ((?:[a-z] )*[a-z])$").matcher(fullName);
                if (matcher.find()) {
                    notLastName = matcher.group(2);
                    lastName = matcher.group(1);
                } else {
                    matcher = Pattern.compile("^(.+?) (\\S+)$").matcher(fullName);
                    if (matcher.find()) {
                        notLastName = matcher.group(1);
                        lastName = matcher.group(2);
                    } else {
                        proofString = String.valueOf(proofString) + "Cannot split into first and last names";
                    }
                }
            }
            if (!notLastName.isEmpty()) {
                String[] nameParts = notLastName.split("[ -]+");
                List<String> names = Arrays.asList(nameParts);
                String middleNames = "";
                for (String name : names) {
                    if (names.indexOf(name) == 0) {
                        components.setFirstName(nameParts[0]);
                        proofString = String.valueOf(proofString) + "First Name: " + nameParts[0] + "   ";
                        continue;
                    }
                    middleNames = String.valueOf(middleNames) + name + " ";
                }
                if (!middleNames.isEmpty()) {
                    components.setMiddleName(middleNames.trim());
                    proofString = String.valueOf(proofString) + "Middle Name: " + middleNames + "   ";
                }
            }
            if (!lastName.isEmpty()) {
                components.setLastName(lastName.trim());
                proofString = String.valueOf(proofString) + "Last Name: " + lastName + "   ";
            }
        }
        catch (IllegalStateException e) {
            System.out.println("Matcher Exception");
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Matcher Exception");
        }
    }

    private String saveLastNameSuffix(String fullName, NameComponents components) {
        try {
            Matcher matcher = Pattern.compile("(?i)^(.*) (jr|iii|iv)$", 2).matcher(fullName);
            if (matcher.find()) {
                String nameLastSuffix = matcher.group(2);
                fullName = matcher.group(1);
                nameLastSuffix = nameLastSuffix.trim();
                components.setLastNameSuffix(nameLastSuffix);
                proofString = String.valueOf(proofString) + "Last Name Suffix: " + nameLastSuffix + "   ";
            }
        }
        catch (IllegalStateException e) {
            System.out.println("Matcher Exception");
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Matcher Exception");
        }
        return fullName;
    }

    private String saveLastNamePrefix(String fullName, NameComponents components) {
        block12: {
            try {
                Matcher matcher = Pattern.compile(" ((van|de|del|da|do|el|la|di|von|der|le|zu) )+", 2).matcher(fullName);
                if (matcher.find()) {
                    String lastNamePrefix = matcher.group();
                    fullName = matcher.replaceAll(" ");
                    lastNamePrefix = lastNamePrefix.trim();
                    components.setLastNamePrefix(lastNamePrefix);
                    proofString = String.valueOf(proofString) + "Last Name Prefix: " + lastNamePrefix + "   ";
                    break block12;
                }
                PrintWriter writer = null;
                try {
                    try {
                        File file = new File("possiblenameprefixes.txt");
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        writer = new PrintWriter(new FileOutputStream(file, true));
                        if (fullName.split(" ").length > 2) {
                            writer.println(String.valueOf(fullName) + "\n");
                        }
                    }
                    catch (IOException e1) {
                        System.out.println("Could not write prefix file.");
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                System.out.println("Matcher Exception");
            }
        }
        return fullName;
    }

    public String cleanName(String name) {
        String fullName = name;
        proofString = String.valueOf(proofString) + "Full Name: " + fullName + "   ";
        fullName = fullName.replaceAll("[{}_()\\'\"?~*!@#$\\%^&]", "");
        fullName = fullName.replaceFirst("\\s+", " ");
        fullName = fullName.replaceFirst(" -|- ", " ");
        fullName = fullName.replaceFirst("^([A-Z])([A-Z]) ", "$1. $2.");
        fullName = fullName.replaceFirst("^([A-Z][a-z]+)\\. ", "$1");
        fullName = fullName.replaceAll("\\. *", " ");
        fullName = fullName.replaceFirst("^ +| +$", "");
        fullName = fullName.replaceFirst("\\s+", " ");
        proofString = String.valueOf(proofString) + "Cleaned Name: " + fullName + "   ";
        return fullName;
    }

    public class NameComponents {
        private String firstName;
        private String middleName;
        private String lastName;
        private String lastNamePrefix;
        private String lastNameSuffix;

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getLastNamePrefix() {
            return this.lastNamePrefix;
        }

        public String getLastNameSuffix() {
            return this.lastNameSuffix;
        }

        protected void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        protected void setLastName(String lastName) {
            this.lastName = lastName;
        }

        protected void setLastNamePrefix(String lastNamePrefix) {
            this.lastNamePrefix = lastNamePrefix;
        }

        protected void setLastNameSuffix(String lastNameSuffix) {
            this.lastNameSuffix = lastNameSuffix;
        }

        protected void setFirstName(String firstName) {
            this.firstName = firstName;
        }
    }
}

