/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.imports.PdfContentImporter;
import net.sf.jabref.imports.PdfXmpImporter;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.util.XMPUtil;
import org.sciplore.beans.Document;
import spl.DocumentWrapper;
import spl.Tools;
import spl.filter.PdfFileFilter;
import spl.gui.ImportDialog;
import spl.gui.MetaDataListDialog;

public class PdfImporter {
    private JabRefFrame frame;
    private BasePanel panel;
    private MainTable entryTable;
    private int dropRow;

    public PdfImporter(JabRefFrame frame, BasePanel panel, MainTable entryTable, int dropRow) {
        this.frame = frame;
        this.panel = panel;
        this.entryTable = entryTable;
        this.dropRow = dropRow;
    }

    public String[] importPdfFiles(String[] fileNames, OutputPrinter status) {
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(fileNames));
        ArrayList<String> noPdfFiles = new ArrayList<String>();
        PdfFileFilter pdfFilter = new PdfFileFilter();
        for (String file : files) {
            if (pdfFilter.accept(file)) continue;
            noPdfFiles.add(file);
        }
        files.removeAll(noPdfFiles);
        this.importPdfFiles(files, status);
        String[] noPdfFilesArray = new String[noPdfFiles.size()];
        noPdfFiles.toArray(noPdfFilesArray);
        return noPdfFilesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importPdfFiles(List<String> fileNames, OutputPrinter status) {
        if (this.panel == null) {
            return false;
        }
        ImportDialog importDialog = null;
        boolean doNotShowAgain = false;
        boolean neverShow = Globals.prefs.getBoolean("importAlwaysUsePDFImportStyle");
        int globalChoice = Globals.prefs.getInt("importDefaultPDFimportStyle");
        ArrayList<File> dirs = new ArrayList<File>();
        String[] dirsS = this.panel.metaData().getFileDirectory("file");
        for (int i = 0; i < dirsS.length; ++i) {
            dirs.add(new File(dirsS[i]));
        }
        for (String fileName : fileNames) {
            block46: {
                List<BibtexEntry> xmpEntriesInFile = this.readXmpEntries(fileName);
                if (!neverShow && !doNotShowAgain) {
                    importDialog = new ImportDialog(this.dropRow, fileName);
                    if (!this.hasXmpEntries(xmpEntriesInFile)) {
                        importDialog.disableXMPChoice();
                    }
                    Tools.centerRelativeToWindow(importDialog, this.frame);
                    importDialog.showDialog();
                    doNotShowAgain = importDialog.getDoNotShowAgain();
                }
                if (!neverShow && importDialog.getResult() != 0) break block46;
                int choice = neverShow ? globalChoice : importDialog.getChoice();
                FileInputStream in = null;
                List<BibtexEntry> res = null;
                switch (choice) {
                    case 1: {
                        PdfXmpImporter importer = new PdfXmpImporter();
                        try {
                            in = new FileInputStream(fileName);
                            res = importer.importEntries(in, this.frame);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        finally {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Exception f) {}
                        }
                        if (res == null || res.size() == 0) {
                            this.createNewBlankEntry(fileName);
                            return true;
                        }
                        BibtexEntry entry = res.get(0);
                        this.panel.database().insertEntry(entry);
                        this.panel.markBaseChanged();
                        FileListTableModel tm = new FileListTableModel();
                        File toLink = new File(fileName);
                        tm.addEntry(0, new FileListEntry(toLink.getName(), FileListEditor.relativizePath(toLink, dirs).getPath(), Globals.prefs.getExternalFileTypeByName("pdf")));
                        entry.setField("file", tm.getStringRepresentation());
                        break;
                    }
                    case 2: {
                        PdfContentImporter contentImporter = new PdfContentImporter();
                        File file = new File(fileName);
                        try {
                            in = new FileInputStream(file);
                        }
                        catch (Exception e) {
                            Globals.logger(Globals.lang("Import failed"));
                            e.printStackTrace();
                            this.createNewBlankEntry(fileName);
                            return true;
                        }
                        try {
                            res = contentImporter.importEntries(in, status);
                        }
                        catch (Exception e) {
                            Globals.logger(Globals.lang("Import failed"));
                            e.printStackTrace();
                            this.createNewBlankEntry(fileName);
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Exception f) {}
                        }
                        if (res == null || res.size() == 0) {
                            this.createNewBlankEntry(fileName);
                            return true;
                        }
                        BibtexEntry entry = res.get(0);
                        this.panel.database().insertEntry(entry);
                        this.panel.markBaseChanged();
                        LabelPatternUtil.makeLabel(this.panel.metaData(), this.panel.database(), entry);
                        DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                        dfh.linkPdfToEntry(fileName, this.entryTable, entry);
                        this.panel.highlightEntry(entry);
                        if (!Globals.prefs.getBoolean("autoOpenForm")) break;
                        EntryEditor editor = this.panel.getEntryEditor(entry);
                        this.panel.showEntryEditor(editor);
                        this.panel.adjustSplitter();
                        break;
                    }
                    case 3: {
                        BibtexEntryType type;
                        int selected;
                        DroppedFileHandler dfh;
                        BibtexEntry entry;
                        MetaDataListDialog metaDataListDialog = new MetaDataListDialog(fileName, true);
                        Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                        metaDataListDialog.showDialog();
                        Document document = metaDataListDialog.getXmlDocuments();
                        if (document != null && metaDataListDialog.getResult() == 0) {
                            selected = metaDataListDialog.getTableMetadata().getSelectedRow();
                            if (selected > -1) {
                                String id = Util.createNeutralId();
                                entry = new BibtexEntry(id);
                                if (this.fieldExists(document.getType())) {
                                    type = BibtexEntryType.getStandardType(document.getType());
                                    if (type == null) {
                                        type = BibtexEntryType.ARTICLE;
                                    }
                                    entry.setType(type);
                                } else {
                                    entry.setType(BibtexEntryType.ARTICLE);
                                }
                                ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
                                list.add(entry);
                                Util.setAutomaticFields(list, true, true, false);
                                this.insertFields(BibtexFields.getAllFieldNames(), entry, document);
                                this.panel.database().insertEntry(entry);
                                dfh = new DroppedFileHandler(this.frame, this.panel);
                                dfh.linkPdfToEntry(fileName, this.entryTable, entry);
                                LabelPatternUtil.makeLabel(this.panel.metaData(), this.panel.database(), entry);
                                break;
                            }
                            this.createNewBlankEntry(fileName);
                            break;
                        }
                        if (metaDataListDialog.getResult() == 2) break;
                        if (metaDataListDialog.getResult() == 1) {
                            this.createNewBlankEntry(fileName);
                            break;
                        }
                        if (document != null || metaDataListDialog.getResult() != 0) break;
                        this.createNewBlankEntry(fileName);
                        break;
                    }
                    case 0: {
                        this.createNewBlankEntry(fileName);
                        break;
                    }
                    case 5: {
                        BibtexEntryType type;
                        int selected;
                        MetaDataListDialog metaDataListDialog = new MetaDataListDialog(fileName, false);
                        Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                        metaDataListDialog.showDialog();
                        Document document = metaDataListDialog.getXmlDocuments();
                        if (document == null || metaDataListDialog.getResult() != 0 || (selected = metaDataListDialog.getTableMetadata().getSelectedRow()) <= -1) break;
                        BibtexEntry entry = this.entryTable.getEntryAt(this.dropRow);
                        if (this.fieldExists(document.getType()) && (type = BibtexEntryType.getStandardType(document.getType())) != null) {
                            entry.setType(type);
                        }
                        this.insertFields(BibtexFields.getAllFieldNames(), entry, document);
                        DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                        dfh.linkPdfToEntry(fileName, this.entryTable, this.dropRow);
                        break;
                    }
                    case 4: {
                        DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                        dfh.linkPdfToEntry(fileName, this.entryTable, this.dropRow);
                    }
                }
            }
        }
        return true;
    }

    private void createNewBlankEntry(String fileName) {
        BibtexEntry newEntry = this.createNewEntry();
        if (newEntry != null) {
            DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
            dfh.linkPdfToEntry(fileName, this.entryTable, newEntry);
        }
    }

    private void insertFields(String[] fields, BibtexEntry entry, Document xmlDocument) {
        DocumentWrapper document = new DocumentWrapper(xmlDocument);
        for (String field : fields) {
            if (entry.getField(field) != null) continue;
            if (field.equalsIgnoreCase("author")) {
                entry.setField(field, document.getAuthors("and"));
            }
            if (field.equalsIgnoreCase("title")) {
                entry.setField(field, document.getTitle());
            }
            if (field.equalsIgnoreCase("abstract")) {
                entry.setField(field, document.getAbstract());
            }
            if (field.equalsIgnoreCase("doi")) {
                entry.setField(field, document.getDoi());
            }
            if (!field.equalsIgnoreCase("year")) continue;
            entry.setField(field, document.getYear());
        }
    }

    private boolean fieldExists(String string) {
        return string != null && !string.isEmpty();
    }

    private BibtexEntry createNewEntry() {
        EntryTypeDialog etd = new EntryTypeDialog(this.frame);
        Util.placeDialog(etd, this.frame);
        etd.setVisible(true);
        BibtexEntryType type = etd.getChoice();
        if (type != null) {
            String id = Util.createNeutralId();
            BibtexEntry be = new BibtexEntry(id, type);
            try {
                this.panel.database().insertEntry(be);
                ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
                list.add(be);
                Util.setAutomaticFields(list, true, true, false);
                this.panel.undoManager.addEdit(new UndoableInsertEntry(this.panel.database(), be, this.panel));
                this.panel.output(Globals.lang("Added new") + " '" + type.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                if (this.panel.getMode() != 2) {
                    this.panel.setMode(3);
                }
                this.panel.showEntry(be);
                this.panel.markBaseChanged();
                new FocusRequester(this.panel.getEntryEditor(be));
                return be;
            }
            catch (KeyCollisionException ex) {
                Util.pr(ex.getMessage());
            }
        }
        return null;
    }

    private List<BibtexEntry> readXmpEntries(String fileName) {
        List<BibtexEntry> xmpEntriesInFile = null;
        try {
            xmpEntriesInFile = XMPUtil.readXMP(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmpEntriesInFile;
    }

    private boolean hasXmpEntries(List<BibtexEntry> xmpEntriesInFile) {
        return xmpEntriesInFile != null && xmpEntriesInFile.size() != 0;
    }

    public MainTable getEntryTable() {
        return this.entryTable;
    }

    public void setEntryTable(MainTable entryTable) {
        this.entryTable = entryTable;
    }

    public int getDropRow() {
        return this.dropRow;
    }

    public void setDropRow(int dropRow) {
        this.dropRow = dropRow;
    }
}

