/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

@Experimental
class RuleMatchesAsJsonSerializer {
    private static final int API_VERSION = 1;
    private static final String STATUS = "";
    private static final String START_MARKER = "__languagetool_start_marker";
    private final JsonFactory factory = new JsonFactory();

    RuleMatchesAsJsonSerializer() {
    }

    public String ruleMatchesToJson(List<RuleMatch> matches, String text, int contextSize, Language lang, Language motherTongue) {
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        contextTools.setErrorMarkerStart(START_MARKER);
        contextTools.setErrorMarkerEnd(STATUS);
        StringWriter sw = new StringWriter();
        try (JsonGenerator g = this.factory.createGenerator((Writer)sw);){
            g.writeStartObject();
            this.writeSoftwareSection(g);
            this.writeLanguageSection(g, lang);
            this.writeMatchesSection(g, matches, text, contextTools);
            g.writeEndObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private void writeSoftwareSection(JsonGenerator g) throws IOException {
        g.writeObjectFieldStart("software");
        g.writeStringField("name", "LanguageTool");
        g.writeStringField("version", "3.4");
        g.writeStringField("buildDate", JLanguageTool.BUILD_DATE);
        g.writeStringField("apiVersion", String.valueOf(1));
        g.writeStringField("status", STATUS);
        g.writeEndObject();
    }

    private void writeLanguageSection(JsonGenerator g, Language lang) throws IOException {
        g.writeObjectFieldStart("language");
        g.writeStringField("name", lang.getName());
        g.writeStringField("code", lang.getShortNameWithCountryAndVariant());
        g.writeEndObject();
    }

    private void writeMatchesSection(JsonGenerator g, List<RuleMatch> matches, String text, ContextTools contextTools) throws IOException {
        g.writeArrayFieldStart("matches");
        for (RuleMatch match : matches) {
            g.writeStartObject();
            g.writeStringField("message", this.cleanSuggestion(match.getMessage()));
            if (match.getShortMessage() != null) {
                g.writeStringField("shortMessage", this.cleanSuggestion(match.getShortMessage()));
            }
            this.writeReplacements(g, match);
            g.writeNumberField("offset", match.getFromPos());
            g.writeNumberField("length", match.getToPos() - match.getFromPos());
            this.writeContext(g, match, text, contextTools);
            this.writeRule(g, match);
            g.writeEndObject();
        }
        g.writeEndArray();
    }

    private String cleanSuggestion(String s) throws IOException {
        return s.replace("<suggestion>", "\"").replace("</suggestion>", "\"");
    }

    private void writeReplacements(JsonGenerator g, RuleMatch match) throws IOException {
        g.writeArrayFieldStart("replacements");
        for (String replacement : match.getSuggestedReplacements()) {
            g.writeStartObject();
            g.writeStringField("value", replacement);
            g.writeEndObject();
        }
        g.writeEndArray();
    }

    private void writeContext(JsonGenerator g, RuleMatch match, String text, ContextTools contextTools) throws IOException {
        String context = contextTools.getContext(match.getFromPos(), match.getToPos(), text);
        int contextOffset = context.indexOf(START_MARKER);
        context = context.replaceFirst(START_MARKER, STATUS);
        g.writeObjectFieldStart("context");
        g.writeStringField("text", context);
        g.writeNumberField("offset", contextOffset);
        g.writeNumberField("length", match.getToPos() - match.getFromPos());
        g.writeEndObject();
    }

    private void writeRule(JsonGenerator g, RuleMatch match) throws IOException {
        AbstractPatternRule pRule;
        g.writeObjectFieldStart("rule");
        g.writeStringField("id", match.getRule().getId());
        if (match.getRule() instanceof AbstractPatternRule && (pRule = (AbstractPatternRule)match.getRule()).getSubId() != null) {
            g.writeStringField("subId", pRule.getSubId());
        }
        g.writeStringField("description", match.getRule().getDescription());
        g.writeStringField("issueType", match.getRule().getLocQualityIssueType().toString());
        if (match.getRule().getUrl() != null) {
            g.writeArrayFieldStart("urls");
            g.writeStartObject();
            g.writeStringField("value", match.getRule().getUrl().toString());
            g.writeEndObject();
            g.writeEndArray();
        }
        this.writeCategory(g, match.getRule().getCategory());
        g.writeEndObject();
    }

    private void writeCategory(JsonGenerator g, Category category) throws IOException {
        g.writeObjectFieldStart("category");
        CategoryId catId = category.getId();
        if (catId != null) {
            g.writeStringField("id", catId.toString());
            g.writeStringField("name", category.getName());
        }
        g.writeEndObject();
    }
}

