/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class exceptions
implements ClassDictInit {
    public static String __doc__ = "Python's standard exception class hierarchy.\n\nHere is a rundown of the class hierarchy.  The classes found here are\ninserted into both the exceptions module and the `built-in' module. It is\nrecommended that user defined class based exceptions be derived from the\n`Exception' class, although this is currently not enforced.\n\nException\n |\n +-- SystemExit\n +-- StopIteration\n +-- StandardError\n |    |\n |    +-- KeyboardInterrupt\n |    +-- ImportError\n |    +-- EnvironmentError\n |    |    |\n |    |    +-- IOError\n |    |    +-- OSError\n |    |         |\n |    |         +-- WindowsError\n |    |\n |    +-- EOFError\n |    +-- RuntimeError\n |    |    |\n |    |    +-- NotImplementedError\n |    |\n |    +-- NameError\n |    |    |\n |    |    +-- UnboundLocalError\n |    |\n |    +-- AttributeError\n |    +-- SyntaxError\n |    |    |\n |    |    +-- IndentationError\n |    |         |\n |    |         +-- TabError\n |    |\n |    +-- TypeError\n |    +-- AssertionError\n |    +-- LookupError\n |    |    |\n |    |    +-- IndexError\n |    |    +-- KeyError\n |    |\n |    +-- ArithmeticError\n |    |    |\n |    |    +-- OverflowError\n |    |    +-- ZeroDivisionError\n |    |    +-- FloatingPointError\n |    |\n |    +-- ValueError\n |    |    |\n |    |    +-- UnicodeError\n |    |\n |    +-- ReferenceError\n |    +-- SystemError\n |    +-- MemoryError\n |\n +---Warning\n      |\n      +-- UserWarning\n      +-- DeprecationWarning\n      +-- SyntaxWarning\n      +-- OverflowWarning\n      +-- RuntimeWarning";

    private exceptions() {
    }

    public static void classDictInit(PyObject pyObject) {
        pyObject.invoke("clear");
        pyObject.__setitem__("__name__", (PyObject)new PyString("exceptions"));
        pyObject.__setitem__("__doc__", (PyObject)new PyString(__doc__));
        ThreadState threadState = Py.getThreadState();
        if (threadState.systemState == null) {
            threadState.systemState = Py.defaultSystemState;
        }
        PyFrame pyFrame = new PyFrame(null, new PyStringMap());
        pyFrame.f_back = threadState.frame;
        if (pyFrame.f_builtins == null) {
            if (pyFrame.f_back != null) {
                pyFrame.f_builtins = pyFrame.f_back.f_builtins;
            } else {
                PySystemState cfr_ignored_0 = threadState.systemState;
                pyFrame.f_builtins = PySystemState.builtins;
            }
        }
        threadState.frame = pyFrame;
        exceptions.buildClass(pyObject, "Exception", null, "Exception", "Proposed base class for all exceptions.");
        exceptions.buildClass(pyObject, "StandardError", "Exception", "empty__init__", "Base class for all standard Python exceptions.");
        exceptions.buildClass(pyObject, "SyntaxError", "StandardError", "SyntaxError", "Invalid syntax");
        exceptions.buildClass(pyObject, "IndentationError", "SyntaxError", "empty__init__", "Improper indentation");
        exceptions.buildClass(pyObject, "TabError", "IndentationError", "empty__init__", "Improper mixture of spaces and tabs.");
        exceptions.buildClass(pyObject, "EnvironmentError", "StandardError", "EnvironmentError", "Base class for I/O related errors.");
        exceptions.buildClass(pyObject, "IOError", "EnvironmentError", "empty__init__", "I/O operation failed.");
        exceptions.buildClass(pyObject, "OSError", "EnvironmentError", "empty__init__", "OS system call failed.");
        exceptions.buildClass(pyObject, "RuntimeError", "StandardError", "empty__init__", "Unspecified run-time error.");
        exceptions.buildClass(pyObject, "NotImplementedError", "RuntimeError", "empty__init__", "Method or function hasn't been implemented yet.");
        exceptions.buildClass(pyObject, "SystemError", "StandardError", "empty__init__", "Internal error in the Python interpreter.\n\nPlease report this to the Python maintainer, along with the traceback,\nthe Python version, and the hardware/OS platform and version.");
        exceptions.buildClass(pyObject, "ReferenceError", "StandardError", "empty__init__", "Weak ref proxy used after referent went away.");
        exceptions.buildClass(pyObject, "EOFError", "StandardError", "empty__init__", "Read beyond end of file.");
        exceptions.buildClass(pyObject, "ImportError", "StandardError", "empty__init__", "Import can't find module, or can't find name in module.");
        exceptions.buildClass(pyObject, "TypeError", "StandardError", "empty__init__", "Inappropriate argument type.");
        exceptions.buildClass(pyObject, "ValueError", "StandardError", "empty__init__", "Inappropriate argument value (of correct type).");
        exceptions.buildClass(pyObject, "UnicodeError", "ValueError", "empty__init__", "Unicode related error.");
        exceptions.buildClass(pyObject, "KeyboardInterrupt", "StandardError", "empty__init__", "Program interrupted by user.");
        exceptions.buildClass(pyObject, "AssertionError", "StandardError", "empty__init__", "Assertion failed.");
        exceptions.buildClass(pyObject, "ArithmeticError", "StandardError", "empty__init__", "Base class for arithmetic errors.");
        exceptions.buildClass(pyObject, "OverflowError", "ArithmeticError", "empty__init__", "Result too large to be represented.");
        exceptions.buildClass(pyObject, "FloatingPointError", "ArithmeticError", "empty__init__", "Floating point operation failed.");
        exceptions.buildClass(pyObject, "ZeroDivisionError", "ArithmeticError", "empty__init__", "Second argument to a division or modulo operation was zero.");
        exceptions.buildClass(pyObject, "LookupError", "StandardError", "empty__init__", "Base class for lookup errors.");
        exceptions.buildClass(pyObject, "IndexError", "LookupError", "empty__init__", "Sequence index out of range.");
        exceptions.buildClass(pyObject, "KeyError", "LookupError", "empty__init__", "Mapping key not found.");
        exceptions.buildClass(pyObject, "AttributeError", "StandardError", "empty__init__", "Attribute not found.");
        exceptions.buildClass(pyObject, "NameError", "StandardError", "empty__init__", "Name not found globally.");
        exceptions.buildClass(pyObject, "UnboundLocalError", "NameError", "empty__init__", "Local name referenced but not bound to a value.");
        exceptions.buildClass(pyObject, "MemoryError", "StandardError", "empty__init__", "Out of memory.");
        exceptions.buildClass(pyObject, "SystemExit", "Exception", "SystemExit", "Request to exit from the interpreter.");
        exceptions.buildClass(pyObject, "StopIteration", "Exception", "empty__init__", "Signal the end from iterator.next().");
        exceptions.buildClass(pyObject, "Warning", "Exception", "empty__init__", "Base class for warning categories.");
        exceptions.buildClass(pyObject, "UserWarning", "Warning", "empty__init__", "Base class for warnings generated by user code.");
        exceptions.buildClass(pyObject, "DeprecationWarning", "Warning", "empty__init__", "Base class for warnings about deprecated features.");
        exceptions.buildClass(pyObject, "SyntaxWarning", "Warning", "empty__init__", "Base class for warnings about dubious syntax.");
        exceptions.buildClass(pyObject, "RuntimeWarning", "Warning", "empty__init__", "Base class for warnings about dubious runtime behavior.");
        exceptions.buildClass(pyObject, "OverflowWarning", "Warning", "empty__init__", "Base class for warnings about numeric overflow.");
        threadState.frame = threadState.frame.f_back;
    }

    public static PyObject empty__init__(PyObject[] pyObjectArray, String[] stringArray) {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__module__", (PyObject)new PyString("exceptions"));
        return pyStringMap;
    }

    public static PyObject Exception(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = exceptions.empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("__init__", exceptions.getJavaFunc("Exception__init__"));
        pyObject.__setitem__("__str__", exceptions.getJavaFunc("Exception__str__"));
        pyObject.__setitem__("__getitem__", exceptions.getJavaFunc("Exception__getitem__"));
        return pyObject;
    }

    public static void Exception__init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
    }

    public static PyString Exception__str__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__str__", pyObjectArray, stringArray, "self");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = pyObject.__getattr__("args");
        if (!pyObject2.__nonzero__()) {
            return new PyString("");
        }
        if (pyObject2.__len__() == 1) {
            return pyObject2.__getitem__(0).__str__();
        }
        return pyObject2.__str__();
    }

    public static PyObject Exception__getitem__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__getitem__", pyObjectArray, stringArray, "self", "i");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getPyObject(1);
        return pyObject.__getattr__("args").__getitem__(pyObject2);
    }

    public static PyObject SyntaxError(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = exceptions.empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("filename", Py.None);
        pyObject.__setitem__("lineno", Py.None);
        pyObject.__setitem__("offset", Py.None);
        pyObject.__setitem__("text", Py.None);
        pyObject.__setitem__("msg", (PyObject)new PyString(""));
        pyObject.__setitem__("__init__", exceptions.getJavaFunc("SyntaxError__init__"));
        pyObject.__setitem__("__str__", exceptions.getJavaFunc("SyntaxError__str__"));
        return pyObject;
    }

    public static void SyntaxError__init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
        if (pyObject2.__len__() >= 1) {
            pyObject.__setattr__("msg", pyObject2.__getitem__(0));
        }
        if (pyObject2.__len__() == 2) {
            PyObject pyObject3 = pyObject2.__getitem__(1);
            try {
                PyObject[] pyObjectArray2 = Py.unpackSequence(pyObject3, 4);
                pyObject.__setattr__("filename", pyObjectArray2[0]);
                pyObject.__setattr__("lineno", pyObjectArray2[1]);
                pyObject.__setattr__("offset", pyObjectArray2[2]);
                pyObject.__setattr__("text", pyObjectArray2[3]);
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
    }

    public static PyString SyntaxError__str__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyString pyString = pyObject.__getattr__("msg").__str__();
        PyObject pyObject2 = exceptions.basename(pyObject.__findattr__("filename"));
        PyObject pyObject3 = pyObject.__findattr__("lineno");
        if (pyObject2 instanceof PyString && pyObject3 instanceof PyInteger) {
            return new PyString(pyString + " (" + pyObject2 + ", line " + pyObject3 + ")");
        }
        if (pyObject2 instanceof PyString) {
            return new PyString(pyString + " (" + pyObject2 + ")");
        }
        if (pyObject3 instanceof PyInteger) {
            return new PyString(pyString + " (line " + pyObject3 + ")");
        }
        return pyString;
    }

    private static PyObject basename(PyObject pyObject) {
        int n;
        if (pyObject instanceof PyString && (n = ((PyString)pyObject).rfind(File.separator)) >= 0) {
            return pyObject.__getslice__(new PyInteger(n + 1), new PyInteger(Integer.MAX_VALUE));
        }
        return pyObject;
    }

    public static PyObject EnvironmentError(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = exceptions.empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("__init__", exceptions.getJavaFunc("EnvironmentError__init__"));
        pyObject.__setitem__("__str__", exceptions.getJavaFunc("EnvironmentError__str__"));
        return pyObject;
    }

    public static void EnvironmentError__init__(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject[] pyObjectArray2;
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
        pyObject.__setattr__("errno", Py.None);
        pyObject.__setattr__("strerror", Py.None);
        pyObject.__setattr__("filename", Py.None);
        if (pyObject2.__len__() == 3) {
            pyObjectArray2 = Py.unpackSequence(pyObject2, 3);
            pyObject.__setattr__("errno", pyObjectArray2[0]);
            pyObject.__setattr__("strerror", pyObjectArray2[1]);
            pyObject.__setattr__("filename", pyObjectArray2[2]);
            pyObject.__setattr__("args", pyObject2.__getslice__(Py.Zero, Py.newInteger(2), Py.One));
        }
        if (pyObject2.__len__() == 2) {
            pyObjectArray2 = Py.unpackSequence(pyObject2, 2);
            pyObject.__setattr__("errno", pyObjectArray2[0]);
            pyObject.__setattr__("strerror", pyObjectArray2[1]);
        }
    }

    public static PyString EnvironmentError__str__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self");
        PyObject pyObject = argParser.getPyObject(0);
        if (pyObject.__getattr__("filename") != Py.None) {
            return Py.newString("[Errno %s] %s: %s").__mod__(new PyTuple(new PyObject[]{pyObject.__getattr__("errno"), pyObject.__getattr__("strerror"), pyObject.__getattr__("filename")})).__str__();
        }
        if (pyObject.__getattr__("errno").__nonzero__() && pyObject.__getattr__("strerror").__nonzero__()) {
            return Py.newString("[Errno %s] %s").__mod__(new PyTuple(new PyObject[]{pyObject.__getattr__("errno"), pyObject.__getattr__("strerror")})).__str__();
        }
        return exceptions.Exception__str__(pyObjectArray, stringArray);
    }

    public static PyObject SystemExit(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject = exceptions.empty__init__(pyObjectArray, stringArray);
        pyObject.__setitem__("__init__", exceptions.getJavaFunc("SystemExit__init__"));
        return pyObject;
    }

    public static void SystemExit__init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, "self", "args");
        PyObject pyObject = argParser.getPyObject(0);
        PyObject pyObject2 = argParser.getList(1);
        pyObject.__setattr__("args", pyObject2);
        if (pyObject2.__len__() == 0) {
            pyObject.__setattr__("code", Py.None);
        } else if (pyObject2.__len__() == 1) {
            pyObject.__setattr__("code", pyObject2.__getitem__(0));
        } else {
            pyObject.__setattr__("code", pyObject2);
        }
    }

    private static PyObject getJavaFunc(String string2) {
        return Py.newJavaFunc(exceptions.class, string2);
    }

    private static PyObject buildClass(PyObject pyObject, String string2, String string3, String string4, String string5) {
        PyObject[] pyObjectArray = Py.EmptyObjects;
        if (string3 != null) {
            pyObjectArray = new PyObject[]{pyObject.__getitem__(new PyString(string3))};
        }
        PyObject pyObject2 = Py.makeClass(string2, pyObjectArray, Py.newJavaCode(exceptions.class, string4), new PyString(string5));
        pyObject.__setitem__(string2, pyObject2);
        return pyObject2;
    }
}

