/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.Axis;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.render.AbstractRenderer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.swing.event.EventListenerList;

public abstract class AbstractCoordSystem
extends AbstractRenderer
implements CoordSystem {
    protected EventListenerList listener = new EventListenerList();
    protected String xaxis_unit = "x";
    protected String yaxis_unit = "y";
    protected DecimalFormat dfY;
    protected DecimalFormat dfX;
    protected Font tickFont = new Font("sans", 0, 10);
    protected Font unitFont = new Font("sans", 0, 10);
    protected Axis xaxis;
    protected Axis yaxis;
    protected Axis yaxis2;
    protected int leftmargin = 75;
    protected int topmargin = 20;
    protected int rightmargin = 30;
    protected int bottommargin = 30;
    protected boolean shouldPaintOnlyTick = true;
    protected boolean shouldPaintLabels = true;
    protected boolean shouldPaintGrid = false;
    protected boolean shouldPaintAxes = true;
    Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected AffineTransform y1transform;
    protected AffineTransform y2transform;
    protected boolean centerObjectLabelsBetweenTicks = true;

    @Override
    public Font getFont() {
        return this.getTickFont();
    }

    @Override
    public Font getTickFont() {
        return this.tickFont;
    }

    @Override
    public Font getUnitFont() {
        return this.unitFont;
    }

    @Override
    public Axis getXAxis() {
        return this.xaxis;
    }

    @Override
    public String getXAxisUnit() {
        return this.xaxis_unit;
    }

    @Override
    public DecimalFormat getXDecimalFormat() {
        return this.dfX;
    }

    @Override
    public String getYAxisUnit() {
        return this.yaxis_unit;
    }

    @Override
    public DecimalFormat getYDecimalFormat() {
        return this.dfY;
    }

    @Override
    public abstract void paintDefault(Graphics2D var1);

    @Override
    public void render(Graphics2D g) {
        this.paintDefault(g);
    }

    @Override
    public void setFont(Font f) {
        this.setTickFont(f);
    }

    @Override
    public void setTickFont(Font f) {
        this.tickFont = f;
    }

    @Override
    public void setUnitFont(Font f) {
        this.unitFont = f;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        if (!this.isDifferentBounds(bounds)) {
            return;
        }
        this.bounds = bounds;
        this.setRightMargin(this.computeRightMargin());
        this.setLeftMargin(this.computeLeftMargin());
        this.setTopMargin(this.computeTopMargin());
        this.setBottomMargin(this.computeBottomMargin());
        this.xaxis.setLength((int)bounds.getWidth() - this.getLeftMargin() - this.getRightMargin());
        this.yaxis.setLength((int)bounds.getHeight() - this.getTopMargin() - this.getBottomMargin());
        if (this.yaxis2 != null) {
            this.yaxis2.setLength((int)bounds.getHeight() - this.getTopMargin() - this.getBottomMargin());
        }
        this.setTransforms();
        this.fireRenderChangeEvent();
    }

    protected void setTransforms() {
        this.setTransform(this.getDefaultTransform(0), 0);
        if (this.yaxis2 != null) {
            this.setTransform(this.getDefaultTransform(1), 1);
        }
    }

    @Override
    public boolean isPaintOnlyTick() {
        return this.shouldPaintOnlyTick;
    }

    @Override
    public boolean isPaintLabels() {
        return this.shouldPaintLabels;
    }

    @Override
    public boolean isPaintGrid() {
        return this.shouldPaintGrid;
    }

    @Override
    public void setPaintGrid(boolean value) {
        this.shouldPaintGrid = value;
        this.fireRenderChangeEvent();
    }

    @Override
    public boolean getPaintGrid() {
        return this.shouldPaintGrid;
    }

    @Override
    public void setPaintLabels(boolean label) {
        this.shouldPaintLabels = label;
        this.fireRenderChangeEvent();
    }

    @Override
    public boolean isPaintAxes() {
        return this.shouldPaintAxes;
    }

    @Override
    public void setPaintAxes(boolean axes) {
        this.shouldPaintAxes = axes;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setXAxis(Axis a) {
        this.xaxis = a;
    }

    @Override
    public void setFirstYAxis(Axis a) {
        this.yaxis = a;
    }

    @Override
    public Axis getFirstYAxis() {
        return this.yaxis;
    }

    @Override
    public void setSecondYAxis(Axis a) {
        this.yaxis2 = a;
    }

    @Override
    public Axis getSecondYAxis() {
        return this.yaxis2;
    }

    @Override
    public void setXAxisUnit(String xunit) {
        this.xaxis_unit = xunit;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setYAxisUnit(String yunit) {
        this.yaxis_unit = yunit;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setXDecimalFormat(DecimalFormat df) {
        this.dfX = df;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setYDecimalFormat(DecimalFormat df) {
        this.dfY = df;
        this.fireRenderChangeEvent();
    }

    @Override
    public void fireRenderChangeEvent() {
        RenderChangeEvent rce = new RenderChangeEvent(this);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == RenderChangeListener.class) {
                ((RenderChangeListener)ls[i + 1]).renderUpdateRequested(rce);
            }
            i -= 2;
        }
    }

    @Override
    public void removeRenderChangeListener(RenderChangeListener l) {
        this.listener.remove(RenderChangeListener.class, l);
    }

    @Override
    public void addRenderChangeListener(RenderChangeListener l) {
        Object[] ls = this.listener.getListenerList();
        boolean found = false;
        int i = ls.length - 1;
        while (i >= 1) {
            if (ls[i] == l) {
                found = true;
                break;
            }
            i -= 2;
        }
        if (!found) {
            this.listener.add(RenderChangeListener.class, l);
        }
    }

    @Override
    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    protected int getLeftMargin() {
        return this.leftmargin;
    }

    protected int getRightMargin() {
        return this.rightmargin;
    }

    protected int getTopMargin() {
        return this.topmargin;
    }

    protected int getBottomMargin() {
        return this.bottommargin;
    }

    protected void setLeftMargin(int margin) {
        this.leftmargin = margin;
    }

    protected void setRightMargin(int margin) {
        this.rightmargin = margin;
    }

    protected void setTopMargin(int margin) {
        this.topmargin = margin;
    }

    protected void setBottomMargin(int margin) {
        this.bottommargin = margin;
    }

    protected abstract int computeLeftMargin();

    protected abstract int computeRightMargin();

    protected abstract int computeTopMargin();

    protected abstract int computeBottomMargin();

    @Override
    public Rectangle getInnerBounds() {
        Rectangle b = this.getBounds();
        Rectangle i = new Rectangle((int)b.getX() + this.getLeftMargin() - 1, (int)b.getY() + this.getTopMargin() - 1, (int)b.getWidth() - (this.getLeftMargin() + this.getRightMargin()) + 2, (int)b.getHeight() - (this.getTopMargin() + this.getBottomMargin()) + 2);
        return i;
    }

    @Override
    public AffineTransform getDefaultTransform(int axis) {
        double x_pt2px = 0.0;
        double y_pt2px = 0.0;
        double xcoord0 = 0.0;
        double ycoord0 = 0.0;
        x_pt2px = 1.0 / this.getXAxis().getPointToPixelRatio();
        xcoord0 = this.getBounds().getX() + (double)this.getLeftMargin() + this.getXAxis().getPixelForValue(0.0);
        switch (axis) {
            case 0: {
                y_pt2px = 1.0 / this.getFirstYAxis().getPointToPixelRatio();
                ycoord0 = this.getBounds().getY() + this.getBounds().getHeight() - (double)this.getBottomMargin() - this.getFirstYAxis().getPixelForValue(0.0);
                break;
            }
            case 1: {
                y_pt2px = 1.0 / this.getSecondYAxis().getPointToPixelRatio();
                ycoord0 = this.getBounds().getY() + this.getBounds().getHeight() - (double)this.getBottomMargin() - this.getSecondYAxis().getPixelForValue(0.0);
            }
        }
        return new AffineTransform(x_pt2px, 0.0, 0.0, -y_pt2px, xcoord0, ycoord0);
    }

    @Override
    public AffineTransform getTransform(int axis) {
        switch (axis) {
            case 0: {
                return this.y1transform;
            }
            case 1: {
                return this.y2transform;
            }
        }
        return null;
    }

    @Override
    public void setTransform(AffineTransform at, int axis) {
        switch (axis) {
            case 0: {
                this.y1transform = at;
                break;
            }
            case 1: {
                this.y2transform = at;
            }
        }
        super.fireRenderChangeEvent();
    }

    @Override
    public boolean isCenterLabelsBetweenTicks() {
        return this.centerObjectLabelsBetweenTicks;
    }

    @Override
    public void setCenterLabelsBetweenTicks(boolean value) {
        this.centerObjectLabelsBetweenTicks = value;
    }
}

