/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.coordsystem;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.coordsystem.ClassicCoordSystem;
import com.approximatrix.charting.coordsystem.ticklocator.NumericTickLocator;
import com.approximatrix.charting.coordsystem.ticklocator.ObjectTickLocator;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class ClassicCoordSystemUtilities {
    private static final int MAX = 0;
    private static final int MIN = 1;
    private static final Color GRID_COLOR = Color.lightGray;
    private static final float[] DOT1 = new float[]{1.0f};
    private static final BasicStroke GRID_LINE_STYLE = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected final int marginOffset = 6;
    protected final int leftUnitBuffer = 10;
    protected ClassicCoordSystem c;
    protected ChartDataModelConstraints constraints;
    protected ChartDataModelConstraints constraints2;
    protected ChartDataModel model;
    private int estimated_x_ticks = 20;
    private int estimated_y_ticks = 20;
    private static final int DEFAULT_MAX_ACTUAL_TICKS = 40;
    private int maximum_x_ticks = 40;
    private int maximum_y_ticks = 40;
    private static final int SIMPLE_TICK_THRESHOLD = 4;
    private int tick_recursions = 0;
    private static final int STOP_TICK_RECURSIONS = 80;

    public ClassicCoordSystemUtilities(ClassicCoordSystem coord, ChartDataModelConstraints constraints, ChartDataModelConstraints constraints2, ChartDataModel model) {
        this.c = coord;
        this.constraints = constraints;
        this.constraints2 = constraints2;
        this.model = model;
    }

    public int computeLeftMargin() {
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (xm[1] < xm[0]) {
            int maxlmargin = this.computeYAxisLabelWidth() + 6 + 10;
            TextLayout layout = new TextLayout(this.c.getYAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
            maxlmargin = Math.max((int)layout.getBounds().getWidth() + 10, maxlmargin);
            int another_measure = (int)(xm[1] * (this.c.getBounds().getWidth() - (double)this.c.getRightMargin()) / (xm[0] - xm[1]));
            if (Math.abs(another_measure) > maxlmargin && xm[1] < 0.0) {
                maxlmargin = 6;
            }
            int margin = maxlmargin;
            if ((margin += 5) < this.c.MINIMALMARGIN) {
                margin = this.c.MINIMALMARGIN;
            }
            return margin;
        }
        return this.c.MINIMALMARGIN;
    }

    public int computeRightMargin() {
        TextLayout layout = new TextLayout(this.c.getXAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        return Math.max((int)(layout.getBounds().getWidth() + (double)this.c.ARROWLENGTH / 3.0), this.c.ARROWLENGTH) + 5;
    }

    public int computeTopMargin() {
        TextLayout layout = new TextLayout(this.c.getYAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        return Math.max((int)(layout.getBounds().getHeight() + (double)this.c.ARROWLENGTH / 3.0 + (double)layout.getDescent()), this.c.ARROWLENGTH);
    }

    public int computeBottomMargin() {
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (ym[1] < 0.0 && ym[0] > 0.0) {
            return this.c.MINIMALMARGIN;
        }
        ym[1] = Math.abs(ym[1]);
        ym[0] = Math.abs(ym[0]);
        TextLayout layout = new TextLayout(this.c.getXAxisUnit(), this.c.getUnitFont(), this.c.getFontRenderContext());
        int maxbmargin = this.computeXAxisLabelHeight() + 6;
        int margin = maxbmargin = Math.max(maxbmargin, (int)layout.getBounds().getHeight() + 6);
        if ((margin += 10) < this.c.MINIMALMARGIN) {
            margin = this.c.MINIMALMARGIN;
        }
        return margin;
    }

    public int computeXAxisLabelHeight() {
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double tick = ChartUtilities.calculateTickSpacing(xm[1], xm[0]);
        int height = 0;
        boolean paint = false;
        DecimalFormat df = this.c.getXDecimalFormat();
        FontRenderContext frc = this.c.getFontRenderContext();
        Font f = this.c.getTickFont();
        double d = xm[1];
        while (d <= xm[0]) {
            if (paint) {
                String sb = df.format(d);
                Rectangle2D r = f.getStringBounds(sb, frc);
                height = Math.max(height, (int)r.getHeight());
            }
            paint = !paint;
            d += tick;
        }
        return height;
    }

    public int computeYAxisLabelWidth() {
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double[] positions = new NumericTickLocator(ym[0], ym[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (positions == null) {
            return 0;
        }
        if (positions.length == 0) {
            return 0;
        }
        int width = 0;
        boolean paint = false;
        DecimalFormat df = this.c.getYDecimalFormat();
        FontRenderContext frc = this.c.getFontRenderContext();
        Font f = this.c.getTickFont();
        int i = 0;
        while (i < positions.length) {
            if (paint) {
                String sb = df.format(positions[i]);
                Rectangle2D r = f.getStringBounds(sb, frc);
                width = Math.max((int)Math.ceil(r.getWidth()), width);
            }
            paint = !paint;
            ++i;
        }
        return width;
    }

    public void drawNumericalXAxisTicks(Graphics2D g) {
        AffineTransform at = this.c.getTransform(0);
        double ypt = 0.0;
        double[] xm = new double[2];
        double[] ym = new double[2];
        try {
            xm = this.safeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        }
        catch (NullPointerException npe) {
            xm[0] = 0.0;
            xm[1] = 1.0;
        }
        try {
            ym = this.safeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        }
        catch (NullPointerException npe) {
            ym[0] = 0.0;
            ym[1] = 1.0;
        }
        if (ym[1] > 0.0) {
            ypt = ym[1];
        } else if (ym[0] < 0.0) {
            ypt = ym[0];
        }
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        Line2D.Double ticks = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        DecimalFormat df = this.c.getXDecimalFormat();
        FontRenderContext frc = this.c.getFontRenderContext();
        Font f = this.c.getTickFont();
        boolean paint = true;
        g.setFont(f);
        boolean paintLabels = this.c.isPaintLabels();
        double[] positions = new NumericTickLocator(xm[0], xm[1], this.estimated_x_ticks, this.maximum_x_ticks).getTickMarkLocations();
        if (positions == null) {
            return;
        }
        int i = 0;
        while (i < positions.length) {
            if (!(positions[i] < xm[1]) && !(positions[i] > xm[0])) {
                ((Point2D)p).setLocation(positions[i], ypt);
                Point2D v = at.transform(p, null);
                ((Line2D)ticks).setLine(v.getX(), v.getY() - 3.0, v.getX(), v.getY() + 3.0);
                g.draw(ticks);
                if (paint && paintLabels) {
                    String sb = df.format(positions[i]);
                    Rectangle2D r = f.getStringBounds(sb, frc);
                    g.drawString(sb, (float)(v.getX() - r.getWidth() / 2.0), (float)(v.getY() + r.getHeight() + 6.0));
                }
            }
            ++i;
        }
    }

    public void drawXAxisTicks(Graphics2D g) {
        AffineTransform at = this.c.getTransform(0);
        double[] xmd = this.safeMaxMin(this.constraints.getMaximumX().doubleValue(), this.constraints.getMinimumX().doubleValue());
        int[] xm = new int[2];
        xm[1] = (int)Math.floor(xmd[1]);
        xm[0] = (int)Math.ceil(xmd[0]);
        double ypt = 0.0;
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY().doubleValue(), this.constraints.getMinimumY().doubleValue());
        if (ym[1] > 0.0) {
            ypt = ym[1];
        } else if (ym[0] < 0.0) {
            ypt = ym[0];
        }
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        Point2D v = null;
        Point2D oldv = null;
        Line2D.Double ticks = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        FontRenderContext frc = this.c.getFontRenderContext();
        Font f = this.c.getTickFont();
        boolean paintLabels = this.c.isPaintLabels();
        g.setFont(f);
        int[] ticpoints = new ObjectTickLocator(xm[1], xm[0], this.getMaximumXTicks()).getTickMarkLocations();
        if (ticpoints == null) {
            return;
        }
        int li = 0;
        while (li < ticpoints.length) {
            Rectangle2D r;
            String sb;
            int i = ticpoints[li] - 1;
            ((Point2D)p).setLocation(i + 1, ypt);
            v = at.transform(p, null);
            ((Line2D)ticks).setLine(v.getX(), v.getY() - 3.0, v.getX(), v.getY() + 3.0);
            if (i + 1 < xm[0]) {
                g.draw(ticks);
            }
            if (!this.c.isCenterLabelsBetweenTicks() && paintLabels && this.model.getColumnValueAt(i) != null) {
                sb = this.model.getColumnValueAt(i).toString();
                r = f.getStringBounds(sb, frc);
                g.drawString(sb, (float)(v.getX() - r.getWidth() / 2.0), (float)(v.getY() + r.getHeight() + 6.0));
            }
            if (oldv != null && paintLabels && this.c.isCenterLabelsBetweenTicks() && this.model.getColumnValueAt(i) != null) {
                sb = this.model.getColumnValueAt(i).toString();
                r = f.getStringBounds(sb, frc);
                g.drawString(sb, (float)(oldv.getX() + (v.getX() - oldv.getX()) / 2.0 - r.getWidth() / 2.0), (float)(v.getY() + r.getHeight() + 6.0));
            }
            oldv = v;
            ++li;
        }
    }

    public void drawYAxisTicks(Graphics2D g) {
        AffineTransform at = this.c.getTransform(0);
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double xpt = 0.0;
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (xm[1] > 0.0) {
            xpt = xm[1];
        } else if (xm[0] < 0.0 && this.c.getSecondYAxis() != null) {
            xpt = xm[0];
        }
        Point2D.Double p = new Point2D.Double(0.0, 0.0);
        Line2D.Double ticks = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        boolean paint = true;
        DecimalFormat df = this.c.getYDecimalFormat();
        FontRenderContext frc = this.c.getFontRenderContext();
        Font f = this.c.getTickFont();
        Color backupColor = g.getColor();
        g.setFont(f);
        boolean paintLabels = this.c.isPaintLabels();
        double[] positions = new NumericTickLocator(ym[0], ym[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (positions == null) {
            return;
        }
        int i = 0;
        while (i < positions.length) {
            if (!(positions[i] < ym[1]) && !(positions[i] > ym[0])) {
                ((Point2D)p).setLocation(xpt, positions[i]);
                Point2D v = at.transform(p, null);
                ((Line2D)ticks).setLine(v.getX() - 3.0, v.getY(), v.getX() + 3.0, v.getY());
                g.draw(ticks);
                if (positions[i] != ym[1] && !this.c.isPaintOnlyTick()) {
                    Line2D xax = this.getXAxisLine2D();
                    ((Line2D)ticks).setLine(v.getX() + 3.0, v.getY(), xax.getX2(), v.getY());
                    g.setColor(Color.lightGray);
                    g.draw(ticks);
                    g.setColor(backupColor);
                }
                if (paintLabels && (paint || !this.c.isPaintAltTick())) {
                    String sb = df.format(positions[i]);
                    Rectangle2D r = f.getStringBounds(sb, frc);
                    g.drawString(sb, (float)(v.getX() - r.getWidth() - 6.0), (float)(v.getY() + r.getHeight() / 2.0));
                }
            }
            ++i;
        }
    }

    public void drawYAxisGrid(Graphics2D g) {
        Point2D[] points = this.getYTickLocations();
        AffineTransform at = this.c.getTransform(0);
        double xpt_last = 0.0;
        double xpt_first = 0.0;
        if (points == null) {
            return;
        }
        Color backupColor = g.getColor();
        Stroke backupStroke = g.getStroke();
        g.setStroke(GRID_LINE_STYLE);
        g.setColor(GRID_COLOR);
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        xpt_last = xm[0];
        xpt_first = xm[1];
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        int i = 0;
        while (i < points.length) {
            if (!(points[i].getY() < ym[1]) && !(points[i].getY() > ym[0])) {
                Point2D first_point = new Point2D.Double(xpt_first, points[i].getY());
                Point2D last_point = new Point2D.Double(xpt_last, points[i].getY());
                first_point = at.transform(first_point, null);
                last_point = at.transform(last_point, null);
                Line2D.Double grid_line = new Line2D.Double(first_point, last_point);
                g.draw(grid_line);
            }
            ++i;
        }
        g.setStroke(backupStroke);
        g.setColor(backupColor);
    }

    public void drawNumericalXAxisGrid(Graphics2D g) {
        Point2D[] points = this.getXTickLocations();
        AffineTransform at = this.c.getTransform(0);
        double ypt_last = 0.0;
        double ypt_first = 0.0;
        if (points == null) {
            return;
        }
        Color backupColor = g.getColor();
        Stroke backupStroke = g.getStroke();
        g.setStroke(GRID_LINE_STYLE);
        g.setColor(GRID_COLOR);
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        ypt_last = ym[0];
        ypt_first = ym[1];
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        int i = 0;
        while (i < points.length) {
            if (!(points[i].getX() < xm[1]) && !(points[i].getX() > xm[0])) {
                Point2D first_point = new Point2D.Double(points[i].getX(), ypt_first);
                Point2D last_point = new Point2D.Double(points[i].getX(), ypt_last);
                first_point = at.transform(first_point, null);
                last_point = at.transform(last_point, null);
                Line2D.Double grid_line = new Line2D.Double(first_point, last_point);
                g.draw(grid_line);
            }
            ++i;
        }
        g.setStroke(backupStroke);
        g.setColor(backupColor);
    }

    private Point2D[] getYTickLocations() {
        Point2D[] return_val = null;
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        double xpt = 0.0;
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (xm[1] > 0.0) {
            xpt = xm[1];
        } else if (xm[0] < 0.0 && this.c.getSecondYAxis() != null) {
            xpt = xm[0];
        }
        double[] positions = new NumericTickLocator(ym[0], ym[1], this.estimated_y_ticks, this.maximum_y_ticks).getTickMarkLocations();
        if (positions == null) {
            return null;
        }
        return_val = new Point2D[positions.length];
        int i = 0;
        while (i < positions.length) {
            return_val[i] = new Point2D.Double(xpt, positions[i]);
            ++i;
        }
        return return_val;
    }

    private Point2D[] getXTickLocations() {
        Point2D[] return_val = null;
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double ypt = 0.0;
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (ym[1] > 0.0) {
            ypt = ym[1];
        } else if (ym[0] < 0.0) {
            ypt = ym[0];
        }
        double[] positions = new NumericTickLocator(xm[0], xm[1], this.estimated_x_ticks, this.maximum_x_ticks).getTickMarkLocations();
        if (positions == null) {
            return null;
        }
        return_val = new Point2D[positions.length];
        int i = 0;
        while (i < positions.length) {
            return_val[i] = new Point2D.Double(positions[i], ypt);
            ++i;
        }
        return return_val;
    }

    public Line2D getXAxisLine2D() {
        double ypt = 0.0;
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        if (ym[1] > 0.0) {
            ypt = ym[1];
        } else if (ym[0] < 0.0) {
            ypt = ym[0];
        }
        AffineTransform at = this.c.getTransform(0);
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        Point2D l = at.transform(new Point2D.Double(xm[1], ypt), null);
        Point2D r = at.transform(new Point2D.Double(xm[0], ypt), null);
        return new Line2D.Double(l, r);
    }

    public Line2D getYAxisLine2D() {
        double xpt = 0.0;
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        if (xm[1] > 0.0) {
            xpt = xm[1];
        } else if (xm[0] < 0.0 && this.c.getSecondYAxis() != null) {
            xpt = xm[0];
        }
        AffineTransform at = this.c.getTransform(0);
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        Point2D o = at.transform(new Point2D.Double(xpt, ym[0]), null);
        Point2D u = at.transform(new Point2D.Double(xpt, ym[1]), null);
        return new Line2D.Double(o, u);
    }

    public Line2D getSecondYAxisLine2D() {
        double[] xm = this.safeMaxMin(this.constraints.getMaximumX(), this.constraints.getMinimumX());
        double xpt = xm[0];
        AffineTransform at = this.c.getTransform(1);
        double[] ym = this.safeMaxMin(this.constraints.getMaximumY(), this.constraints.getMinimumY());
        Point2D o = at.transform(new Point2D.Double(xpt, ym[0]), null);
        Point2D u = at.transform(new Point2D.Double(xpt, ym[1]), null);
        return new Line2D.Double(o, u);
    }

    private double[] computeTicMarkLocations(double max, double min, int numTicsDesired, int maxTics) {
        return this.computeTicMarkLocations(max, min, numTicsDesired, maxTics, false);
    }

    private double[] computeTicMarkLocations(double max, double min, int numTicsDesired, int maxTics, boolean force_simple) {
        this.tick_recursions = 0;
        if (numTicsDesired == 0) {
            return this.computeTicMarkLocations(max, min, 2, maxTics, true);
        }
        if (numTicsDesired <= 4 || force_simple) {
            return this.simpleTics(max, min, numTicsDesired);
        }
        return this.performAutoScale(max, min, numTicsDesired, maxTics);
    }

    private double[] simpleTics(double max, double min, int numTicsDesired) {
        if (numTicsDesired == 0) {
            return null;
        }
        double increment = (max - min) / (double)(numTicsDesired - 1);
        double[] return_val = new double[numTicsDesired];
        return_val[0] = min;
        int i = 1;
        while (i < numTicsDesired) {
            return_val[i] = return_val[i - 1] + increment;
            ++i;
        }
        return return_val;
    }

    private double[] performAutoScale(double max, double min, int numTicsDesired, int maxTics) {
        int internalDesired = numTicsDesired;
        if (numTicsDesired < 10 && this.tick_recursions == 0) {
            internalDesired = 10;
        }
        double d = (max - min) / (double)internalDesired;
        double ld = Math.log(d) / Math.log(10.0);
        int ild = (int)Math.round(ld);
        ++this.tick_recursions;
        int numDecimals = 0;
        if (ild < 0) {
            numDecimals = -ild;
        }
        double fld = Math.pow(10.0, ld - (double)ild);
        double ticValueIncrement = Math.pow(10.0, ild);
        if (fld > 5.0) {
            ticValueIncrement *= 10.0;
            if (--numDecimals < 0) {
                numDecimals = 0;
            }
        } else if (fld > 2.0) {
            ticValueIncrement = 5.0;
        } else if (fld > 1.0) {
            ticValueIncrement = 2.0;
        }
        double minAdjusted = Math.floor(min / ticValueIncrement) * ticValueIncrement;
        double maxAdjusted = Math.floor(max / ticValueIncrement + 0.99999) * ticValueIncrement;
        int numTicsActual = (int)Math.floor((maxAdjusted - minAdjusted) / ticValueIncrement + 1.0E-5);
        if (numTicsActual > maxTics && numTicsActual / 2 <= maxTics) {
            numTicsActual /= 2;
            ticValueIncrement *= 2.0;
        }
        if (numTicsActual > maxTics && maxTics < 5 || this.tick_recursions > Math.min(80, numTicsDesired - 2)) {
            return this.simpleTics(max, min, numTicsDesired);
        }
        if (numTicsActual > maxTics) {
            return this.performAutoScale(max, min, numTicsDesired - 1, maxTics);
        }
        if (numTicsActual < numTicsDesired / 2) {
            numTicsActual *= 2;
            ticValueIncrement /= 2.0;
        }
        if (ticValueIncrement == 0.0) {
            numTicsActual = 3;
            minAdjusted = min;
            ticValueIncrement = (max - min) / 2.0;
        }
        double[] return_val = new double[numTicsActual + 1];
        return_val[0] = minAdjusted;
        int i = 1;
        while (i <= numTicsActual) {
            return_val[i] = return_val[i - 1] + ticValueIncrement;
            ++i;
        }
        return return_val;
    }

    public void setEstimatedXTicks(int number) {
        this.estimated_x_ticks = number;
        this.checkMaxTickConsistency();
    }

    public void setEstimatedYTicks(int number) {
        this.estimated_y_ticks = number;
        this.checkMaxTickConsistency();
    }

    public int getEstimatedXTicks() {
        return this.estimated_x_ticks;
    }

    public int getEstimatedYTicks() {
        return this.estimated_x_ticks;
    }

    public void setMaximumXTicks(int value) {
        this.maximum_x_ticks = value >= 0 ? value : 40;
        this.checkMaxTickConsistency();
    }

    public void setMaximumYTicks(int value) {
        this.maximum_y_ticks = value >= 0 ? value : 40;
        this.checkMaxTickConsistency();
    }

    public int getMaximumXTicks() {
        return this.maximum_x_ticks;
    }

    public int getMaximumYTicks() {
        return this.maximum_y_ticks;
    }

    private void checkMaxTickConsistency() {
        if (this.maximum_x_ticks < this.estimated_x_ticks) {
            this.setEstimatedXTicks(this.maximum_x_ticks);
        }
        if (this.maximum_y_ticks < this.estimated_y_ticks) {
            this.setEstimatedYTicks(this.maximum_y_ticks);
        }
    }

    private double[] safeMaxMin(Number max, Number min) {
        try {
            return this.safeMaxMin(max.doubleValue(), min.doubleValue());
        }
        catch (NullPointerException npe) {
            double[] ret = new double[]{0.0, 1.0};
            return ret;
        }
    }

    private double[] safeMaxMin(double max, double min) {
        double[] maxmin = new double[2];
        if (max - min == 0.0) {
            if (max == 0.0) {
                max = 1.0;
                min = -1.0;
            } else {
                max *= 1.1;
                min *= 0.9;
            }
        }
        if (max < min) {
            double hold = max;
            max = min;
            min = hold;
        }
        maxmin[0] = max;
        maxmin[1] = min;
        return maxmin;
    }
}

