/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class InterpolationChartRenderer
extends AbstractChartRenderer {
    public InterpolationChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ChartDataModel m = this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = m.getDataSetNumber();
        Point2D paint = null;
        Point2D oldpaint = null;
        if (!m.isColumnNumeric()) {
            return false;
        }
        int set = 0;
        while (set < datasetcount && !this.getStopFlag()) {
            double[] x = new double[m.getDataSetLength(set)];
            double[] y = new double[x.length];
            int i = 0;
            while (i < m.getDataSetLength(set)) {
                x[i] = ((Number)m.getColumnValueAt(set, i)).doubleValue();
                if (x[i] != x[i]) {
                    x[i] = 0.0;
                }
                y[i] = m.getValueAt(set, i).doubleValue();
                if (this.getStopFlag()) {
                    this.resetStopFlag();
                    return false;
                }
                ++i;
            }
            int AMOUNT = 2000;
            double lowrange = m.getChartDataModelConstraints(0).getMinimumColumnValue();
            double hirange = m.getChartDataModelConstraints(0).getMaximumColumnValue();
            double[] xa = new double[AMOUNT];
            double[] ya = new double[AMOUNT];
            int i2 = 0;
            while (i2 < AMOUNT && !this.getStopFlag()) {
                xa[i2] = lowrange + (double)i2 * (Math.abs(hirange - lowrange) / (double)AMOUNT);
                ya[i2] = ChartUtilities.interpolate(x, y, xa[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < AMOUNT && !this.getStopFlag()) {
                Point2D.Double val = new Point2D.Double(xa[i2], ya[i2]);
                oldpaint = paint;
                if (yaxis1.transform(val, null) != null) {
                    paint = yaxis1.transform(val, paint);
                    g.setColor(rcm.getColor(set));
                    if (oldpaint != null) {
                        g.drawLine((int)oldpaint.getX(), (int)oldpaint.getY(), (int)paint.getX(), (int)paint.getY());
                    }
                }
                ++i2;
            }
            oldpaint = null;
            paint = null;
            ++set;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

