/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forester.clade_analysis.AnalysisMulti;
import org.forester.clade_analysis.Prefix;
import org.forester.clade_analysis.ResultMulti;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.EasyWriter;
import org.forester.util.ForesterUtil;
import org.forester.util.UserException;

public final class cladinator {
    private static final String PRG_NAME = "cladinator";
    private static final String PRG_VERSION = "1.07";
    private static final String PRG_DATE = "1711xx";
    private static final String PRG_DESC = "clades within clades of annotated labels -- analysis of pplacer-type outputs";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String SEP_OPTION = "s";
    private static final String QUERY_PATTERN_OPTION = "q";
    private static final String SPECIFICS_CUTOFF_OPTION = "c";
    private static final String MAPPING_FILE_OPTION = "m";
    private static final String EXTRA_PROCESSING_OPTION1 = "x";
    private static final String EXTRA_PROCESSING1_SEP_OPTION = "xs";
    private static final String EXTRA_PROCESSING1_KEEP_EXTRA_OPTION = "xk";
    private static final String QUIET_OPTION = "Q";
    private static final String SPECIAL_PROCESSING_OPTION = "S";
    private static final String VERBOSE_OPTION = "v";
    private static final String REMOVE_ANNOT_SEP_OPTION = "rs";
    private static final double SPECIFICS_CUTOFF_DEFAULT = 0.7;
    private static final String SEP_DEFAULT = ".";
    private static final Pattern QUERY_PATTERN_DEFAULT = AnalysisMulti.DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE;
    private static final String EXTRA_PROCESSING1_SEP_DEFAULT = "|";
    private static final boolean EXTRA_PROCESSING1_KEEP_EXTRA_DEFAULT = false;
    private static final DecimalFormat df = new DecimalFormat("0.0###");

    public static void main(String[] stringArray) {
        try {
            Object object;
            SortedMap<String, String> sortedMap;
            BasicTable<String> basicTable;
            File file;
            Object object2;
            Object object3;
            Object object4;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                cladinator.print_help();
                System.exit(0);
            }
            if (commandLineArguments.getNumberOfNames() != 1 && commandLineArguments.getNumberOfNames() != 2) {
                cladinator.print_help();
                System.exit(-1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(SEP_OPTION);
            arrayList.add(QUERY_PATTERN_OPTION);
            arrayList.add(SPECIFICS_CUTOFF_OPTION);
            arrayList.add(MAPPING_FILE_OPTION);
            arrayList.add(EXTRA_PROCESSING_OPTION1);
            arrayList.add(EXTRA_PROCESSING1_SEP_OPTION);
            arrayList.add(EXTRA_PROCESSING1_KEEP_EXTRA_OPTION);
            arrayList.add(SPECIAL_PROCESSING_OPTION);
            arrayList.add(VERBOSE_OPTION);
            arrayList.add(QUIET_OPTION);
            arrayList.add(REMOVE_ANNOT_SEP_OPTION);
            String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
            }
            double d = 0.7;
            if (commandLineArguments.isOptionSet(SPECIFICS_CUTOFF_OPTION)) {
                if (commandLineArguments.isOptionValueSet(SPECIFICS_CUTOFF_OPTION)) {
                    d = commandLineArguments.getOptionValueAsDouble(SPECIFICS_CUTOFF_OPTION);
                    if (d < 0.0) {
                        ForesterUtil.fatalError(PRG_NAME, "cutoff cannot be negative");
                    }
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for cutoff for specifics");
                }
            }
            String string2 = SEP_DEFAULT;
            if (commandLineArguments.isOptionSet(SEP_OPTION)) {
                if (commandLineArguments.isOptionValueSet(SEP_OPTION)) {
                    string2 = commandLineArguments.getOptionValue(SEP_OPTION);
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for separator option");
                }
            }
            Pattern pattern = null;
            if (commandLineArguments.isOptionSet(QUERY_PATTERN_OPTION)) {
                if (commandLineArguments.isOptionValueSet(QUERY_PATTERN_OPTION)) {
                    object4 = commandLineArguments.getOptionValue(QUERY_PATTERN_OPTION);
                    try {
                        pattern = Pattern.compile((String)object4);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        ForesterUtil.fatalError(PRG_NAME, "error in regular expression: " + (String)object4 + ": " + patternSyntaxException.getMessage());
                    }
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for query pattern option");
                }
            }
            object4 = null;
            if (commandLineArguments.isOptionSet(MAPPING_FILE_OPTION)) {
                if (commandLineArguments.isOptionValueSet(MAPPING_FILE_OPTION)) {
                    object3 = commandLineArguments.getOptionValue(MAPPING_FILE_OPTION);
                    object2 = ForesterUtil.isReadableFile((String)object3);
                    if (!ForesterUtil.isEmpty((String)object2)) {
                        ForesterUtil.fatalError(PRG_NAME, (String)object2);
                    }
                    object4 = new File((String)object3);
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for mapping file");
                }
            }
            object3 = pattern != null ? pattern : QUERY_PATTERN_DEFAULT;
            object2 = commandLineArguments.getFile(0);
            String string3 = ForesterUtil.isReadableFile((File)object2);
            if (!ForesterUtil.isEmpty(string3)) {
                ForesterUtil.fatalError(PRG_NAME, string3);
            }
            if (commandLineArguments.getNumberOfNames() > 1) {
                file = commandLineArguments.getFile(1);
                basicTable = ForesterUtil.isWritableFile(file);
                if (!ForesterUtil.isEmpty((String)((Object)basicTable))) {
                    ForesterUtil.fatalError(PRG_NAME, (String)((Object)basicTable));
                }
            } else {
                file = null;
            }
            if (object4 != null) {
                basicTable = BasicTableParser.parse(object4, '\t');
                if (basicTable.getNumberOfColumns() != 2) {
                    ForesterUtil.fatalError(PRG_NAME, "mapping file needs to have 2 tab-separated columns, not " + basicTable.getNumberOfColumns());
                }
                sortedMap = basicTable.getColumnsAsMap(0, 1);
            } else {
                basicTable = null;
                sortedMap = null;
            }
            boolean bl = commandLineArguments.isOptionSet(EXTRA_PROCESSING_OPTION1);
            String string4 = EXTRA_PROCESSING1_SEP_DEFAULT;
            if (commandLineArguments.isOptionSet(EXTRA_PROCESSING1_SEP_OPTION)) {
                if (!bl) {
                    ForesterUtil.fatalError(PRG_NAME, "extra processing is not enabled, cannot set -xs option");
                }
                if (commandLineArguments.isOptionValueSet(EXTRA_PROCESSING1_SEP_OPTION)) {
                    string4 = commandLineArguments.getOptionValue(EXTRA_PROCESSING1_SEP_OPTION);
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for extra processing separator");
                }
            }
            if (string4 != null && string4.equals(string2)) {
                ForesterUtil.fatalError(PRG_NAME, "extra processing separator must not be the same the annotation-separator");
            }
            boolean bl2 = false;
            if (commandLineArguments.isOptionSet(EXTRA_PROCESSING1_KEEP_EXTRA_OPTION)) {
                if (!bl) {
                    ForesterUtil.fatalError(PRG_NAME, "extra processing is not enabled, cannot set -xk option");
                }
                bl2 = true;
            }
            Pattern pattern2 = null;
            boolean bl3 = false;
            if (commandLineArguments.isOptionSet(SPECIAL_PROCESSING_OPTION)) {
                if (bl) {
                    ForesterUtil.fatalError(PRG_NAME, "extra processing cannot be used together with special processing pattern");
                }
                if (commandLineArguments.isOptionValueSet(SPECIAL_PROCESSING_OPTION)) {
                    String string5 = commandLineArguments.getOptionValue(SPECIAL_PROCESSING_OPTION);
                    try {
                        pattern2 = Pattern.compile(string5);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        ForesterUtil.fatalError(PRG_NAME, "error in special processing pattern: " + string5 + ": " + patternSyntaxException.getMessage());
                    }
                    bl3 = true;
                } else {
                    ForesterUtil.fatalError(PRG_NAME, "no value for special processing pattern");
                }
            }
            boolean bl4 = commandLineArguments.isOptionSet(REMOVE_ANNOT_SEP_OPTION);
            boolean bl5 = commandLineArguments.isOptionSet(VERBOSE_OPTION);
            boolean bl6 = commandLineArguments.isOptionSet(QUIET_OPTION);
            System.out.println("Input tree                 : " + object2);
            System.out.println("Specific-hit support cutoff: " + d);
            if (object4 != null) {
                System.out.println("Mapping file               : " + object4 + " (" + basicTable.getNumberOfRows() + " rows)");
            }
            System.out.println("Annotation-separator       : " + string2);
            if (bl4) {
                System.out.println("Remove anno.-sep. in output: " + bl4);
            }
            System.out.println("Query pattern              : " + object3);
            if (bl) {
                System.out.println("Extra processing           : " + bl);
                System.out.println("Extra processing separator : " + string4);
                System.out.println("Keep extra annotations     : " + bl2);
            }
            if (bl3) {
                System.out.println("Special processing         : " + bl3);
                System.out.println("Special processing pattern : " + pattern2);
            }
            if (file != null) {
                System.out.println("Output table               : " + file);
            }
            Phylogeny[] phylogenyArray = null;
            try {
                object = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType((File)object2, true);
                phylogenyArray = object.create(object2, phylogenyParser);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + object2 + "\" [" + iOException.getMessage() + "]");
            }
            if (phylogenyArray.length == 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + object2 + "\" does not contain any trees");
            }
            System.out.println("Number of input trees      : " + phylogenyArray.length);
            if (phylogenyArray.length == 1) {
                System.out.println("Ext. nodes in input tree   : " + phylogenyArray[0].getNumberOfExternalNodes());
            } else {
                System.out.println("Ext. nodes in input tree 1 : " + phylogenyArray[0].getNumberOfExternalNodes());
            }
            if (file != null) {
                object = ForesterUtil.createEasyWriter(file);
                ((EasyWriter)object).print("#cladinator 1.07 1711xx");
                ((EasyWriter)object).print(" Input tree: " + object2);
                ((EasyWriter)object).println(" Specific-hit support cutoff: " + d);
            } else {
                object = null;
            }
            int n = 0;
            for (Phylogeny phylogeny : phylogenyArray) {
                if (sortedMap != null) {
                    AnalysisMulti.performMapping((Pattern)object3, sortedMap, phylogeny, bl5);
                }
                if (bl) {
                    AnalysisMulti.performExtraProcessing1((Pattern)object3, phylogeny, string4, bl2, string2, bl5);
                } else if (bl3) {
                    AnalysisMulti.performSpecialProcessing1((Pattern)object3, phylogeny, string2, pattern2, bl5);
                }
                ResultMulti resultMulti = AnalysisMulti.execute(phylogeny, (Pattern)object3, string2, d);
                if (!bl6) {
                    if (phylogenyArray.length == 1) {
                        cladinator.printResult(resultMulti, -1, bl4);
                    } else {
                        cladinator.printResult(resultMulti, n, bl4);
                    }
                }
                if (object != null) {
                    cladinator.writeResultToTable(resultMulti, (EasyWriter)object, bl4);
                    ((BufferedWriter)object).flush();
                }
                ++n;
            }
            if (object != null) {
                ((BufferedWriter)object).flush();
                ((BufferedWriter)object).close();
            }
        }
        catch (UserException userException) {
            ForesterUtil.fatalError(PRG_NAME, userException.getMessage());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, "Unexpected errror!");
        }
    }

    private static final void printResult(ResultMulti resultMulti, int n, boolean bl) {
        System.out.println();
        if (n == -1) {
            System.out.println("Result for " + resultMulti.getQueryNamePrefix());
        } else {
            System.out.println("Result for " + resultMulti.getQueryNamePrefix() + " [tree " + n + "]");
        }
        if (resultMulti.getAllMultiHitPrefixes() == null | resultMulti.getAllMultiHitPrefixes().size() < 1) {
            System.out.println(" No match to query pattern!");
        } else {
            System.out.println(" Matching Clade(s):");
            for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixes()) {
                if (bl) {
                    System.out.println(" " + prefix.toStringRemovSeparator());
                    continue;
                }
                System.out.println(" " + prefix);
            }
            if (resultMulti.isHasSpecificMultiHitsPrefixes()) {
                System.out.println();
                System.out.println(" Specific-hit(s):");
                for (Prefix prefix : resultMulti.getSpecificMultiHitPrefixes()) {
                    if (bl) {
                        System.out.println(" " + prefix.toStringRemovSeparator());
                        continue;
                    }
                    System.out.println(" " + prefix);
                }
                System.out.println();
                System.out.println(" Matching Clade(s) with Specific-hit(s):");
                for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixes()) {
                    if (bl) {
                        System.out.println(" " + prefix.toStringRemovSeparator());
                    } else {
                        System.out.println(" " + prefix);
                    }
                    for (Prefix prefix2 : resultMulti.getSpecificMultiHitPrefixes()) {
                        if (!prefix2.getPrefix().startsWith(prefix.getPrefix())) continue;
                        if (bl) {
                            System.out.println("     " + prefix2.toStringRemovSeparator());
                            continue;
                        }
                        System.out.println("     " + prefix2);
                    }
                }
            }
            if (!ForesterUtil.isEmpty(resultMulti.getAllMultiHitPrefixesDown())) {
                System.out.println();
                System.out.println(" Matching Down-tree Bracketing Clade(s):");
                for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixesDown()) {
                    if (bl) {
                        System.out.println(" " + prefix.toStringRemovSeparator());
                        continue;
                    }
                    System.out.println(" " + prefix);
                }
            }
            if (!ForesterUtil.isEmpty(resultMulti.getAllMultiHitPrefixesUp())) {
                System.out.println();
                System.out.println(" Matching Up-tree Bracketing Clade(s):");
                for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixesUp()) {
                    if (bl) {
                        System.out.println(" " + prefix.toStringRemovSeparator());
                        continue;
                    }
                    System.out.println(" " + prefix);
                }
            }
            System.out.println();
            System.out.println(" Total Number of Matches: " + resultMulti.getNumberOfMatches() + "/" + resultMulti.getReferenceTreeNumberOfExternalNodes());
        }
        System.out.println();
    }

    private static final void writeResultToTable(ResultMulti resultMulti, EasyWriter easyWriter, boolean bl) throws IOException {
        if (resultMulti.getAllMultiHitPrefixes() == null | resultMulti.getAllMultiHitPrefixes().size() < 1) {
            easyWriter.print(resultMulti.getQueryNamePrefix());
            easyWriter.print("\t");
            easyWriter.println("No match to query pattern!");
        } else {
            for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixes()) {
                easyWriter.print(resultMulti.getQueryNamePrefix());
                easyWriter.print("\t");
                easyWriter.print("Matching Clades");
                easyWriter.print("\t");
                if (bl) {
                    easyWriter.print(prefix.getPrefixRemovSeparator());
                } else {
                    easyWriter.print(prefix.getPrefix());
                }
                easyWriter.print("\t");
                easyWriter.print(df.format(prefix.getConfidence()));
                easyWriter.print("\t");
                easyWriter.print(String.valueOf(resultMulti.getNumberOfMatches()));
                easyWriter.print("\t");
                easyWriter.print(String.valueOf(resultMulti.getReferenceTreeNumberOfExternalNodes()));
                easyWriter.println();
            }
            if (resultMulti.isHasSpecificMultiHitsPrefixes()) {
                for (Prefix prefix : resultMulti.getSpecificMultiHitPrefixes()) {
                    easyWriter.print(resultMulti.getQueryNamePrefix());
                    easyWriter.print("\t");
                    easyWriter.print("Specific-hits");
                    easyWriter.print("\t");
                    if (bl) {
                        easyWriter.print(prefix.getPrefixRemovSeparator());
                    } else {
                        easyWriter.print(prefix.getPrefix());
                    }
                    easyWriter.print("\t");
                    easyWriter.print(df.format(prefix.getConfidence()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getNumberOfMatches()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getReferenceTreeNumberOfExternalNodes()));
                    easyWriter.println();
                }
            }
            if (!ForesterUtil.isEmpty(resultMulti.getAllMultiHitPrefixesDown())) {
                for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixesDown()) {
                    easyWriter.print(resultMulti.getQueryNamePrefix());
                    easyWriter.print("\t");
                    easyWriter.print("Matching Down-tree Bracketing Clades");
                    easyWriter.print("\t");
                    if (bl) {
                        easyWriter.print(prefix.getPrefixRemovSeparator());
                    } else {
                        easyWriter.print(prefix.getPrefix());
                    }
                    easyWriter.print("\t");
                    easyWriter.print(df.format(prefix.getConfidence()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getNumberOfMatches()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getReferenceTreeNumberOfExternalNodes()));
                    easyWriter.println();
                }
            }
            if (!ForesterUtil.isEmpty(resultMulti.getAllMultiHitPrefixesUp())) {
                for (Prefix prefix : resultMulti.getCollapsedMultiHitPrefixesUp()) {
                    easyWriter.print(resultMulti.getQueryNamePrefix());
                    easyWriter.print("\t");
                    easyWriter.print("Matching Up-tree Bracketing Clades");
                    easyWriter.print("\t");
                    if (bl) {
                        easyWriter.print(prefix.getPrefixRemovSeparator());
                    } else {
                        easyWriter.print(prefix.getPrefix());
                    }
                    easyWriter.print("\t");
                    easyWriter.print(df.format(prefix.getConfidence()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getNumberOfMatches()));
                    easyWriter.print("\t");
                    easyWriter.print(String.valueOf(resultMulti.getReferenceTreeNumberOfExternalNodes()));
                    easyWriter.println();
                }
            }
        }
    }

    private static final void print_help() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("cladinator [options] <input tree(s) file> [output table file]");
        System.out.println();
        System.out.println(" options:");
        System.out.println("  -c=<double>        : the minimal confidence value for \"specific-hits\" to be reported (default: 0.7)");
        System.out.println("  -s=<separator>     : the annotation-separator to be used (default: \".\")");
        System.out.println("  -m=<mapping table> : to map node names to appropriate annotations (tab-separated, two columns) (default: no mapping)");
        System.out.println("  -x                 : to enable extra processing of annotations (e.g. \"Q16611|A.1.1\" becomes \"A.1.1\")");
        System.out.println("  -xs=<separator>    : the separator for extra annotations (default: \"|\")");
        System.out.println("  -xk                : to keep extra annotations (e.g. \"Q16611|A.1.1\" becomes \"A.1.1.Q16611\")");
        System.out.println("  -S=<pattern>       : special processing with pattern (e.g. \"(\\d+)([a-z]+)_.+\" for changing \"6q_EF42\" to \"6.q\")");
        System.out.println("  -rs                : to remove the annotation-separator in the output (e.g. the \".\")");
        System.out.println("  -v                 : verbose");
        System.out.println("  -Q                 : quiet (no output to console, for when used in a pipeline)");
        System.out.println("  --q=<pattern>      : expert option: the regular expression pattern for the query (default: \"" + QUERY_PATTERN_DEFAULT + "\" for pplacer output)");
        System.out.println();
        System.out.println("Examples:");
        System.out.println();
        System.out.println(" cladinator pp_out_tree.sing.tre result.tsv");
        System.out.println(" cladinator -c=0.5 -s=. pp_out_tree.sing.tre result.tsv");
        System.out.println(" cladinator -c=0.9 -s=_ -m=map.tsv pp_out_trees.sing.tre result.tsv");
        System.out.println(" cladinator -x -xs=& -xk pp_out_trees.sing.tre result.tsv");
        System.out.println(" cladinator -x -xs=\"|\" pp_out_trees.sing.tre result.tsv");
        System.out.println(" cladinator -x -xk -m=map.tsv pp_out_trees.sing.tre result.tsv");
        System.out.println(" cladinator -m=map.tsv -S='(\\d+)([a-z?]*)_.+' pp_out_trees.sing.tre result.tsv");
        System.out.println();
    }
}

