/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.MolecularSequence;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class fasta_split {
    private static final String PRG_NAME = "fasta_split";
    private static final String PRG_VERSION = "1.01";
    private static final String PRG_DATE = "170718";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (stringArray.length != 3) {
            fasta_split.argumentsError();
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        String string = commandLineArguments.getName(0);
        File file = commandLineArguments.getFile(1);
        File file2 = commandLineArguments.getFile(2);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        String string2 = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string2)) {
            ForesterUtil.fatalError(PRG_NAME, string2);
        }
        if (!file2.exists()) {
            new File(file2.toString()).mkdir();
        }
        if (!file2.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, file2 + " is not a directory");
        }
        List<MolecularSequence> list = null;
        try {
            list = FastaParser.parse(new FileInputStream(file));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        if (list == null || list.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, file + " appears empty");
        }
        System.out.println("Read " + list.size() + " sequences");
        HashMap hashMap = new HashMap();
        for (MolecularSequence molecularSequence : list) {
            Matcher matcher = pattern.matcher(molecularSequence.getIdentifier());
            if (matcher.find()) {
                String object = matcher.group(1);
                if (!hashMap.containsKey(object)) {
                    hashMap.put(object, new ArrayList());
                }
                ((List)hashMap.get(object)).add(molecularSequence);
                continue;
            }
            System.out.println("warning: " + string + " not found in sequence \"" + molecularSequence.getIdentifier() + "\"");
            if (!hashMap.containsKey("unknown")) {
                hashMap.put("unknown", new ArrayList());
            }
            ((List)hashMap.get("unknown")).add(molecularSequence);
        }
        int n = 0;
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string3 = ((String)entry.getKey()).trim();
            string3 = string3.replaceAll("[\\./\\*\\s]+", "_");
            string3 = string3.replaceAll("\\(", "~");
            string3 = string3.replaceAll("\\)", "~");
            File file3 = new File(file2.getAbsolutePath().toString() + "/" + string3 + ".fasta");
            if (file3.exists()) {
                ForesterUtil.fatalError(PRG_NAME, file3 + " already exists");
            }
            System.out.println(++n + ": writing " + file3 + " [" + ((List)entry.getValue()).size() + " seqs]");
            try {
                SequenceWriter.writeSeqs((List<MolecularSequence>)((List)entry.getValue()), file3, SequenceWriter.SEQ_FORMAT.FASTA, 60);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            n2 += ((List)entry.getValue()).size();
        }
        System.out.println("Wrote " + n2 + " sequences");
    }

    private static void argumentsError() {
        System.out.println("fasta_split <pattern> <infile> <outdir>");
        System.out.println();
        System.out.println("Examples: ");
        System.out.println("  fasta_split \"v-germ=(\\S+)\" tt.fasta outdir");
        System.out.println("  fasta_split \"(\\S+?)\\|\" seqs.fasta outdir");
        System.out.println("  fasta_split \"OS=(.+?)[A-Z]{2}=\" seqs.fasta outdir");
        System.out.println();
        System.exit(-1);
    }
}

