/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.data.PropertyParser;
import org.forester.io.parsers.phyloxml.data.UriParser;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesList;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Uri;

public class AnnotationParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private AnnotationParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement xmlElement) throws PhyloXmlDataFormatException {
        Annotation annotation = xmlElement.isHasAttribute("ref") ? new Annotation(xmlElement.getAttribute("ref")) : new Annotation();
        if (xmlElement.isHasAttribute("type")) {
            annotation.setType(xmlElement.getAttribute("type"));
        }
        if (xmlElement.isHasAttribute("evidence")) {
            annotation.setEvidence(xmlElement.getAttribute("evidence"));
        }
        if (xmlElement.isHasAttribute("source")) {
            annotation.setSource(xmlElement.getAttribute("source"));
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("desc")) {
                annotation.setDesc(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("confidence")) {
                annotation.setConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("uri")) {
                annotation.addUri((Uri)UriParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("property")) continue;
            if (annotation.getProperties() == null) {
                annotation.setProperties(new PropertiesList());
            }
            annotation.getProperties().addProperty((Property)PropertyParser.getInstance().parse(xmlElement2));
        }
        return annotation;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new AnnotationParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

